/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.net.ClientboundManagerGuiPacket;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.OpenContainerTracker;
import ca.teamdman.sfm.common.util.SFMContainerUtil;
import ca.teamdman.sfml.ast.Program;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class ManagerBlockEntity
extends BaseContainerBlockEntity {
    public static final int TICK_TIME_HISTORY_SIZE = 20;
    private final NonNullList<ItemStack> ITEMS = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final long[] tickTimeNanos = new long[20];
    @Nullable
    private Program program = null;
    private int tick = 0;
    private int unprocessedRedstonePulses = 0;
    private boolean shouldRebuildProgram = false;
    private int tickIndex = 0;

    public ManagerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)SFMBlockEntities.MANAGER_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ManagerBlockEntity tile) {
        boolean didSomething;
        long start = System.nanoTime();
        ++tile.tick;
        if (tile.shouldRebuildProgram) {
            tile.rebuildProgramAndUpdateDisk();
            tile.shouldRebuildProgram = false;
        }
        if (tile.program != null && (didSomething = tile.program.tick(tile))) {
            long nanoTimePassed = Long.min(System.nanoTime() - start, Integer.MAX_VALUE);
            tile.tickTimeNanos[tile.tickIndex] = (int)nanoTimePassed;
            tile.tickIndex = (tile.tickIndex + 1) % tile.tickTimeNanos.length;
            tile.sendUpdatePacket();
        }
    }

    private void sendUpdatePacket() {
        OpenContainerTracker.getPlayersWithOpenContainer(ManagerContainerMenu.class).filter(entry -> ((ManagerContainerMenu)((Object)((Object)entry.getValue()))).MANAGER_POSITION.equals((Object)this.m_58899_())).forEach(entry -> SFMPackets.MANAGER_CHANNEL.send(PacketDistributor.PLAYER.with(entry::getKey), (Object)new ClientboundManagerGuiPacket(((ManagerContainerMenu)((Object)((Object)entry.getValue()))).f_38840_, this.getProgramString().orElse(""), this.getState(), this.getTickTimeNanos())));
    }

    public int getTick() {
        return this.tick;
    }

    public Optional<Program> getProgram() {
        return Optional.ofNullable(this.program);
    }

    public void setProgram(String program) {
        this.getDisk().ifPresent(disk -> {
            DiskItem.setProgram(disk, program);
            this.rebuildProgramAndUpdateDisk();
            this.m_6596_();
        });
    }

    public void trackRedstonePulseUnprocessed() {
        ++this.unprocessedRedstonePulses;
    }

    public void clearRedstonePulseQueue() {
        this.unprocessedRedstonePulses = 0;
    }

    public int getUnprocessedRedstonePulseCount() {
        return this.unprocessedRedstonePulses;
    }

    public State getState() {
        if (this.getDisk().isEmpty()) {
            return State.NO_DISK;
        }
        if (this.getProgramString().isEmpty()) {
            return State.NO_PROGRAM;
        }
        if (this.program == null) {
            return State.INVALID_PROGRAM;
        }
        return State.RUNNING;
    }

    public Optional<String> getProgramString() {
        return this.getDisk().map(DiskItem::getProgram).filter(prog -> !prog.isBlank());
    }

    public Set<String> getReferencedLabels() {
        if (this.program == null) {
            return Collections.emptySet();
        }
        return this.program.referencedLabels();
    }

    public Optional<ItemStack> getDisk() {
        ItemStack item = this.m_8020_(0);
        if (item.m_41720_() instanceof DiskItem) {
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public void rebuildProgramAndUpdateDisk() {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            return;
        }
        this.program = this.getDisk().flatMap(itemStack -> DiskItem.updateDetails(itemStack, this)).orElse(null);
        this.sendUpdatePacket();
    }

    protected Component m_6820_() {
        return Constants.LocalizationKeys.MANAGER_CONTAINER.getComponent();
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory inv) {
        return new ManagerContainerMenu(windowId, inv, this);
    }

    public int m_6643_() {
        return this.ITEMS.size();
    }

    public boolean m_7983_() {
        return this.ITEMS.isEmpty();
    }

    public ItemStack m_8020_(int slot) {
        if (slot < 0 || slot >= this.ITEMS.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.ITEMS.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = ContainerHelper.m_18969_(this.ITEMS, (int)slot, (int)amount);
        if (slot == 0) {
            this.rebuildProgramAndUpdateDisk();
        }
        this.m_6596_();
        return result;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack result = ContainerHelper.m_18966_(this.ITEMS, (int)slot);
        if (slot == 0) {
            this.rebuildProgramAndUpdateDisk();
        }
        this.m_6596_();
        return result;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.ITEMS.size()) {
            return;
        }
        this.ITEMS.set(slot, (Object)stack);
        if (slot == 0) {
            this.rebuildProgramAndUpdateDisk();
        }
        this.m_6596_();
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return stack.m_41720_() instanceof DiskItem;
    }

    public boolean m_6542_(Player player) {
        return SFMContainerUtil.stillValid((BlockEntity)this, player);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.ITEMS);
        this.shouldRebuildProgram = true;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.ITEMS);
    }

    public void m_6211_() {
        this.ITEMS.clear();
    }

    public void reset() {
        this.getDisk().ifPresent(disk -> {
            disk.m_41751_(null);
            this.m_6836_(0, (ItemStack)disk);
            this.m_6596_();
        });
    }

    public long[] getTickTimeNanos() {
        long[] result = new long[this.tickTimeNanos.length];
        System.arraycopy(this.tickTimeNanos, this.tickIndex, result, 0, this.tickTimeNanos.length - this.tickIndex);
        System.arraycopy(this.tickTimeNanos, 0, result, this.tickTimeNanos.length - this.tickIndex, this.tickIndex);
        return result;
    }

    public static enum State {
        NO_PROGRAM(ChatFormatting.RED, Constants.LocalizationKeys.MANAGER_GUI_STATE_NO_PROGRAM),
        NO_DISK(ChatFormatting.RED, Constants.LocalizationKeys.MANAGER_GUI_STATE_NO_DISK),
        RUNNING(ChatFormatting.GREEN, Constants.LocalizationKeys.MANAGER_GUI_STATE_RUNNING),
        INVALID_PROGRAM(ChatFormatting.DARK_RED, Constants.LocalizationKeys.MANAGER_GUI_STATE_INVALID_PROGRAM);

        public final ChatFormatting COLOR;
        public final Constants.LocalizationKeys.LocalizationEntry LOC;

        private State(ChatFormatting color, Constants.LocalizationKeys.LocalizationEntry loc) {
            this.COLOR = color;
            this.LOC = loc;
        }
    }
}

