/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.items;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.structurecompass.config.StructureConfig;
import com.mrbysco.structurecompass.network.PacketHandler;
import com.mrbysco.structurecompass.network.message.OpenCompassMessage;
import com.mrbysco.structurecompass.util.StructureUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.network.PacketDistributor;

public class StructureCompassItem
extends Item {
    public StructureCompassItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (playerIn.m_6144_()) {
            if (!worldIn.f_46443_) {
                List<ResourceLocation> allStructures = StructureUtil.getAvailableStructureList(worldIn);
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)playerIn), (Object)new OpenCompassMessage(hand, stack, allStructures));
            }
        } else {
            this.locateStructure(stack, playerIn);
        }
        return super.m_7203_(worldIn, playerIn, hand);
    }

    private void locateStructure(ItemStack stack, Player player) {
        if (!player.m_9236_().f_46443_) {
            if (stack.m_41782_() && stack.m_41783_().m_128441_("structurecompass:structureName")) {
                ServerLevel level = (ServerLevel)player.m_9236_();
                CompoundTag tag = stack.m_41783_();
                String boundStructure = tag.m_128461_("structurecompass:structureName");
                ResourceLocation structureLocation = ResourceLocation.m_135820_((String)boundStructure);
                if (structureLocation != null && !StructureUtil.isBlacklisted(structureLocation)) {
                    player.m_213846_((Component)Component.m_237110_((String)"structurecompass.structure.locating", (Object[])new Object[]{structureLocation}).m_130940_(ChatFormatting.YELLOW));
                    Registry registry = level.m_9598_().m_175515_(Registries.f_256944_);
                    ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureLocation);
                    HolderSet featureHolderSet = registry.m_203636_(structureKey).map(holders -> HolderSet.m_205809_((Holder[])new Holder[]{holders})).orElse(null);
                    if (featureHolderSet != null) {
                        Pair<BlockPos, Holder<Structure>> pair;
                        BlockPos structurePos;
                        boolean findUnexplored = false;
                        if (StructureConfig.COMMON.locateUnexplored.get() != null) {
                            findUnexplored = (Boolean)StructureConfig.COMMON.locateUnexplored.get();
                        }
                        BlockPos blockPos = structurePos = (pair = StructureUtil.findNearestMapStructure(level, (HolderSet<Structure>)featureHolderSet, player.m_20183_(), 100, findUnexplored)) != null ? (BlockPos)pair.getFirst() : null;
                        if (structurePos == null) {
                            tag.m_128379_("structurecompass:structureFound", false);
                            tag.m_128473_("structurecompass:structurePosition");
                            tag.m_128473_("structurecompass:structureDimension");
                            int range = (Integer)StructureConfig.COMMON.compassRange.get();
                            player.m_213846_((Component)Component.m_237110_((String)"structurecompass.structure.failed", (Object[])new Object[]{boundStructure, range}).m_130940_(ChatFormatting.RED));
                        } else {
                            tag.m_128379_("structurecompass:structureFound", true);
                            tag.m_128356_("structurecompass:structurePosition", structurePos.m_121878_());
                            tag.m_128359_("structurecompass:structureDimension", level.m_46472_().m_135782_().toString());
                            int distance = player.m_20183_().m_123333_((Vec3i)structurePos);
                            player.m_213846_((Component)Component.m_237110_((String)"structurecompass.structure.found", (Object[])new Object[]{boundStructure, distance}).m_130940_(ChatFormatting.GREEN));
                        }
                        stack.m_41751_(tag);
                        player.m_36335_().m_41524_((Item)this, 100);
                    }
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"structurecompass.locate.fail").m_130940_(ChatFormatting.RED));
                }
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"structurecompass.structure.unset.tooltip").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            String structureName = tag.m_128461_("structurecompass:structureName");
            boolean structureFound = tag.m_128471_("structurecompass:structureFound");
            if (structureFound) {
                ResourceLocation structureDimension = ResourceLocation.m_135820_((String)tag.m_128461_("structurecompass:structureDimension"));
                if (level != null && level.m_46472_().m_135782_().equals((Object)structureDimension)) {
                    tooltip.add((Component)Component.m_237110_((String)"structurecompass.structure.found.tooltip", (Object[])new Object[]{structureName}).m_130940_(ChatFormatting.GREEN));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"structurecompass.structure.wrong_dimension.tooltip", (Object[])new Object[]{structureName}).m_130940_(ChatFormatting.RED));
                }
            } else {
                tooltip.add((Component)Component.m_237110_((String)"structurecompass.structure.failed.tooltip", (Object[])new Object[]{structureName}).m_130940_(ChatFormatting.RED));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"structurecompass.structure.unset.tooltip").m_130940_(ChatFormatting.GOLD));
        }
    }
}

