/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.stargate.SymbolSet;

public class Symbols {
    public static final ResourceLocation ERROR_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/error.png");
    public static final ResourceLocation SYMBOLS_LOCATION = new ResourceLocation("sgjourney", "symbols");
    public static final ResourceKey<Registry<Symbols>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)SYMBOLS_LOCATION);
    public static final Codec<ResourceKey<Symbols>> RESOURCE_KEY_CODEC = ResourceKey.m_195966_(REGISTRY_KEY);
    public static final Codec<Symbols> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Symbols::getName), (App)SymbolSet.RESOURCE_KEY_CODEC.fieldOf("symbol_set").forGetter(Symbols::getSymbolSet), (App)ResourceLocation.f_135803_.listOf().fieldOf("textures").forGetter(Symbols::getTextures)).apply((Applicative)instance, Symbols::new));
    private final String name;
    private final ResourceKey<SymbolSet> symbolSet;
    private final List<ResourceLocation> textures;

    public Symbols(String name, ResourceKey<SymbolSet> symbolSet, List<ResourceLocation> textures) {
        this.name = name;
        this.symbolSet = symbolSet;
        this.textures = textures;
    }

    public String getName() {
        return this.name;
    }

    public String getName(boolean uniqueSymbols) {
        if (!ClientStargateConfig.unique_symbols.get()) {
            SymbolSet symbolSet = SymbolSet.getClientSymbolSet(this.symbolSet);
            return symbolSet.getName();
        }
        return this.name;
    }

    public ResourceKey<SymbolSet> getSymbolSet() {
        return this.symbolSet;
    }

    public List<ResourceLocation> getTextures() {
        return this.textures;
    }

    public ResourceLocation texture(int i) {
        if (ClientStargateConfig.unique_symbols.get()) {
            if (i >= this.textures.size() || i < 0) {
                return ERROR_LOCATION;
            }
            ResourceLocation path = this.textures.get(i);
            ResourceLocation texture = new ResourceLocation(path.m_135827_(), "textures/symbols/" + path.m_135815_());
            return texture;
        }
        SymbolSet symbolSet = SymbolSet.getClientSymbolSet(this.symbolSet);
        return symbolSet.texture(i);
    }

    public static Symbols getSymbols(Level level, ResourceKey<Symbols> symbols) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (Symbols)registry.m_6246_(symbols);
    }

    public static Symbols getSymbols(Level level, String name) {
        String[] split = name.split(":");
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (Symbols)registry.m_7745_(new ResourceLocation(split[0], split[1]));
    }
}

