/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonStargateNetworkConfig;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;

public class Dialing {
    private static final String EMPTY = "sgjourney:empty";

    public static Stargate.Feedback dialStargate(Level level, AbstractStargateEntity stargate) {
        int[] address = stargate.getAddress();
        switch (address.length) {
            case 6: {
                return Dialing.get7ChevronStargate(level, stargate, address);
            }
            case 7: {
                return Dialing.get8ChevronStargate(level, stargate, address);
            }
            case 8: {
                return Dialing.get9ChevronStargate(level, stargate, address);
            }
        }
        return stargate.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
    }

    private static Stargate.Feedback get7ChevronStargate(Level level, AbstractStargateEntity stargate, int[] address) {
        String addressString = Address.addressIntArrayToString(address);
        ListTag galaxies = Universe.get(level).getGalaxiesFromDimension(level.m_46472_().m_135782_().toString());
        if (galaxies.isEmpty()) {
            return stargate.resetStargate(Stargate.Feedback.NO_GALAXY);
        }
        String solarSystem = EMPTY;
        for (int i = 0; i < galaxies.size(); ++i) {
            String galaxy = (String)galaxies.m_128728_(i).m_128431_().iterator().next();
            solarSystem = Universe.get(level).getSolarSystemInGalaxy(galaxy, addressString);
            if (!solarSystem.equals(EMPTY)) break;
        }
        if (solarSystem.equals(EMPTY)) {
            return stargate.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
        }
        return Dialing.getStargate(level, stargate, solarSystem);
    }

    private static Stargate.Feedback get8ChevronStargate(Level level, AbstractStargateEntity stargate, int[] address) {
        String addressString = Address.addressIntArrayToString(address);
        String solarSystem = Universe.get(level).getSolarSystemFromExtragalacticAddress(addressString);
        if (solarSystem.equals(EMPTY)) {
            return stargate.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
        }
        return Dialing.getStargate(level, stargate, solarSystem);
    }

    private static Stargate.Feedback getStargate(Level level, AbstractStargateEntity stargate, String systemID) {
        String currentSystem = Universe.get(level).getSolarSystemFromDimension(level.m_46472_().m_135782_().toString());
        if (systemID.equals(currentSystem)) {
            return stargate.resetStargate(Stargate.Feedback.SAME_SYSTEM_DIAL);
        }
        MinecraftServer server = level.m_7654_();
        CompoundTag solarSystem = StargateNetwork.get(server).getSolarSystem(systemID);
        if (solarSystem.m_128456_()) {
            ListTag dimensionList = Universe.get(server).getDimensionsFromSolarSystem(systemID);
            int dimensions = 0;
            for (int i = 0; i < dimensionList.size(); ++i) {
                ResourceKey<Level> levelKey = Conversion.stringToDimension(dimensionList.m_128778_(i));
                if (!level.m_7654_().m_129784_().contains(levelKey)) continue;
                ServerLevel targetLevel = server.m_129880_(levelKey);
                Dialing.findStargates((Level)targetLevel);
                ++dimensions;
            }
            if (dimensions == 0) {
                return stargate.resetStargate(Stargate.Feedback.NO_DIMENSIONS);
            }
            solarSystem = StargateNetwork.get(server).getSolarSystem(systemID);
            if (solarSystem.m_128456_()) {
                return stargate.resetStargate(Stargate.Feedback.NO_STARGATES);
            }
            solarSystem = StargateNetwork.get(server).getSolarSystem(systemID);
        }
        return Dialing.getPreferredStargate(server, stargate, solarSystem);
    }

    private static void findStargates(Level level) {
        StargateJourney.LOGGER.info("Attempting to locate the Stargate Structure in " + level.m_46472_().m_135782_().toString());
        int xOffset = (Integer)CommonStargateNetworkConfig.stargate_generation_center_x_chunk_offset.get();
        int zOffset = (Integer)CommonStargateNetworkConfig.stargate_generation_center_z_chunk_offset.get();
        BlockPos blockpos = ((ServerLevel)level).m_215011_(TagInit.Structures.HAS_STARGATE, new BlockPos(xOffset * 16, 0, zOffset * 16), 150, false);
        if (blockpos == null) {
            StargateJourney.LOGGER.info("Stargate Structure not found");
            return;
        }
        ArrayList stargates = new ArrayList();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                ChunkAccess chunk = level.m_46865_(blockpos.m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity patt5488$temp = level.m_7702_(pos);
                    if (patt5488$temp instanceof AbstractStargateEntity) {
                        AbstractStargateEntity stargate = (AbstractStargateEntity)patt5488$temp;
                        stargates.add(stargate);
                    }
                });
            }
        }
        if (stargates.isEmpty()) {
            StargateJourney.LOGGER.info("No Stargates found in Stargate Structure");
            return;
        }
        stargates.stream().forEach(stargate -> stargate.onLoad());
    }

    public static Stargate.Feedback getStargateFromID(MinecraftServer server, AbstractStargateEntity stargate, String id) {
        CompoundTag stargateList = StargateNetwork.get(server).getStargates();
        if (!stargateList.m_128441_(id)) {
            return stargate.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
        }
        BlockPos pos = Conversion.intArrayToBlockPos(stargateList.m_128469_(id).m_128465_("Coordinates"));
        BlockEntity blockEntity = server.m_129880_(Conversion.stringToDimension(stargateList.m_128469_(id).m_128461_("Dimension"))).m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity targetStargate = (AbstractStargateEntity)blockEntity;
            if (targetStargate.isObstructed()) {
                return stargate.resetStargate(Stargate.Feedback.TARGET_OBSTRUCTED);
            }
            return Dialing.dialStargate(stargate, targetStargate);
        }
        return stargate.resetStargate(Stargate.Feedback.COULD_NOT_REACH_TARGET_STARGATE);
    }

    public static Stargate.Feedback get9ChevronStargate(Level level, AbstractStargateEntity stargate, int[] address) {
        String id = Address.addressIntArrayToString(address);
        return Dialing.getStargateFromID(level.m_7654_(), stargate, id);
    }

    private static Stargate.Feedback getPreferredStargate(MinecraftServer server, AbstractStargateEntity stargate, CompoundTag solarSystem) {
        while (!solarSystem.m_128456_()) {
            String preferredStargate = StargateNetwork.get(server).getPreferredStargate(solarSystem);
            if (!preferredStargate.equals(EMPTY)) {
                CompoundTag stargateInfo = solarSystem.m_128469_(preferredStargate);
                int[] coordinates = stargateInfo.m_128465_("Coordinates");
                BlockPos pos = Conversion.intArrayToBlockPos(coordinates);
                ResourceKey<Level> dimension = Conversion.stringToDimension(stargateInfo.m_128461_("Dimension"));
                ServerLevel targetLevel = server.m_129880_(dimension);
                BlockEntity blockEntity = targetLevel.m_7702_(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity targetStargate = (AbstractStargateEntity)blockEntity;
                    if (!targetStargate.isObstructed()) {
                        return Dialing.dialStargate(stargate, targetStargate);
                    }
                    if (targetStargate.isObstructed() && solarSystem.m_128440_() == 1) {
                        return stargate.resetStargate(Stargate.Feedback.TARGET_OBSTRUCTED);
                    }
                }
            }
            solarSystem.m_128473_(preferredStargate);
        }
        return stargate.resetStargate(Stargate.Feedback.UNKNOWN_ERROR);
    }

    private static Stargate.Feedback dialStargate(AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate) {
        return dialingStargate.dialStargate(dialedStargate);
    }
}

