/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeProvider {
    private static final double MIN = 0.0;
    private static final double MAX = 16.0;
    private static final double MID = 8.0;
    public final VoxelShape HORIZONTAL;
    public final VoxelShape X_FULL;
    public final VoxelShape X_BOTTOM;
    public final VoxelShape X_TOP;
    public final VoxelShape X_LEFT;
    public final VoxelShape X_RIGHT;
    public final VoxelShape Z_FULL;
    public final VoxelShape Z_BOTTOM;
    public final VoxelShape Z_TOP;
    public final VoxelShape Z_LEFT;
    public final VoxelShape Z_RIGHT;
    public final VoxelShape[][] FULL;
    public final VoxelShape[][] BOTTOM;
    public final VoxelShape[][] TOP;
    public final VoxelShape[][] LEFT;
    public final VoxelShape[][] RIGHT;
    public final VoxelShape[][] CORNER_TOP_LEFT;
    public final VoxelShape[][] CORNER_BOTTOM_LEFT;
    public final VoxelShape[][] CORNER_BOTTOM_RIGHT;
    public final VoxelShape[][] CORNER_TOP_RIGHT;
    public final VoxelShape[][] STAIR_TOP_LEFT;
    public final VoxelShape[][] STAIR_BOTTOM_LEFT;
    public final VoxelShape[][] STAIR_BOTTOM_RIGHT;
    public final VoxelShape[][] STAIR_TOP_RIGHT;

    public VoxelShapeProvider(double width, double horizontalOffset) {
        double horizontalMax = horizontalOffset + width;
        double verticalStart = 8.0 - width / 2.0;
        double verticalEnd = 8.0 + width / 2.0;
        this.HORIZONTAL = Block.m_49796_((double)0.0, (double)horizontalOffset, (double)0.0, (double)16.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalBottom = Block.m_49796_((double)0.0, (double)horizontalOffset, (double)0.0, (double)16.0, (double)horizontalMax, (double)8.0);
        VoxelShape horizontalTop = Block.m_49796_((double)0.0, (double)horizontalOffset, (double)8.0, (double)16.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalLeft = Block.m_49796_((double)0.0, (double)horizontalOffset, (double)0.0, (double)8.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalRight = Block.m_49796_((double)8.0, (double)horizontalOffset, (double)0.0, (double)16.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalBottomLeft = Block.m_49796_((double)0.0, (double)horizontalOffset, (double)0.0, (double)8.0, (double)horizontalMax, (double)8.0);
        VoxelShape horizontalBottomRight = Block.m_49796_((double)8.0, (double)horizontalOffset, (double)0.0, (double)16.0, (double)horizontalMax, (double)8.0);
        VoxelShape horizontalTopLeft = Block.m_49796_((double)0.0, (double)horizontalOffset, (double)8.0, (double)8.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalTopRight = Block.m_49796_((double)8.0, (double)horizontalOffset, (double)8.0, (double)16.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalStairBottomLeft = Shapes.m_83124_((VoxelShape)horizontalBottomRight, (VoxelShape[])new VoxelShape[]{horizontalTopLeft, horizontalTopRight});
        VoxelShape horizontalStairBottomRight = Shapes.m_83124_((VoxelShape)horizontalBottomLeft, (VoxelShape[])new VoxelShape[]{horizontalTopLeft, horizontalTopRight});
        VoxelShape horizontalStairTopLeft = Shapes.m_83124_((VoxelShape)horizontalBottomLeft, (VoxelShape[])new VoxelShape[]{horizontalBottomRight, horizontalTopRight});
        VoxelShape horizontalStairTopRight = Shapes.m_83124_((VoxelShape)horizontalBottomLeft, (VoxelShape[])new VoxelShape[]{horizontalBottomRight, horizontalTopLeft});
        this.X_FULL = Block.m_49796_((double)0.0, (double)0.0, (double)verticalStart, (double)16.0, (double)16.0, (double)verticalEnd);
        this.X_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)verticalStart, (double)16.0, (double)8.0, (double)verticalEnd);
        this.X_TOP = Block.m_49796_((double)0.0, (double)8.0, (double)verticalStart, (double)16.0, (double)16.0, (double)verticalEnd);
        this.X_LEFT = Block.m_49796_((double)8.0, (double)0.0, (double)verticalStart, (double)16.0, (double)16.0, (double)verticalEnd);
        this.X_RIGHT = Block.m_49796_((double)0.0, (double)0.0, (double)verticalStart, (double)8.0, (double)16.0, (double)verticalEnd);
        VoxelShape xTopLeft = Block.m_49796_((double)0.0, (double)8.0, (double)verticalStart, (double)8.0, (double)16.0, (double)verticalEnd);
        VoxelShape xTopRight = Block.m_49796_((double)8.0, (double)8.0, (double)verticalStart, (double)16.0, (double)16.0, (double)verticalEnd);
        VoxelShape xBottomLeft = Block.m_49796_((double)0.0, (double)0.0, (double)verticalStart, (double)8.0, (double)8.0, (double)verticalEnd);
        VoxelShape xBottomRight = Block.m_49796_((double)8.0, (double)0.0, (double)verticalStart, (double)16.0, (double)8.0, (double)verticalEnd);
        VoxelShape xStairTopLeft = Shapes.m_83124_((VoxelShape)xBottomLeft, (VoxelShape[])new VoxelShape[]{xBottomRight, xTopRight});
        VoxelShape xStairTopRight = Shapes.m_83124_((VoxelShape)xBottomLeft, (VoxelShape[])new VoxelShape[]{xBottomRight, xTopLeft});
        VoxelShape xStairBottomLeft = Shapes.m_83124_((VoxelShape)xTopLeft, (VoxelShape[])new VoxelShape[]{xTopRight, xBottomRight});
        VoxelShape xStairBottomRight = Shapes.m_83124_((VoxelShape)xTopLeft, (VoxelShape[])new VoxelShape[]{xTopRight, xBottomLeft});
        this.Z_FULL = Block.m_49796_((double)verticalStart, (double)0.0, (double)0.0, (double)verticalEnd, (double)16.0, (double)16.0);
        this.Z_BOTTOM = Block.m_49796_((double)verticalStart, (double)0.0, (double)0.0, (double)verticalEnd, (double)8.0, (double)16.0);
        this.Z_TOP = Block.m_49796_((double)verticalStart, (double)8.0, (double)0.0, (double)verticalEnd, (double)16.0, (double)16.0);
        this.Z_LEFT = Block.m_49796_((double)verticalStart, (double)0.0, (double)8.0, (double)verticalEnd, (double)16.0, (double)16.0);
        this.Z_RIGHT = Block.m_49796_((double)verticalStart, (double)0.0, (double)0.0, (double)verticalEnd, (double)16.0, (double)8.0);
        VoxelShape zTopLeft = Block.m_49796_((double)verticalStart, (double)8.0, (double)0.0, (double)verticalEnd, (double)16.0, (double)8.0);
        VoxelShape zTopRight = Block.m_49796_((double)verticalStart, (double)8.0, (double)8.0, (double)verticalEnd, (double)16.0, (double)16.0);
        VoxelShape zBottomLeft = Block.m_49796_((double)verticalStart, (double)0.0, (double)0.0, (double)verticalEnd, (double)8.0, (double)8.0);
        VoxelShape zBottomRight = Block.m_49796_((double)verticalStart, (double)0.0, (double)8.0, (double)verticalEnd, (double)8.0, (double)16.0);
        VoxelShape zStairTopLeft = Shapes.m_83124_((VoxelShape)zBottomLeft, (VoxelShape[])new VoxelShape[]{zBottomRight, zTopRight});
        VoxelShape zStairTopRight = Shapes.m_83124_((VoxelShape)zBottomLeft, (VoxelShape[])new VoxelShape[]{zBottomRight, zTopLeft});
        VoxelShape zStairBottomLeft = Shapes.m_83124_((VoxelShape)zTopLeft, (VoxelShape[])new VoxelShape[]{zTopRight, zBottomRight});
        VoxelShape zStairBottomRight = Shapes.m_83124_((VoxelShape)zTopLeft, (VoxelShape[])new VoxelShape[]{zTopRight, zBottomLeft});
        this.FULL = new VoxelShape[][]{{this.HORIZONTAL}, {this.X_FULL, this.Z_FULL}, {this.HORIZONTAL}};
        VoxelShape[] defaultHorizontalSlabShapes = new VoxelShape[]{horizontalTop, horizontalLeft, horizontalBottom, horizontalRight};
        VoxelShape[] reverseHorizontalSlabShapes = new VoxelShape[]{horizontalBottom, horizontalRight, horizontalTop, horizontalLeft};
        VoxelShape[] leftHorizontalSlabShapes = new VoxelShape[]{horizontalRight, horizontalTop, horizontalLeft, horizontalBottom};
        VoxelShape[] rightHorizontalSlabShapes = new VoxelShape[]{horizontalLeft, horizontalBottom, horizontalRight, horizontalTop};
        this.BOTTOM = new VoxelShape[][]{defaultHorizontalSlabShapes, {this.X_BOTTOM, this.Z_BOTTOM}, reverseHorizontalSlabShapes};
        this.TOP = new VoxelShape[][]{reverseHorizontalSlabShapes, {this.X_TOP, this.Z_TOP}, defaultHorizontalSlabShapes};
        this.LEFT = new VoxelShape[][]{leftHorizontalSlabShapes, {this.X_LEFT, this.Z_LEFT, this.X_RIGHT, this.Z_RIGHT}, leftHorizontalSlabShapes};
        this.RIGHT = new VoxelShape[][]{rightHorizontalSlabShapes, {this.X_RIGHT, this.Z_RIGHT, this.X_LEFT, this.Z_LEFT}, rightHorizontalSlabShapes};
        this.CORNER_TOP_LEFT = new VoxelShape[][]{{horizontalBottomLeft, horizontalBottomRight, horizontalTopRight, horizontalTopLeft}, {xTopLeft, zTopLeft, xTopRight, zTopRight}, {horizontalTopLeft, horizontalBottomLeft, horizontalBottomRight, horizontalTopRight}};
        this.CORNER_BOTTOM_LEFT = new VoxelShape[][]{{horizontalTopLeft, horizontalBottomLeft, horizontalBottomRight, horizontalTopRight}, {xBottomLeft, zBottomLeft, xBottomRight, zBottomRight}, {horizontalBottomLeft, horizontalBottomRight, horizontalTopRight, horizontalTopLeft}};
        this.CORNER_BOTTOM_RIGHT = new VoxelShape[][]{{horizontalTopRight, horizontalTopLeft, horizontalBottomLeft, horizontalBottomRight}, {xBottomRight, zBottomRight, xBottomLeft, zBottomLeft}, {horizontalBottomRight, horizontalTopRight, horizontalTopLeft, horizontalBottomLeft}};
        this.CORNER_TOP_RIGHT = new VoxelShape[][]{{horizontalBottomRight, horizontalTopRight, horizontalTopLeft, horizontalBottomLeft}, {xTopRight, zTopRight, xTopLeft, zTopLeft}, {horizontalTopRight, horizontalTopLeft, horizontalBottomLeft, horizontalBottomRight}};
        this.STAIR_TOP_LEFT = new VoxelShape[][]{{horizontalStairBottomLeft, horizontalStairBottomRight, horizontalStairTopRight, horizontalStairTopLeft}, {xStairTopLeft, zStairTopLeft, xStairTopRight, zStairTopRight}, {horizontalStairTopLeft, horizontalStairBottomLeft, horizontalStairBottomRight, horizontalStairTopRight}};
        this.STAIR_BOTTOM_LEFT = new VoxelShape[][]{{horizontalStairTopLeft, horizontalStairBottomLeft, horizontalStairBottomRight, horizontalStairTopRight}, {xStairBottomLeft, zStairBottomLeft, xStairBottomRight, zStairBottomRight}, {horizontalStairBottomLeft, horizontalStairBottomRight, horizontalStairTopRight, horizontalStairTopLeft}};
        this.STAIR_BOTTOM_RIGHT = new VoxelShape[][]{{horizontalStairTopRight, horizontalStairTopLeft, horizontalStairBottomLeft, horizontalStairBottomRight}, {xStairBottomRight, zStairBottomRight, xStairBottomLeft, zStairBottomLeft}, {horizontalStairBottomRight, horizontalStairTopRight, horizontalStairTopLeft, horizontalStairBottomLeft}};
        this.STAIR_TOP_RIGHT = new VoxelShape[][]{{horizontalStairBottomRight, horizontalStairTopRight, horizontalStairTopLeft, horizontalStairBottomLeft}, {xStairTopRight, zStairTopRight, xStairTopLeft, zStairTopLeft}, {horizontalStairTopRight, horizontalStairTopLeft, horizontalStairBottomLeft, horizontalStairBottomRight}};
    }
}

