/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.povstalec.sgjourney.common.capabilities.ItemEnergyProvider;
import org.jetbrains.annotations.Nullable;

public class EnergyCrystalItem
extends Item {
    public static final String CRYSTAL_MODE = "CrystalMode";
    public static final String ENERGY_LIMIT = "EnergyLimit";
    public static final String ENERGY = "Energy";
    public static final String TRANSFER_LIMIT = "TransferLimit";
    public final int maxEnergy;
    public final int maxTransfer;
    public final int maxRegularTransfer;

    public EnergyCrystalItem(Item.Properties properties, int maxEnergy, int maxTransfer, int maxRegularTransfer) {
        super(properties);
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        this.maxRegularTransfer = maxRegularTransfer;
    }

    public boolean m_142522_(ItemStack stack) {
        return EnergyCrystalItem.getCrystalMode(stack) == CrystalMode.ENERGY_STORAGE;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)EnergyCrystalItem.getEnergy(stack) / (float)this.maxEnergy);
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)EnergyCrystalItem.getEnergy(stack) / (float)this.maxEnergy);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static CompoundTag tagSetup(CrystalMode crystalMode, int energy, int maxTransfer) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(CRYSTAL_MODE, crystalMode.toString().toUpperCase());
        tag.m_128405_(ENERGY, energy);
        tag.m_128405_(TRANSFER_LIMIT, maxTransfer);
        return tag;
    }

    public static CrystalMode getCrystalMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(CRYSTAL_MODE)) {
            tag.m_128359_(CRYSTAL_MODE, CrystalMode.ENERGY_STORAGE.toString().toUpperCase());
        }
        CrystalMode mode = CrystalMode.valueOf(tag.m_128461_(CRYSTAL_MODE));
        return mode;
    }

    public static int getEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(ENERGY)) {
            tag.m_128405_(ENERGY, 0);
        }
        int energy = tag.m_128451_(ENERGY);
        return energy;
    }

    public static int getMaxTransfer(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof EnergyCrystalItem) {
            EnergyCrystalItem crystal = (EnergyCrystalItem)item;
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(TRANSFER_LIMIT)) {
                tag.m_128405_(TRANSFER_LIMIT, crystal.maxTransfer);
            }
            int maxTransfer = tag.m_128451_(TRANSFER_LIMIT);
            return maxTransfer;
        }
        return 0;
    }

    public int getMaxTransfer() {
        return this.maxTransfer;
    }

    public int getMaxStorage() {
        return this.maxEnergy;
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack){

            @Override
            public long capacity() {
                return EnergyCrystalItem.this.maxEnergy;
            }

            @Override
            public long maxReceive() {
                return EnergyCrystalItem.this.maxRegularTransfer;
            }

            @Override
            public long maxExtract() {
                return EnergyCrystalItem.this.maxRegularTransfer;
            }
        };
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CrystalMode mode = EnergyCrystalItem.getCrystalMode(stack);
        switch (mode) {
            case ENERGY_STORAGE: {
                int energy = EnergyCrystalItem.getEnergy(stack);
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + energy + "/" + this.maxEnergy + " FE"))).m_130940_(ChatFormatting.DARK_RED));
                break;
            }
            case ENERGY_TRANSFER: {
                int maxEnergyTransfer = EnergyCrystalItem.getMaxTransfer(stack);
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy_transfer").m_7220_((Component)Component.m_237113_((String)(": " + maxEnergyTransfer + " FE"))).m_130940_(ChatFormatting.RED));
            }
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static enum CrystalMode {
        ENERGY_STORAGE,
        ENERGY_TRANSFER;

    }
}

