/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.events;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.povstalec.sgjourney.common.capabilities.AncientGene;
import net.povstalec.sgjourney.common.capabilities.AncientGeneProvider;
import net.povstalec.sgjourney.common.capabilities.BloodstreamNaquadah;
import net.povstalec.sgjourney.common.capabilities.BloodstreamNaquadahProvider;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.init.VillagerInit;
import net.povstalec.sgjourney.common.items.armor.PersonalShieldItem;
import net.povstalec.sgjourney.common.misc.TreasureMapForEmeraldsTrade;

@Mod.EventBusSubscriber(modid="sgjourney", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        StargateNetwork.get(server).updateNetwork(server);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = event.getServer();
        if (event.phase.equals((Object)TickEvent.Phase.START) && server != null) {
            StargateNetwork.get(server).handleConnections();
        }
    }

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player.m_7755_().getString().equals("Dev") || player.m_7755_().getString().equals("Woldericz_junior")) {
            AncientGene.addAncient((Entity)player);
        } else {
            AncientGene.inheritGene((Entity)player);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().m_7640_();
        float damage = event.getAmount();
        event.setCanceled(ForgeEvents.onAttackOrHurt((Entity)entity, attacker, damage));
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().m_7640_();
        float damage = event.getAmount();
        event.setCanceled(ForgeEvents.onAttackOrHurt((Entity)entity, attacker, damage));
    }

    private static boolean onAttackOrHurt(Entity entity, Entity attacker, float damage) {
        Player player;
        ItemStack stack;
        if (entity instanceof Player && (stack = (player = (Player)entity).m_6844_(EquipmentSlot.CHEST)).m_150930_((Item)ItemInit.PERSONAL_SHIELD_EMITTER.get()) && PersonalShieldItem.getEnergy(stack) > 0) {
            int energyDepleted = (int)damage * 500;
            PersonalShieldItem.depleteEnergy(stack, energyDepleted);
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                livingAttacker.m_147240_(0.5, player.m_20185_() - attacker.m_20185_(), player.m_20189_() - attacker.m_20189_());
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onProjectileHit(ProjectileImpactEvent event) {
        Player player;
        ItemStack stack;
        EntityHitResult hitResult;
        HitResult hitResult2 = event.getRayTraceResult();
        if (hitResult2 instanceof EntityHitResult && (hitResult2 = (hitResult = (EntityHitResult)hitResult2).m_82443_()) instanceof Player && (stack = (player = (Player)hitResult2).m_6844_(EquipmentSlot.CHEST)).m_150930_((Item)ItemInit.PERSONAL_SHIELD_EMITTER.get()) && PersonalShieldItem.getEnergy(stack) > 0) {
            Projectile projectile = event.getProjectile();
            int energyDepleted = (int)projectile.m_20184_().m_82553_() * 500;
            PersonalShieldItem.depleteEnergy(stack, energyDepleted);
            projectile.m_20256_(projectile.m_20184_().m_82548_().m_82490_(0.2));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityJoined(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            AncientGene.inheritGene((Entity)villager);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            if (!((Entity)event.getObject()).getCapability(BloodstreamNaquadahProvider.BLOODSTREAM_NAQUADAH).isPresent()) {
                event.addCapability(new ResourceLocation("sgjourney", "bloodstream_naquadah"), (ICapabilityProvider)new BloodstreamNaquadahProvider());
            }
            if (!((Entity)event.getObject()).getCapability(AncientGeneProvider.ANCIENT_GENE).isPresent()) {
                event.addCapability(new ResourceLocation("sgjourney", "ancient_gene"), (ICapabilityProvider)new AncientGeneProvider());
            }
        } else if (event.getObject() instanceof AbstractVillager) {
            if (!((Entity)event.getObject()).getCapability(BloodstreamNaquadahProvider.BLOODSTREAM_NAQUADAH).isPresent()) {
                event.addCapability(new ResourceLocation("sgjourney", "bloodstream_naquadah"), (ICapabilityProvider)new BloodstreamNaquadahProvider());
            }
            if (!((Entity)event.getObject()).getCapability(AncientGeneProvider.ANCIENT_GENE).isPresent()) {
                event.addCapability(new ResourceLocation("sgjourney", "ancient_gene"), (ICapabilityProvider)new AncientGeneProvider());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        original.reviveCaps();
        original.getCapability(BloodstreamNaquadahProvider.BLOODSTREAM_NAQUADAH).ifPresent(oldCap -> clone.getCapability(BloodstreamNaquadahProvider.BLOODSTREAM_NAQUADAH).ifPresent(newCap -> newCap.copyFrom((BloodstreamNaquadah)oldCap)));
        original.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(oldCap -> clone.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(newCap -> newCap.copyFrom((AncientGene)oldCap)));
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(BloodstreamNaquadah.class);
        event.register(AncientGene.class);
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        int villagerLevel;
        Int2ObjectMap trades;
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42516_, 20), new ItemStack((ItemLike)Items.f_42616_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)BlockInit.GOLDEN_IDOL.get(), 1), new ItemStack((ItemLike)Items.f_42616_, 5), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add(new TreasureMapForEmeraldsTrade(8, TagInit.Structures.ON_ARCHEOLOGIST_MAPS, "filled_map.sgjourney.archeologist", MapDecoration.Type.RED_X, 1, 80));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 2;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)Items.f_42522_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 2;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)Items.f_42614_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 2;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42417_, 3), new ItemStack((ItemLike)Items.f_42616_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 3;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)BlockInit.FIRE_PIT.get(), 4), 1, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 3;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)BlockInit.SANDSTONE_HIEROGLYPHS.get(), 3), new ItemStack((ItemLike)Items.f_42616_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 3;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)BlockInit.SANDSTONE_WITH_LAPIS.get(), 3), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)BlockInit.STONE_SYMBOL.get(), 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)BlockInit.SANDSTONE_SYMBOL.get(), 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42500_, 4), new ItemStack((ItemLike)Items.f_42616_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 5;
            ((List)trades.get(villagerLevel)).add(new TreasureMapForEmeraldsTrade(8, TagInit.Structures.HAS_STARGATE, "filled_map.sgjourney.astria_porta", MapDecoration.Type.RED_X, 1, 80));
        }
    }
}

