/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.cctweaked.peripherals;

import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraftforge.common.util.LazyOptional;
import net.povstalec.sgjourney.common.block_entities.CrystalInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.cctweaked.peripherals.CrystalInterfacePeripheral;
import net.povstalec.sgjourney.common.cctweaked.peripherals.CrystalStargatePeripheral;

public class CrystalPeripheralWrapper {
    CrystalInterfaceEntity crystalInterface;
    private CrystalInterfacePeripheral crystalInterfacePeripheral;
    private LazyOptional<IPeripheral> peripheral;

    public CrystalPeripheralWrapper(CrystalInterfaceEntity crystalInterface) {
        this.crystalInterface = crystalInterface;
    }

    public static CrystalInterfacePeripheral createPeripheral(CrystalInterfaceEntity crystalInterface, EnergyBlockEntity energyBlockEntity) {
        if (energyBlockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)energyBlockEntity;
            return new CrystalStargatePeripheral(crystalInterface, stargate);
        }
        return new CrystalInterfacePeripheral(crystalInterface);
    }

    public boolean resetInterface() {
        CrystalInterfacePeripheral newPeripheral = CrystalPeripheralWrapper.createPeripheral(this.crystalInterface, this.crystalInterface.findEnergyBlockEntity());
        if (this.crystalInterfacePeripheral != null && this.crystalInterfacePeripheral.equals(newPeripheral)) {
            return false;
        }
        this.crystalInterfacePeripheral = newPeripheral;
        if (this.peripheral != null) {
            this.peripheral.invalidate();
            this.peripheral = LazyOptional.of(() -> newPeripheral);
        }
        return true;
    }

    public LazyOptional<IPeripheral> newPeripheral() {
        this.crystalInterfacePeripheral = CrystalPeripheralWrapper.createPeripheral(this.crystalInterface, this.crystalInterface.energyBlockEntity);
        this.peripheral = LazyOptional.of(() -> this.crystalInterfacePeripheral);
        if (this.peripheral == null) {
            this.crystalInterfacePeripheral = CrystalPeripheralWrapper.createPeripheral(this.crystalInterface, this.crystalInterface.findEnergyBlockEntity());
            this.peripheral = LazyOptional.of(() -> this.crystalInterfacePeripheral);
        }
        return this.peripheral;
    }
}

