/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.cctweaked.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.povstalec.sgjourney.common.block_entities.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;
import net.povstalec.sgjourney.common.cctweaked.methods.InterfaceMethod;
import net.povstalec.sgjourney.common.cctweaked.methods.MilkyWayStargateMethods;
import net.povstalec.sgjourney.common.cctweaked.methods.PegasusStargateMethods;
import net.povstalec.sgjourney.common.cctweaked.methods.TollanStargateMethods;
import net.povstalec.sgjourney.common.cctweaked.methods.UniverseStargateMethods;
import net.povstalec.sgjourney.common.cctweaked.peripherals.BasicInterfacePeripheral;
import net.povstalec.sgjourney.common.stargate.Stargate;

public class BasicStargatePeripheral
extends BasicInterfacePeripheral
implements IDynamicPeripheral {
    protected AbstractStargateEntity stargate;
    private HashMap<String, InterfaceMethod<AbstractStargateEntity>> methods = new HashMap();

    public BasicStargatePeripheral(BasicInterfaceEntity basicInterface, AbstractStargateEntity stargate) {
        super(basicInterface);
        this.stargate = stargate;
        if (stargate instanceof MilkyWayStargateEntity) {
            this.registerMilkyWayStargateMethods();
        } else if (stargate instanceof UniverseStargateEntity) {
            this.registerUniverseStargateMethods();
        } else if (stargate instanceof PegasusStargateEntity) {
            this.registerPegasusStargateMethods();
        }
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.basicInterface.getPeripheralWrapper().computerList.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.basicInterface.getPeripheralWrapper().computerList.removeIf(computerAccess -> computerAccess.getID() == computer.getID());
    }

    public String[] getMethodNames() {
        return this.methods.keySet().toArray(new String[0]);
    }

    public MethodResult callMethod(IComputerAccess computer, ILuaContext context, int method, IArguments arguments) throws LuaException {
        String methodName = this.getMethodNames()[method];
        return this.methods.get(methodName).use(computer, context, this.stargate, arguments);
    }

    public void queueEvent(String eventName, Object ... objects) {
        for (IComputerAccess computer : this.basicInterface.getPeripheralWrapper().computerList) {
            computer.queueEvent(eventName, objects);
        }
    }

    @LuaFunction
    public final int getRecentFeedback() {
        return this.stargate.getRecentFeedback().getCode();
    }

    @LuaFunction
    public final boolean isStargateConnected() {
        return this.stargate.isConnected();
    }

    @LuaFunction
    public final long getStargateEnergy() {
        return this.stargate.getEnergyStored();
    }

    @LuaFunction
    public final int getChevronsEngaged() {
        return this.stargate.getChevronsEngaged();
    }

    @LuaFunction
    public final int getOpenTime() {
        return this.stargate.getOpenTime();
    }

    @LuaFunction
    public final MethodResult disconnectStargate(ILuaContext context) throws LuaException {
        MethodResult result = context.executeMainThreadTask(() -> {
            Stargate.Feedback feedback = this.stargate.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT);
            return new Object[]{!feedback.isError()};
        });
        return result;
    }

    private <Stargate extends AbstractStargateEntity> void registerMilkyWayStargateMethod(InterfaceMethod<Stargate> function) {
        this.methods.put(function.getName(), function);
    }

    public void registerMilkyWayStargateMethods() {
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.GetCurrentSymbol());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.IsCurrentSymbol());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.GetRotation());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.RotateClockwise());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.RotateAntiClockwise());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.EndRotation());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.RaiseChevron());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.LowerChevron());
    }

    private <Stargate extends AbstractStargateEntity> void registerUniverseStargateMethod(InterfaceMethod<Stargate> function) {
        this.methods.put(function.getName(), function);
    }

    public void registerUniverseStargateMethods() {
        this.registerUniverseStargateMethod(new UniverseStargateMethods.EngageSymbol());
    }

    private <Stargate extends AbstractStargateEntity> void registerTollanStargateMethod(InterfaceMethod<Stargate> function) {
        this.methods.put(function.getName(), function);
    }

    public void registerTollanStargateMethods() {
        this.registerTollanStargateMethod(new TollanStargateMethods.EngageSymbol());
    }

    private <Stargate extends AbstractStargateEntity> void registerPegasusStargateMethod(InterfaceMethod<Stargate> function) {
        this.methods.put(function.getName(), function);
    }

    public void registerPegasusStargateMethods() {
        this.registerPegasusStargateMethod(new PegasusStargateMethods.EngageSymbol());
    }
}

