/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.cctweaked.peripherals;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.util.LazyOptional;
import net.povstalec.sgjourney.common.block_entities.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.cctweaked.peripherals.BasicInterfacePeripheral;
import net.povstalec.sgjourney.common.cctweaked.peripherals.BasicStargatePeripheral;

public class BasicPeripheralWrapper {
    BasicInterfaceEntity basicInterface;
    private BasicInterfacePeripheral basicInterfacePeripheral;
    private LazyOptional<IPeripheral> peripheral;
    protected final List<IComputerAccess> computerList = new LinkedList<IComputerAccess>();

    public BasicPeripheralWrapper(BasicInterfaceEntity basicInterface) {
        this.basicInterface = basicInterface;
    }

    public static BasicInterfacePeripheral createPeripheral(BasicInterfaceEntity basicInterface, EnergyBlockEntity energyBlockEntity) {
        if (energyBlockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)energyBlockEntity;
            return new BasicStargatePeripheral(basicInterface, stargate);
        }
        return new BasicInterfacePeripheral(basicInterface);
    }

    public boolean resetInterface() {
        BasicInterfacePeripheral newPeripheral = BasicPeripheralWrapper.createPeripheral(this.basicInterface, this.basicInterface.findEnergyBlockEntity());
        if (this.basicInterfacePeripheral != null && this.basicInterfacePeripheral.equals(newPeripheral)) {
            return false;
        }
        this.basicInterfacePeripheral = newPeripheral;
        if (this.peripheral != null) {
            this.peripheral.invalidate();
            this.peripheral = LazyOptional.of(() -> newPeripheral);
        }
        return true;
    }

    public LazyOptional<IPeripheral> newPeripheral() {
        this.basicInterfacePeripheral = BasicPeripheralWrapper.createPeripheral(this.basicInterface, this.basicInterface.energyBlockEntity);
        this.peripheral = LazyOptional.of(() -> this.basicInterfacePeripheral);
        if (this.peripheral == null) {
            this.basicInterfacePeripheral = BasicPeripheralWrapper.createPeripheral(this.basicInterface, this.basicInterface.findEnergyBlockEntity());
            this.peripheral = LazyOptional.of(() -> this.basicInterfacePeripheral);
        }
        return this.peripheral;
    }

    public void queueEvent(String eventName, Object ... objects) {
        BasicInterfacePeripheral basicInterfacePeripheral = this.basicInterfacePeripheral;
        if (basicInterfacePeripheral instanceof BasicStargatePeripheral) {
            BasicStargatePeripheral stargatePeripheral = (BasicStargatePeripheral)basicInterfacePeripheral;
            stargatePeripheral.queueEvent(eventName, objects);
        }
    }
}

