/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemEnergyProvider
implements ICapabilityProvider {
    private static final String ENERGY = "Energy";
    private ItemStack stack;
    private final SGJourneyEnergy ENERGY_STORAGE = new SGJourneyEnergy(this.capacity(), this.maxReceive(), this.maxExtract()){

        @Override
        public long receiveLongEnergy(long maxReceive, boolean simulate) {
            ItemEnergyProvider.this.loadEnergy();
            return super.receiveLongEnergy(maxReceive, simulate);
        }

        @Override
        public long extractLongEnergy(long maxExtract, boolean simulate) {
            ItemEnergyProvider.this.loadEnergy();
            return super.extractLongEnergy(maxExtract, simulate);
        }

        @Override
        public long getTrueEnergyStored() {
            ItemEnergyProvider.this.loadEnergy();
            return this.energy;
        }

        @Override
        public boolean canExtract() {
            return ItemEnergyProvider.this.canExtractEnergy();
        }

        @Override
        public boolean canReceive() {
            return ItemEnergyProvider.this.canReceiveEnergy();
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            ItemEnergyProvider.this.energyChanged(difference, simulate);
        }
    };
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);

    public ItemEnergyProvider(ItemStack stack) {
        this.stack = stack;
    }

    public abstract long capacity();

    public abstract long maxReceive();

    public abstract long maxExtract();

    public boolean canReceiveEnergy() {
        return true;
    }

    public boolean canExtractEnergy() {
        return true;
    }

    public void energyChanged(long difference, boolean simulate) {
        this.saveEnergy();
    }

    public long getEnergy() {
        return this.ENERGY_STORAGE.getTrueEnergyStored();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return LazyOptional.empty();
    }

    public void loadEnergy() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128425_(ENERGY, 4)) {
            this.ENERGY_STORAGE.deserializeNBT(tag.m_128423_(ENERGY));
        }
    }

    public void saveEnergy() {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128365_(ENERGY, this.ENERGY_STORAGE.serializeNBT());
        this.stack.m_41751_(tag);
    }
}

