/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.povstalec.sgjourney.common.block_entities.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.menu.BasicInterfaceMenu;
import net.povstalec.sgjourney.common.misc.InterfaceMode;

public class BasicInterfaceBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty UPDATE = BooleanProperty.m_61465_((String)"update");
    public static final EnumProperty<InterfaceMode> MODE = EnumProperty.m_61587_((String)"mode", InterfaceMode.class);

    public BasicInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)UPDATE, (Comparable)Boolean.valueOf(false))).m_61124_(MODE, (Comparable)((Object)InterfaceMode.OFF)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{UPDATE}).m_61104_(new Property[]{MODE});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BasicInterfaceEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (!level.m_5776_()) {
            final BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BasicInterfaceEntity) {
                BasicInterfaceEntity basicInterface = (BasicInterfaceEntity)blockEntity;
                if (!player.m_6144_()) {
                    MenuProvider containerProvider = new MenuProvider(){

                        public Component m_5446_() {
                            return Component.m_237115_((String)"screen.sgjourney.basic_interface");
                        }

                        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                            return new BasicInterfaceMenu(windowId, playerInventory, blockEntity);
                        }
                    };
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)blockEntity.m_58899_());
                } else if (player.m_6144_() && player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                    level.m_7731_(pos, (BlockState)state.m_61122_(MODE), 3);
                }
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public Block getDroppedBlock() {
        return (Block)BlockInit.BASIC_INTERFACE.get();
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof BasicInterfaceEntity && !level.m_5776_() && !player.m_7500_()) {
            ItemStack itemstack = new ItemStack((ItemLike)this.getDroppedBlock());
            blockentity.m_187476_(itemstack);
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)UPDATE, (Comparable)Boolean.valueOf(false)), 3);
    }

    public void updateInterface(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)UPDATE, (Comparable)Boolean.valueOf(true)), 3);
        level.m_186460_(pos, (Block)this, 2);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bool) {
        BasicInterfaceEntity basicInterface;
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos targetPos = pos.m_121945_(direction);
        if (targetPos.equals((Object)pos2) && (blockEntity = level.m_7702_(pos)) instanceof BasicInterfaceEntity && (basicInterface = (BasicInterfaceEntity)blockEntity).updateInterface(level, targetPos, block, state)) {
            level.m_46590_(pos, state.m_60734_(), (Direction)state.m_61143_((Property)FACING));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BasicInterfaceBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.BASIC_INTERFACE.get()), BasicInterfaceEntity::tick);
    }

    public long getCapacity() {
        return 5000000L;
    }

    public int comparatorOutput(BlockState state, EnergyBlockEntity blockEntity) {
        switch ((InterfaceMode)((Object)state.m_61143_(MODE))) {
            case RING_ROTATION: {
                return this.getRotationOutput(blockEntity);
            }
            case CHEVRONS_ACTIVE: {
                return this.getChevronOutput(blockEntity);
            }
            case WORMHOLE_ACTIVE: {
                return this.getConnectionOutput(blockEntity);
            }
        }
        return 0;
    }

    private int getRotationOutput(EnergyBlockEntity blockEntity) {
        if (blockEntity instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)blockEntity;
            return stargate.getCurrentSymbol() / 3;
        }
        return 0;
    }

    private int getChevronOutput(EnergyBlockEntity blockEntity) {
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return stargate.getChevronsEngaged();
        }
        return 0;
    }

    private int getConnectionOutput(EnergyBlockEntity blockEntity) {
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return stargate.isConnected() ? 15 : 0;
        }
        return 0;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof BasicInterfaceEntity) {
            BasicInterfaceEntity basicInterface = (BasicInterfaceEntity)entity;
            return this.comparatorOutput(state, basicInterface.energyBlockEntity);
        }
        return 0;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int energy = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("Energy")) {
            energy = stack.m_41783_().m_128469_("BlockEntityTag").m_128451_("Energy");
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + energy + "/" + this.getCapacity() + " FE"))).m_130940_(ChatFormatting.DARK_RED));
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }
}

