/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.misc.ArrayHelper;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundUniverseStargateUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;
import org.jetbrains.annotations.NotNull;

public class UniverseStargateEntity
extends AbstractStargateEntity {
    public static final int WAIT_TICKS = 20;
    public int animationTicks = 1;
    protected static final String UNIVERSAL = "sgjourney:universal";
    protected static final String POINT_OF_ORIGIN = "sgjourney:universal";
    protected static final String SYMBOLS = "sgjourney:universal";
    public int oldRotation = 0;
    public int rotation = 0;
    public int[] addressBuffer = new int[0];
    public int symbolBuffer = 0;

    public UniverseStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.UNIVERSE_STARGATE.get(), pos, state, Stargate.Gen.GEN_1, 1);
        this.setOpenSoundLead(8);
    }

    @Override
    public void onLoad() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.setPointOfOrigin("sgjourney:universal");
        this.setSymbols("sgjourney:universal");
        super.onLoad();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.oldRotation = this.rotation = nbt.m_128451_("Rotation");
        this.addressBuffer = nbt.m_128465_("AddressBuffer");
        this.symbolBuffer = nbt.m_128451_("SymbolBuffer");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Rotation", this.rotation);
        nbt.m_128385_("AddressBuffer", this.addressBuffer);
        nbt.m_128405_("SymbolBuffer", this.symbolBuffer);
    }

    @Override
    public SoundEvent getChevronEngageSound() {
        return (SoundEvent)SoundInit.UNIVERSE_CHEVRON_ENGAGE.get();
    }

    @Override
    public SoundEvent getWormholeOpenSound() {
        return (SoundEvent)SoundInit.UNIVERSE_WORMHOLE_OPEN.get();
    }

    @Override
    public SoundEvent getFailSound() {
        return (SoundEvent)SoundInit.UNIVERSE_DIAL_FAIL.get();
    }

    public double angle() {
        return 6.666666666666667;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isRotating() {
        return this.rotation != this.oldRotation;
    }

    @Override
    public Stargate.Feedback engageSymbol(int symbol) {
        if (this.f_58857_.m_5776_()) {
            return Stargate.Feedback.NONE;
        }
        if (Address.addressContainsSymbol(this.getAddress(), symbol)) {
            return Stargate.Feedback.SYMBOL_ENCODED;
        }
        if (symbol > 35) {
            return Stargate.Feedback.SYMBOL_OUT_OF_BOUNDS;
        }
        if (symbol == 0) {
            if (this.isConnected()) {
                return this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT);
            }
            if (!this.isConnected() && this.addressBuffer.length == 0) {
                return Stargate.Feedback.INCOPLETE_ADDRESS;
            }
        }
        if (this.addressBuffer.length == 0 && this.address.length == 0) {
            this.startSound();
        }
        this.addressBuffer = ArrayHelper.growIntArray(this.addressBuffer, symbol);
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundUniverseStargateUpdatePacket(this.f_58858_, this.symbolBuffer, this.addressBuffer, this.animationTicks, this.rotation, this.oldRotation));
        return Stargate.Feedback.SYMBOL_ENCODED;
    }

    @Override
    protected Stargate.Feedback lockPrimaryChevron() {
        return super.lockPrimaryChevron();
    }

    @Override
    public Stargate.Feedback encodeChevron(int symbol, boolean incoming) {
        ++this.symbolBuffer;
        ++this.animationTicks;
        Stargate.Feedback feedback = super.encodeChevron(symbol, incoming);
        return feedback;
    }

    public void startSound() {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.UniverseStart(this.f_58858_));
        }
    }

    public SoundEvent getStartSound() {
        return (SoundEvent)SoundInit.UNIVERSE_DIAL_START.get();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, UniverseStargateEntity stargate) {
        if (!stargate.isConnected() && stargate.addressBuffer.length > stargate.symbolBuffer) {
            if (stargate.animationTicks <= 0) {
                stargate.rotateToSymbol(stargate.addressBuffer[stargate.symbolBuffer]);
            } else if (stargate.animationTicks >= 20) {
                stargate.animationTicks = 0;
            } else if (stargate.animationTicks > 0) {
                ++stargate.animationTicks;
            }
        } else if (!stargate.isConnected() && stargate.addressBuffer.length == 0) {
            stargate.rotateToDefault();
        } else {
            stargate.synchronizeWithClient(level);
        }
        if (!stargate.f_58857_.m_5776_()) {
            if (stargate.isRotating()) {
                PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(stargate.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(stargate.f_58858_, false));
            } else {
                PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(stargate.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(stargate.f_58858_, true));
            }
        }
        AbstractStargateEntity.tick(level, pos, state, stargate);
    }

    public void rotate(boolean clockwise) {
        this.rotation = clockwise ? (this.rotation -= 2) : (this.rotation += 2);
        if (this.rotation >= 360) {
            this.rotation -= 360;
            this.oldRotation -= 360;
        } else if (this.rotation < 0) {
            this.rotation += 360;
            this.oldRotation += 360;
        }
        this.m_6596_();
    }

    public boolean isCurrentSymbol(int desiredSymbol) {
        int whole = desiredSymbol / 4;
        int leftover = desiredSymbol % 4;
        double desiredPosition = 3.0 * (this.angle() / 2.0) + (double)(whole * 40) + this.angle() * (double)leftover;
        double position = this.rotation;
        double lowerBound = desiredPosition - 1.0;
        double upperBound = desiredPosition + 1.0;
        return position > lowerBound && position < upperBound;
    }

    public float getRotation(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.getRotation() : Mth.m_14179_((float)partialTick, (float)this.oldRotation, (float)this.rotation);
    }

    private void rotateToSymbol(int desiredSymbol) {
        this.oldRotation = this.rotation;
        if (this.isCurrentSymbol(desiredSymbol)) {
            this.synchronizeWithClient(this.f_58857_);
            if (this.isCurrentSymbol(0)) {
                this.lockPrimaryChevron();
            } else {
                this.encodeChevron(desiredSymbol, false);
            }
            this.synchronizeWithClient(this.f_58857_);
        } else {
            this.rotate(this.getBestRotationDirection(desiredSymbol));
        }
    }

    private void rotateToDefault() {
        this.oldRotation = this.rotation;
        if (this.rotation == 0) {
            this.synchronizeWithClient(this.f_58857_);
        } else {
            this.rotate(UniverseStargateEntity.getBestRotationDirection(0.0, this.rotation));
        }
    }

    private boolean getBestRotationDirection(int desiredSymbol) {
        int whole = desiredSymbol / 4;
        int leftover = desiredSymbol % 4;
        double desiredPosition = 3.0 * (this.angle() / 2.0) + (double)(whole * 40) + this.angle() * (double)leftover;
        double position = this.rotation;
        return UniverseStargateEntity.getBestRotationDirection(desiredPosition, position);
    }

    private static boolean getBestRotationDirection(double desiredRotation, double rotation) {
        double difference = desiredRotation - rotation;
        if (difference >= 180.0) {
            rotation = 360.0;
        } else if (difference <= -180.0) {
            rotation = -360.0;
        }
        double lowerBound = desiredRotation - 1.0;
        return rotation > lowerBound;
    }

    @Override
    public Stargate.Feedback resetStargate(Stargate.Feedback feedback) {
        this.animationTicks = 1;
        this.symbolBuffer = 0;
        this.addressBuffer = new int[0];
        if (this.isConnected()) {
            this.closeWormholeSound();
            this.setConnected(false);
        }
        this.resetAddress();
        this.dialingOut = false;
        this.connectionID = "sgjourney:empty";
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Fail(this.f_58858_));
        this.m_6596_();
        StargateJourney.LOGGER.info("Reset Stargate at " + this.m_58899_().m_123341_() + " " + this.m_58899_().m_123342_() + " " + this.m_58899_().m_123343_());
        return this.setRecentFeedback(feedback);
    }

    private void synchronizeWithClient(Level level) {
        if (level.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundUniverseStargateUpdatePacket(this.f_58858_, this.symbolBuffer, this.addressBuffer, this.animationTicks, this.rotation, this.oldRotation));
    }

    @Override
    public void playRotationSound() {
        if (!this.spinSound.isPlaying()) {
            this.spinSound.playSound();
        }
    }

    @Override
    public void stopRotationSound() {
        this.spinSound.stopSound();
    }
}

