/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.sound.SoundWrapper;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundMilkyWayStargateUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargatePart;
import org.jetbrains.annotations.NotNull;

public class MilkyWayStargateEntity
extends AbstractStargateEntity {
    private static final double angle = 9.23076923076923;
    private int rotation = 0;
    public int oldRotation = 0;
    public boolean isChevronRaised = false;
    private Map<StargatePart, Integer> signalMap = Maps.newHashMap();
    public int signalStrength = 0;
    public boolean computerRotation = false;
    public int desiredSymbol = 0;
    public boolean rotateClockwise = true;
    public SoundWrapper buildupSound = null;

    public MilkyWayStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.MILKY_WAY_STARGATE.get(), pos, state, Stargate.Gen.GEN_2, 2);
    }

    @Override
    public void onLoad() {
        if (!this.f_58857_.m_5776_() && !this.addToNetwork) {
            Random random = new Random();
            this.setRotation(2 * random.nextInt(0, 181));
        }
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isPointOfOriginValid(this.f_58857_)) {
            StargateJourney.LOGGER.info("PoO is not valid " + this.pointOfOrigin);
            this.setPointOfOrigin(this.m_58904_());
        }
        if (!this.areSymbolsValid(this.f_58857_)) {
            StargateJourney.LOGGER.info("Symbols are not valid " + this.symbols);
            this.setSymbols(this.m_58904_());
        }
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.pointOfOrigin = nbt.m_128461_("PointOfOrigin");
        this.symbols = nbt.m_128461_("Symbols");
        this.oldRotation = this.rotation = nbt.m_128451_("Rotation");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128359_("PointOfOrigin", this.pointOfOrigin);
        nbt.m_128359_("Symbols", this.symbols);
        nbt.m_128405_("Rotation", this.rotation);
    }

    @Override
    public SoundEvent getChevronEngageSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_CHEVRON_ENGAGE.get();
    }

    public SoundEvent getChevronEncodeSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_CHEVRON_ENCODE.get();
    }

    @Override
    public SoundEvent getWormholeOpenSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_WORMHOLE_OPEN.get();
    }

    @Override
    public SoundEvent getFailSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_DIAL_FAIL.get();
    }

    private void manualDialing() {
        if (this.signalStrength > 0) {
            if (this.signalStrength == 15) {
                if (!this.isConnected()) {
                    this.raiseChevron();
                } else {
                    this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_POINT_OF_ORIGIN);
                }
            }
        } else {
            this.lowerChevron();
        }
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient(this.f_58857_);
        }
    }

    private boolean hadBestRedstoneSignalChanged() {
        int previousSignalStrength = this.signalStrength;
        this.signalStrength = 0;
        this.signalMap.forEach((stargatePart, signal) -> {
            if (signal > this.signalStrength) {
                this.signalStrength = signal;
            }
        });
        return previousSignalStrength != this.signalStrength;
    }

    public void updateSignal(StargatePart part, int signal) {
        if (!((Boolean)CommonStargateConfig.enable_redstone_dialing.get()).booleanValue()) {
            return;
        }
        if (this.signalMap.containsKey((Object)part)) {
            this.signalMap.remove((Object)part);
        }
        this.signalMap.put(part, signal);
        if (this.hadBestRedstoneSignalChanged()) {
            this.manualDialing();
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getRotation(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.getRotation() : Mth.m_14179_((float)partialTick, (float)this.oldRotation, (float)this.rotation);
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isRotating() {
        return this.rotation != this.oldRotation;
    }

    public Stargate.Feedback raiseChevron() {
        if (!this.isChevronRaised && !Address.addressContainsSymbol(this.getAddress(), this.getCurrentSymbol())) {
            if (!this.f_58857_.m_5776_()) {
                PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Chevron(this.f_58858_, true));
            }
            this.isChevronRaised = true;
            if (!this.f_58857_.m_5776_()) {
                this.synchronizeWithClient(this.f_58857_);
            }
            return Stargate.Feedback.CHEVRON_RAISED;
        }
        return this.setRecentFeedback(Stargate.Feedback.CHEVRON_ALREADY_RAISED);
    }

    public Stargate.Feedback lowerChevron() {
        if (this.isChevronRaised) {
            this.isChevronRaised = false;
            return this.setRecentFeedback(this.engageSymbol(this.getCurrentSymbol()));
        }
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient(this.f_58857_);
        }
        return this.setRecentFeedback(Stargate.Feedback.CHEVRON_ALREADY_LOWERED);
    }

    public int getCurrentSymbol() {
        double position = (double)this.rotation / 9.23076923076923;
        int currentSymbol = (int)position;
        if (position >= (double)currentSymbol + 0.5) {
            ++currentSymbol;
        }
        if (currentSymbol > 38) {
            currentSymbol -= 39;
        }
        return currentSymbol;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MilkyWayStargateEntity stargate) {
        stargate.rotate();
        if (stargate.isRotating() && !level.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(stargate.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(stargate.f_58858_, false));
        }
        AbstractStargateEntity.tick(level, pos, state, stargate);
    }

    private void rotate() {
        if (!this.isConnected() && !this.isChevronRaised) {
            if (this.computerRotation) {
                if (this.isCurrentSymbol(this.desiredSymbol)) {
                    this.endRotation();
                } else {
                    this.rotate(this.rotateClockwise);
                }
            } else if (this.signalStrength > 0 && this.signalStrength < 15) {
                if (this.signalStrength > 7) {
                    this.rotate(false);
                } else {
                    this.rotate(true);
                }
            } else {
                this.syncRotation();
            }
        } else {
            this.syncRotation();
        }
        this.m_6596_();
    }

    public void rotate(boolean clockwise) {
        this.oldRotation = this.rotation;
        this.rotation = clockwise ? (this.rotation -= 2) : (this.rotation += 2);
        if (this.rotation >= 360) {
            this.rotation -= 360;
            this.oldRotation -= 360;
        } else if (this.rotation < 0) {
            this.rotation += 360;
            this.oldRotation += 360;
        }
        this.m_6596_();
    }

    public boolean isCurrentSymbol(int desiredSymbol) {
        double position = (double)this.rotation / 9.23076923076923;
        double lowerBound = (double)desiredSymbol - 0.12;
        double upperBound = (double)desiredSymbol + 0.12;
        return position > lowerBound && position < upperBound;
    }

    private void synchronizeWithClient(Level level) {
        if (level.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundMilkyWayStargateUpdatePacket(this.f_58858_, this.rotation, this.oldRotation, this.isChevronRaised, this.signalStrength, this.computerRotation, this.rotateClockwise, this.desiredSymbol));
    }

    private void syncRotation() {
        this.oldRotation = this.rotation;
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient(this.f_58857_);
        }
    }

    public void startRotation(int desiredSymbol, boolean rotateClockwise) {
        if (this.isChevronRaised) {
            return;
        }
        this.computerRotation = true;
        this.desiredSymbol = desiredSymbol;
        this.rotateClockwise = rotateClockwise;
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.MilkyWayBuildup(this.f_58858_));
        }
        this.synchronizeWithClient(this.f_58857_);
    }

    public void endRotation() {
        this.computerRotation = false;
        this.synchronizeWithClient(this.f_58857_);
    }

    public void playBuildupSound() {
        if (this.buildupSound.isPlaying()) {
            this.buildupSound.stopSound();
        }
        this.buildupSound.playSound();
    }

    @Override
    public void playRotationSound() {
        if (!this.spinSound.isPlaying()) {
            this.spinSound.stopSound();
            this.spinSound.playSound();
        }
    }

    @Override
    public void stopRotationSound() {
    }
}

