/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.stargate.Stargate;
import org.jetbrains.annotations.NotNull;

public class ClassicStargateEntity
extends AbstractStargateEntity {
    private static final short ROTATION_TICK_DURATION = 40;
    private static final short CHEVRON_LOCK_TICK_DURATION = 20;
    private short rotationOld = 0;
    private short rotation = 0;
    public int[] addressBuffer = new int[0];
    public int symbolBuffer = 0;

    public ClassicStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.CLASSIC_STARGATE.get(), pos, state, Stargate.Gen.NONE, 0);
        this.pointOfOrigin = "sgjourney:tauri";
        this.symbols = "sgjourney:milky_way";
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("Rotation")) {
            this.rotation = nbt.m_128448_("Rotation");
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128376_("Rotation", this.rotation);
        super.m_183515_(nbt);
    }

    @Override
    public SoundEvent getChevronEngageSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_CHEVRON_ENGAGE.get();
    }

    @Override
    public SoundEvent getWormholeOpenSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_WORMHOLE_OPEN.get();
    }

    @Override
    public SoundEvent getFailSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_DIAL_FAIL.get();
    }

    public double angle() {
        return 10.0;
    }

    public short getRotation() {
        return this.rotation;
    }

    public void setRotation(short rotation) {
        this.rotation = rotation;
    }

    public int getCurrentSymbol() {
        int currentSymbol;
        double position = (double)(this.rotation * 2) / this.angle();
        if (position >= (double)(currentSymbol = (int)position) + 0.5) {
            ++currentSymbol;
        }
        if (currentSymbol > 38) {
            currentSymbol -= 39;
        }
        return currentSymbol;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ClassicStargateEntity stargate) {
        stargate.handleRotation();
        AbstractStargateEntity.tick(level, pos, state, stargate);
    }

    private void handleRotation() {
        this.rotationOld = this.rotation;
    }

    private void rotate() {
        this.rotation = (short)(this.rotation + 4);
    }

    public float getRotation(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.rotationOld, (float)this.rotation);
    }

    @Override
    public void playRotationSound() {
    }

    @Override
    public void stopRotationSound() {
    }
}

