/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.sound.SoundWrapper;
import net.povstalec.sgjourney.common.block_entities.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.SGJourneyBlockEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.misc.ArrayHelper;
import net.povstalec.sgjourney.common.misc.Orientation;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundStargateUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Dialing;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargatePart;
import net.povstalec.sgjourney.common.stargate.Symbols;
import net.povstalec.sgjourney.common.stargate.Wormhole;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStargateEntity
extends SGJourneyBlockEntity {
    private static final String EVENT_CHEVRON_ENGAGED = "stargate_chevron_engaged";
    protected static Stargate.Gen generation;
    protected int network;
    protected Stargate.Feedback recentFeedback = Stargate.Feedback.NONE;
    protected int kawooshTick = 0;
    protected int animationTick = 0;
    protected int[] engagedChevrons = Stargate.DIALING_CHEVRON_CONFIGURATION;
    protected boolean dialingOut = false;
    protected int timesOpened = 0;
    protected String pointOfOrigin = "sgjourney:empty";
    protected String symbols = "sgjourney:empty";
    protected int[] address = new int[0];
    protected String connectionID = "sgjourney:empty";
    protected Wormhole wormhole = new Wormhole();
    protected boolean hasDHD = false;
    protected boolean advancedProtocolsEnabled = false;
    protected int openSoundLead = 28;
    public SoundWrapper wormholeIdleSound = null;
    public SoundWrapper wormholeOpenSound = null;
    public SoundWrapper spinSound = null;

    public AbstractStargateEntity(BlockEntityType<?> blockEntity, BlockPos pos, BlockState state, Stargate.Gen gen, int defaultNetwork) {
        super(blockEntity, pos, state, SGJourneyBlockEntity.Type.STARGATE);
        generation = gen;
        this.network = defaultNetwork;
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.dialingOut = nbt.m_128471_("DialingOut");
        this.timesOpened = nbt.m_128451_("TimesOpened");
        this.address = nbt.m_128465_("Address");
        this.network = nbt.m_128451_("Network");
        this.connectionID = nbt.m_128461_("ConnectionID");
        this.advancedProtocolsEnabled = nbt.m_128471_("AdvancedProtocolsEnabled");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128379_("DialingOut", this.dialingOut);
        nbt.m_128405_("TimesOpened", this.timesOpened);
        nbt.m_128385_("Address", this.address);
        nbt.m_128405_("Network", this.network);
        nbt.m_128359_("ConnectionID", this.connectionID);
        nbt.m_128379_("AdvancedProtocolsEnabled", this.advancedProtocolsEnabled);
        super.m_183515_(nbt);
    }

    @Override
    public CompoundTag addToBlockEntityList() {
        CompoundTag blockEntity = super.addToBlockEntityList();
        StargateNetwork.get(this.f_58857_).addStargate(this.f_58857_.m_7654_(), this.getID(), blockEntity, this.getGeneration().getGen());
        return blockEntity;
    }

    @Override
    public CompoundTag addNewToBlockEntityList() {
        CompoundTag blockEntity = super.addNewToBlockEntityList();
        StargateNetwork.get(this.f_58857_).addStargate(this.f_58857_.m_7654_(), this.getID(), blockEntity, this.getGeneration().getGen());
        return blockEntity;
    }

    @Override
    public void removeFromBlockEntityList() {
        super.removeFromBlockEntityList();
        StargateNetwork.get(this.f_58857_).removeStargate(this.f_58857_, this.getID());
    }

    @Override
    protected String generateID() {
        Random random = new Random();
        String address = "sgjourney:empty";
        do {
            address = Address.addressIntArrayToString(Address.randomAddress(8, 36, random.nextLong()));
        } while (BlockEntityList.get(this.f_58857_).getBlockEntities(SGJourneyBlockEntity.Type.STARGATE.id).m_128441_(address));
        return address;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.getCenterPos().m_123341_() - 3), (double)(this.getCenterPos().m_123342_() - 3), (double)(this.getCenterPos().m_123343_() - 3), (double)(this.getCenterPos().m_123341_() + 4), (double)(this.getCenterPos().m_123342_() + 4), (double)(this.getCenterPos().m_123343_() + 4));
    }

    public Stargate.Feedback engageSymbol(int symbol) {
        if (this.f_58857_.m_5776_()) {
            return Stargate.Feedback.NONE;
        }
        if (symbol == 0) {
            return this.setRecentFeedback(this.lockPrimaryChevron());
        }
        return this.setRecentFeedback(this.encodeChevron(symbol, false));
    }

    public Stargate.Feedback encodeChevron(int symbol, boolean incoming) {
        if (Address.addressContainsSymbol(this.getAddress(), symbol)) {
            return this.setRecentFeedback(Stargate.Feedback.SYMBOL_IN_ADDRESS);
        }
        if (this.getAddress().length >= 8) {
            return this.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
        }
        this.growAddress(symbol);
        this.chevronSound(incoming);
        this.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.getAddress().length, symbol, incoming);
        this.m_6596_();
        return Stargate.Feedback.SYMBOL_ENCODED;
    }

    protected Stargate.Feedback lockPrimaryChevron() {
        if (this.f_58857_.m_5776_()) {
            return Stargate.Feedback.NONE;
        }
        if (this.getAddress().length < 6) {
            return this.resetStargate(Stargate.Feedback.INCOPLETE_ADDRESS);
        }
        if (!this.isConnected()) {
            if (!this.isObstructed()) {
                this.chevronSound(false);
                this.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.getAddress().length + 1, 0, false);
                return this.setRecentFeedback(this.engageStargate());
            }
            return this.resetStargate(Stargate.Feedback.SELF_OBSTRUCTED);
        }
        return this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT);
    }

    public void chevronSound(boolean incoming) {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Chevron(this.f_58858_, false));
        }
    }

    public void openWormholeSound() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.OpenWormhole(this.f_58858_));
    }

    public void idleWormholeSound() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.IdleWormhole(this.f_58858_));
    }

    public void closeWormholeSound() {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.CloseWormhole(this.f_58858_));
        }
    }

    public abstract void playRotationSound();

    public abstract void stopRotationSound();

    public void playWormholeIdleSound() {
        this.wormholeIdleSound.playSound();
    }

    public Stargate.Feedback engageStargate() {
        return Dialing.dialStargate(this.f_58857_, this);
    }

    public Stargate.Feedback dialStargate(AbstractStargateEntity targetStargate) {
        return StargateNetwork.get(this.f_58857_).createConnection(this.f_58857_.m_7654_(), this, targetStargate);
    }

    public void connectStargate(String connectionID, boolean dialingOut) {
        this.connectionID = connectionID;
        this.setConnected(true);
        this.setDialingOut(dialingOut);
        ++this.timesOpened;
        this.m_6596_();
        this.updateStargate();
    }

    public static double kawooshFunction(int kawooshTime) {
        return 8.0 * Math.sin(Math.PI * (double)kawooshTime / 40.0);
    }

    public void doKawoosh(int kawooshTime) {
        this.setKawooshTickCount(kawooshTime);
        this.updateClient();
        if (kawooshTime > 40) {
            return;
        }
        BlockPos centerPos = this.getCenterPos();
        Direction axisDirection = this.getDirection().m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        Direction direction = Orientation.getEffectiveDirection(this.getDirection(), this.getOrientation());
        double frontMultiplier = AbstractStargateEntity.kawooshFunction(kawooshTime);
        for (int width = -1; width <= 1; ++width) {
            for (int height = -1; height <= 1; ++height) {
                BlockPos pos = centerPos.m_5484_(axisDirection, width).m_5484_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.f_58857_.m_8055_(pos);
                if (state.m_60734_() instanceof AbstractStargateBlock) continue;
                for (int i = 0; i < (int)Math.round(frontMultiplier); ++i) {
                    if (this.f_58857_.m_8055_(pos.m_5484_(direction, i)).m_60713_(Blocks.f_50016_)) continue;
                    this.f_58857_.m_46961_(pos.m_5484_(direction, i), false);
                }
            }
            Vec3 centerVector = this.getCenter();
            Vec3 backVector = centerVector.m_231075_(axisDirection, -2.25).m_231075_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), -2.25);
            frontMultiplier = frontMultiplier > 7.0 ? 7.0 : frontMultiplier;
            Vec3 facingVector = Orientation.getEffectiveVector(direction, this.getOrientation());
            facingVector = facingVector.m_82542_(frontMultiplier, frontMultiplier, frontMultiplier);
            facingVector = facingVector.m_82549_(centerVector);
            facingVector = facingVector.m_231075_(axisDirection, 2.25).m_231075_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), 2.25);
            AABB kawooshHitbox = new AABB(backVector.m_7096_(), backVector.m_7098_(), backVector.m_7094_(), facingVector.m_7096_(), facingVector.m_7098_(), facingVector.m_7094_());
            this.f_58857_.m_45976_(Entity.class, kawooshHitbox).stream().forEach(entity -> {
                Player player;
                if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
                    entity.m_6074_();
                }
            });
        }
    }

    public Stargate.Feedback resetStargate(Stargate.Feedback feedback) {
        if (this.isConnected()) {
            this.closeWormholeSound();
            this.setConnected(false);
        }
        this.resetAddress();
        this.dialingOut = false;
        this.connectionID = "sgjourney:empty";
        this.setKawooshTickCount(0);
        this.updateClient();
        if (feedback.playFailSound() && !this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Fail(this.f_58858_));
        }
        this.m_6596_();
        StargateJourney.LOGGER.info("Reset Stargate at " + this.m_58899_().m_123341_() + " " + this.m_58899_().m_123342_() + " " + this.m_58899_().m_123343_() + " " + this.m_58904_().m_46472_().m_135782_().toString());
        return this.setRecentFeedback(feedback);
    }

    public Stargate.Feedback disconnectStargate(Stargate.Feedback feedback) {
        if (!((Boolean)CommonStargateConfig.end_connection_from_both_ends.get()).booleanValue() && !this.isDialingOut()) {
            return Stargate.Feedback.WRONG_DISCONNECT_SIDE;
        }
        return this.bypassDisconnectStargate(feedback);
    }

    public Stargate.Feedback bypassDisconnectStargate(Stargate.Feedback feedback) {
        StargateNetwork.get(this.f_58857_).terminateConnection(this.f_58857_.m_7654_(), this.connectionID, feedback);
        return this.resetStargate(feedback);
    }

    public void updateStargate() {
        this.updateStargate(this.f_58857_, this.getID(), this.timesOpened, this.hasDHD);
    }

    private void updateStargate(Level level, String id, int timesOpened, boolean hasDHD) {
        StargateNetwork.get(level).updateStargate(level, id, timesOpened, hasDHD);
        this.setStargateState(this.isConnected(), this.getChevronsEngaged());
    }

    protected void growAddress(int symbol) {
        this.address = ArrayHelper.growIntArray(this.address, symbol);
        this.setStargateState(this.isConnected(), this.getChevronsEngaged());
        this.updateClient();
    }

    protected void resetAddress() {
        this.address = new int[0];
        this.engagedChevrons = Stargate.DIALING_CHEVRON_CONFIGURATION;
        this.setStargateState(false, 0);
    }

    public String getConnectionAddress(int addressLength) {
        String dimension = this.f_58857_.m_46472_().m_135782_().toString();
        switch (addressLength) {
            case 6: {
                String galaxy = (String)Universe.get(this.f_58857_).getGalaxiesFromDimension(dimension).m_128728_(0).m_128431_().iterator().next();
                return Universe.get(this.f_58857_).getAddressInGalaxyFromDimension(galaxy, dimension);
            }
            case 7: {
                return Universe.get(this.f_58857_).getExtragalacticAddressFromDimension(dimension);
            }
        }
        return this.getID();
    }

    public Stargate.Feedback setRecentFeedback(Stargate.Feedback feedback) {
        this.recentFeedback = feedback;
        return this.getRecentFeedback();
    }

    public Stargate.Feedback getRecentFeedback() {
        return this.recentFeedback;
    }

    public void setPointOfOrigin(Level level) {
        this.pointOfOrigin = Universe.get(level).getPointOfOrigin(level.m_46472_().m_135782_().toString());
        this.m_6596_();
    }

    protected boolean isPointOfOriginValid(Level level) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
        if (!this.isLocationValid(this.pointOfOrigin)) {
            return false;
        }
        return pointOfOriginRegistry.m_7804_(new ResourceLocation(this.pointOfOrigin));
    }

    public void setSymbols(Level level) {
        this.symbols = Universe.get(level).getSymbols(level.m_46472_().m_135782_().toString());
        this.m_6596_();
    }

    protected boolean areSymbolsValid(Level level) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry symbolRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
        if (!this.isLocationValid(this.symbols)) {
            return false;
        }
        return symbolRegistry.m_7804_(new ResourceLocation(this.symbols));
    }

    private boolean isLocationValid(String location) {
        String[] split = location.split(":");
        if (split.length > 2) {
            return false;
        }
        if (!ResourceLocation.m_135843_((String)split[0])) {
            return false;
        }
        return ResourceLocation.m_135841_((String)split[1]);
    }

    public int getMaxGateOpenTime() {
        return (Integer)CommonStargateConfig.max_wormhole_open_time.get() * 20;
    }

    public Stargate.Gen getGeneration() {
        return generation;
    }

    public void setKawooshTickCount(int kawooshTick) {
        this.kawooshTick = kawooshTick;
    }

    public int getKawooshTickCount() {
        return this.kawooshTick;
    }

    public void setTickCount(int animationTick) {
        this.animationTick = animationTick;
    }

    public int getTickCount() {
        return this.animationTick;
    }

    public int increaseTickCount() {
        ++this.animationTick;
        return this.animationTick;
    }

    public void setDialingOut(boolean dialingOut) {
        this.dialingOut = dialingOut;
    }

    public boolean isDialingOut() {
        return this.dialingOut;
    }

    public void setDHD(boolean hasDHD, boolean enableAdvancedProtocols) {
        if (this.hasDHD != hasDHD) {
            this.updateStargate(this.f_58857_, this.getID(), this.timesOpened, hasDHD);
        }
        this.advancedProtocolsEnabled = hasDHD ? enableAdvancedProtocols : false;
        this.hasDHD = hasDHD;
    }

    public boolean advancedProtocolsEnabled() {
        return this.advancedProtocolsEnabled;
    }

    public boolean hasDHD() {
        return this.hasDHD;
    }

    public int getOpenTime() {
        if (this.f_58857_.m_5776_()) {
            return 0;
        }
        return StargateNetwork.get(this.f_58857_).getOpenTime(this.connectionID);
    }

    public int getTimeSinceLastTraveler() {
        if (this.f_58857_.m_5776_()) {
            return 0;
        }
        return StargateNetwork.get(this.f_58857_).getTimeSinceLastTraveler(this.connectionID);
    }

    public int getTimesOpened() {
        return this.timesOpened;
    }

    public void setPointOfOrigin(String pointOfOrigin) {
        this.pointOfOrigin = pointOfOrigin;
    }

    public String getPointOfOrigin() {
        return this.pointOfOrigin;
    }

    public void setSymbols(String symbols) {
        this.symbols = symbols;
    }

    public String getSymbols() {
        return this.symbols;
    }

    public void setAddress(int[] address) {
        this.address = address;
    }

    public int[] getAddress() {
        return this.address;
    }

    public int getChevronsEngaged() {
        int chevronsEngaged = this.getAddress().length;
        return this.isConnected() ? chevronsEngaged + 1 : chevronsEngaged;
    }

    public void setEngagedChevrons(int[] engagedChevrons) {
        this.engagedChevrons = engagedChevrons;
    }

    public static int[] getChevronConfiguration(int addressLength) {
        switch (addressLength) {
            case 6: {
                return Stargate.DIALED_7_CHEVRON_CONFIGURATION;
            }
            case 7: {
                return Stargate.DIALED_8_CHEVRON_CONFIGURATION;
            }
            case 8: {
                return Stargate.DIALED_9_CHEVRON_CONFIGURATION;
            }
        }
        return Stargate.DIALING_CHEVRON_CONFIGURATION;
    }

    public int[] getEngagedChevrons() {
        return this.engagedChevrons;
    }

    public int chevronsRendered() {
        return this.getAddress().length;
    }

    public BlockPos getCenterPos() {
        BlockPos mainBlockPos = this.m_58899_();
        Direction centerDirection = Orientation.getCenterDirection(this.getDirection(), this.getOrientation());
        return mainBlockPos.m_5484_(centerDirection, 3);
    }

    public Vec3 getCenter() {
        BlockPos centerPos = this.getCenterPos();
        double y = this.getGateType().getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = this.getGateType().getHorizontalCenterHeight();
        }
        return new Vec3((double)centerPos.m_123341_() + 0.5, (double)centerPos.m_123342_() + y, (double)centerPos.m_123343_() + 0.5);
    }

    public Vec3 getRelativeCenter() {
        BlockPos mainBlockPos = this.m_58899_();
        BlockPos centerPos = this.getCenterPos();
        Stargate.Type type = this.getGateType();
        double y = type == null ? 0.5 : (double)type.getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = type.getHorizontalCenterHeight();
        }
        return new Vec3((double)(centerPos.m_123341_() - mainBlockPos.m_123341_()) + 0.5, (double)(centerPos.m_123342_() - mainBlockPos.m_123342_()) + y, (double)(centerPos.m_123343_() - mainBlockPos.m_123343_()) + 0.5);
    }

    public Orientation getOrientation() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
            return (Orientation)((Object)gateState.m_61143_((Property)AbstractStargateBaseBlock.ORIENTATION));
        }
        StargateJourney.LOGGER.info("Couldn't find Stargate Orientation");
        return null;
    }

    public Direction getDirection() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
            return (Direction)gateState.m_61143_((Property)AbstractStargateBaseBlock.FACING);
        }
        StargateJourney.LOGGER.info("Couldn't find Stargate Direction");
        return null;
    }

    public void setConnected(boolean isConnected) {
        this.setStargateState(isConnected, this.getChevronsEngaged());
    }

    public void setStargateState(boolean isConnected, int chevronsEngaged) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargate = (AbstractStargateBaseBlock)block;
            stargate.updateStargate(this.f_58857_, gatePos, gateState, isConnected, chevronsEngaged);
        } else {
            StargateJourney.LOGGER.info("Couldn't find Stargate");
        }
        this.m_6596_();
    }

    public boolean isConnected() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
            return (Boolean)this.f_58857_.m_8055_(gatePos).m_61143_((Property)AbstractStargateBaseBlock.CONNECTED);
        }
        return false;
    }

    public boolean isObstructed() {
        Direction direction = this.getDirection().m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        BlockPos centerPos = this.getCenterPos();
        int obstructingBlocks = 0;
        for (int width = -2; width <= 2; ++width) {
            for (int height = -2; height <= 2; ++height) {
                BlockPos pos = centerPos.m_5484_(direction, width).m_5484_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.f_58857_.m_8055_(pos);
                if ((state.m_247087_() || state.m_60734_() instanceof AbstractStargateBlock) && !state.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) continue;
                ++obstructingBlocks;
            }
        }
        return obstructingBlocks > 12;
    }

    public void updateInterfaceBlocks(String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            for (StargatePart part : stargateBlock.getStargateType().getParts()) {
                BlockPos pos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos.m_121945_(direction));
                    if (!(blockEntity instanceof BasicInterfaceEntity)) continue;
                    BasicInterfaceEntity interfaceEntity = (BasicInterfaceEntity)blockEntity;
                    interfaceEntity.queueEvent(eventName, objects);
                }
            }
        }
    }

    public boolean hasEnergy(AbstractStargateEntity targetStargate) {
        return this.getEnergyStored() >= StargateNetwork.getConnectionType(this.f_58857_.m_7654_(), this, targetStargate).getEstabilishingPowerCost();
    }

    public Wormhole getWormhole() {
        return this.wormhole;
    }

    public void setOpenSoundLead(int openSoundLead) {
        this.openSoundLead = openSoundLead;
    }

    public int getOpenSoundLead() {
        return this.openSoundLead;
    }

    public abstract SoundEvent getChevronEngageSound();

    public abstract SoundEvent getWormholeOpenSound();

    public SoundEvent getWormholeCloseSound() {
        return (SoundEvent)SoundInit.WORMHOLE_CLOSE.get();
    }

    public abstract SoundEvent getFailSound();

    @Override
    public void getStatus(Player player) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        super.getStatus(player);
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.point_of_origin").m_7220_((Component)Component.m_237113_((String)(": " + this.pointOfOrigin))).m_130940_(ChatFormatting.DARK_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.symbols").m_7220_((Component)Component.m_237113_((String)(": " + this.symbols))).m_130940_(ChatFormatting.LIGHT_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.open_time").m_7220_((Component)Component.m_237113_((String)(": " + this.getOpenTime() + "/" + this.getMaxGateOpenTime()))).m_130940_(ChatFormatting.DARK_AQUA));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.times_opened").m_7220_((Component)Component.m_237113_((String)(": " + this.timesOpened))).m_130940_(ChatFormatting.BLUE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.has_dhd").m_7220_((Component)Component.m_237113_((String)(": " + this.hasDHD))).m_130940_(ChatFormatting.GOLD));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.advanced_protocols_enabled").m_7220_((Component)Component.m_237113_((String)(": " + this.advancedProtocolsEnabled))).m_130940_(ChatFormatting.RED));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.last_traveler_time").m_7220_((Component)Component.m_237113_((String)(": " + this.getTimeSinceLastTraveler()))).m_130940_(ChatFormatting.DARK_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.address").m_7220_((Component)Component.m_237113_((String)(": " + Address.addressIntArrayToString(this.getAddress())))).m_130940_(ChatFormatting.GREEN));
    }

    @Override
    public boolean isCorrectSide(Direction side) {
        return false;
    }

    @Override
    public long capacity() {
        return 1000000000000L;
    }

    @Override
    public long maxReceive() {
        return 1000000000L;
    }

    @Override
    public long maxExtract() {
        return 1000000000L;
    }

    public Stargate.Type getGateType() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargate = (AbstractStargateBaseBlock)block;
            return stargate.getStargateType();
        }
        StargateJourney.LOGGER.info("Couldn't find Stargate Type");
        return null;
    }

    public double getGateAddition() {
        return this.getOrientation() == Orientation.REGULAR ? (double)this.getGateType().getVerticalCenterHeight() : (double)this.getGateType().getHorizontalCenterHeight();
    }

    public void updateClient() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundStargateUpdatePacket(this.f_58858_, this.address, this.engagedChevrons, this.dialingOut, this.kawooshTick, this.animationTick, this.pointOfOrigin, this.symbols));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractStargateEntity stargate) {
        stargate.increaseTickCount();
        if (level.m_5776_()) {
            return;
        }
        stargate.updateClient();
    }
}

