/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.dhd;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.crystals.CommunicationCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.EnergyCrystalItem;
import net.povstalec.sgjourney.common.misc.ArrayHelper;
import org.jetbrains.annotations.NotNull;

public class PegasusDHDEntity
extends AbstractDHDEntity {
    protected int[] memoryCrystals = new int[0];
    protected int[] controlCrystals = new int[0];
    protected int[] energyCrystals = new int[0];
    protected int[] communicationCrystals = new int[0];
    protected final ItemStackHandler itemHandler = this.createHandler();
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public PegasusDHDEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.PEGASUS_DHD.get(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("Inventory"));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    @Override
    public void onLoad() {
        this.recalculateCrystals();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                PegasusDHDEntity.this.m_6596_();
                PegasusDHDEntity.this.recalculateCrystals();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return PegasusDHDEntity.this.isValidCrystal(stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected boolean isValidCrystal(ItemStack stack) {
        if (stack.m_41720_() == ItemInit.ADVANCED_CONTROL_CRYSTAL.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.ADVANCED_MEMORY_CRYSTAL.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.ADVANCED_ENERGY_CRYSTAL.get()) {
            return true;
        }
        return stack.m_41720_() == ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get();
    }

    public void recalculateCrystals() {
        int i;
        this.enableAdvancedProtocols = false;
        this.memoryCrystals = new int[0];
        this.controlCrystals = new int[0];
        this.energyCrystals = new int[0];
        this.desiredEnergyLevel = 0;
        this.maxEnergyTransfer = 0;
        this.communicationCrystals = new int[0];
        for (i = 0; i < 9; ++i) {
            Item item = this.itemHandler.getStackInSlot(i).m_41720_();
            if (item == ItemInit.ADVANCED_CONTROL_CRYSTAL.get()) {
                this.controlCrystals = ArrayHelper.growIntArray(this.controlCrystals, i);
                continue;
            }
            if (item == ItemInit.ADVANCED_MEMORY_CRYSTAL.get()) {
                this.memoryCrystals = ArrayHelper.growIntArray(this.memoryCrystals, i);
                continue;
            }
            if (item == ItemInit.ADVANCED_ENERGY_CRYSTAL.get()) {
                this.energyCrystals = ArrayHelper.growIntArray(this.energyCrystals, i);
                continue;
            }
            if (item != ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get()) continue;
            this.communicationCrystals = ArrayHelper.growIntArray(this.communicationCrystals, i);
        }
        if (this.controlCrystals.length > 0) {
            this.enableAdvancedProtocols = true;
        }
        block5: for (i = 0; i < this.energyCrystals.length; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(this.energyCrystals[i]);
            if (stack.m_41619_()) continue;
            EnergyCrystalItem.CrystalMode mode = EnergyCrystalItem.getCrystalMode(stack);
            switch (mode) {
                case ENERGY_STORAGE: {
                    this.desiredEnergyLevel += ((EnergyCrystalItem)((Object)ItemInit.ADVANCED_ENERGY_CRYSTAL.get())).getMaxStorage();
                    continue block5;
                }
                case ENERGY_TRANSFER: {
                    this.maxEnergyTransfer += ((EnergyCrystalItem)((Object)ItemInit.ADVANCED_ENERGY_CRYSTAL.get())).getMaxTransfer();
                }
            }
        }
    }

    @Override
    public int getMaxDistance() {
        return this.communicationCrystals.length * ((CommunicationCrystalItem)((Object)ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get())).getMaxDistance() + 16;
    }
}

