/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.dhd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.stargate.Stargate;

public abstract class AbstractDHDEntity
extends EnergyBlockEntity {
    private AbstractStargateEntity stargate = null;
    protected boolean enableAdvancedProtocols = false;
    protected int desiredEnergyLevel = 150000;
    protected int maxEnergyTransfer = 2500;

    public AbstractDHDEntity(BlockEntityType<?> blockEntity, BlockPos pos, BlockState state) {
        super(blockEntity, pos, state);
    }

    public int getMaxDistance() {
        return 16;
    }

    @Override
    public boolean isCorrectSide(Direction side) {
        return false;
    }

    @Override
    protected long capacity() {
        return 0L;
    }

    @Override
    protected long maxReceive() {
        return 0L;
    }

    @Override
    protected long maxExtract() {
        return 0L;
    }

    @Override
    protected void outputEnergy(Direction outputDirection) {
        if (this.stargate.getEnergyStored() < (long)this.desiredEnergyLevel) {
            long needed = (long)this.desiredEnergyLevel - this.stargate.getEnergyStored();
            long energySent = needed > (long)this.maxEnergyTransfer ? (long)this.maxEnergyTransfer : needed;
            this.stargate.receiveEnergy(energySent, false);
        }
    }

    public AbstractStargateEntity getNearestStargate(int maxDistance) {
        ArrayList stargates = new ArrayList();
        for (int x = -maxDistance / 16; x <= maxDistance / 16; ++x) {
            for (int z = -maxDistance / 16; z <= maxDistance / 16; ++z) {
                ChunkAccess chunk = this.f_58857_.m_46865_(this.m_58899_().m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity patt2916$temp = this.f_58857_.m_7702_(pos);
                    if (patt2916$temp instanceof AbstractStargateEntity) {
                        AbstractStargateEntity stargate = (AbstractStargateEntity)patt2916$temp;
                        stargates.add(stargate);
                    }
                });
            }
        }
        Iterator iterator = stargates.iterator();
        double bestDistance = maxDistance;
        AbstractStargateEntity bestStargate = null;
        while (iterator.hasNext()) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)((Object)iterator.next());
            double distance = this.distance(this.m_58899_(), stargate.getCenterPos());
            if (!(distance <= bestDistance)) continue;
            bestDistance = distance;
            bestStargate = stargate;
        }
        return bestStargate;
    }

    private double distance(BlockPos pos, BlockPos targetPos) {
        int x = Math.abs(targetPos.m_123341_() - pos.m_123341_());
        int y = Math.abs(targetPos.m_123342_() - pos.m_123342_());
        int z = Math.abs(targetPos.m_123343_() - pos.m_123343_());
        double stargateDistance = Math.sqrt(x * x + y * y + z * z);
        return stargateDistance;
    }

    public void engageChevron(int symbol) {
        if (this.stargate != null) {
            Stargate.Feedback feedback;
            if (symbol == 0) {
                this.f_58857_.m_5594_((Player)null, this.m_58899_(), (SoundEvent)SoundInit.MILKY_WAY_DHD_ENTER.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
            }
            if ((feedback = this.stargate.engageSymbol(symbol)).isError()) {
                Component message = feedback.getFeedbackMessage();
                AABB localBox = new AABB((double)(this.m_58899_().m_123341_() - 4), (double)(this.m_58899_().m_123342_() - 4), (double)(this.m_58899_().m_123343_() - 4), (double)(this.m_58899_().m_123341_() + 5), (double)(this.m_58899_().m_123342_() + 5), (double)(this.m_58899_().m_123343_() + 5));
                this.f_58857_.m_45976_(Player.class, localBox).stream().forEach(player -> player.m_5661_(message, true));
            }
        } else {
            System.out.println("Stargate not found");
        }
    }

    public void disconnectFromStargate() {
        if (this.stargate != null) {
            this.setStargateConnection(this.stargate, false);
        }
    }

    private void setStargateConnection(AbstractStargateEntity stargate, boolean hasDHD) {
        stargate.setDHD(hasDHD, this.enableAdvancedProtocols);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractDHDEntity dhd) {
        if (level.m_5776_()) {
            return;
        }
        AbstractStargateEntity nearbyStargate = dhd.getNearestStargate(dhd.getMaxDistance());
        if (dhd.stargate != null && nearbyStargate != null && dhd.stargate != nearbyStargate) {
            dhd.setStargateConnection(dhd.stargate, false);
        }
        dhd.stargate = nearbyStargate;
        if (dhd.stargate != null) {
            dhd.setStargateConnection(dhd.stargate, true);
            dhd.outputEnergy(null);
        }
    }
}

