/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundSymbolUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class SymbolBlockEntity
extends BlockEntity {
    private static final String SYMBOL = "Symbol";
    private static final String EMPTY = "sgjourney:empty";
    public String symbol = "sgjourney:empty";

    public SymbolBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.symbol.equals(EMPTY)) {
            this.setSymbol(this.f_58857_);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(SYMBOL)) {
            this.symbol = tag.m_128461_(SYMBOL);
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        if (this.symbol != null) {
            tag.m_128359_(SYMBOL, this.symbol);
        }
        super.m_183515_(tag);
    }

    public void setSymbol(Level level) {
        if (level.m_5776_()) {
            return;
        }
        this.symbol = Universe.get(level).getPointOfOrigin(level.m_46472_().m_135782_().toString());
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundSymbolUpdatePacket(this.f_58858_, this.symbol));
    }

    public static class Sandstone
    extends SymbolBlockEntity {
        public Sandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.SANDSTONE_SYMBOL.get(), pos, state);
        }
    }

    public static class Stone
    extends SymbolBlockEntity {
        public Stone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.STONE_SYMBOL.get(), pos, state);
        }
    }
}

