/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import org.jetbrains.annotations.NotNull;

public abstract class SGJourneyBlockEntity
extends EnergyBlockEntity {
    protected static final boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    protected static final String ID = "ID";
    protected static final String ADD_TO_NETWORK = "AddToNetwork";
    protected static final String EMPTY = "sgjourney:empty";
    private String id = "sgjourney:empty";
    protected Type type;
    protected boolean addToNetwork = true;

    public SGJourneyBlockEntity(BlockEntityType<?> blockEntity, BlockPos pos, BlockState state, Type type) {
        super(blockEntity, pos, state);
        this.type = type;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.addToNetwork) {
            this.addNewToBlockEntityList();
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.id = tag.m_128461_(ID);
        this.addToNetwork = tag.m_128471_(ADD_TO_NETWORK);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_(ID, this.id);
        tag.m_128379_(ADD_TO_NETWORK, this.addToNetwork);
    }

    @Override
    protected boolean outputsEnergy() {
        return false;
    }

    public CompoundTag addToBlockEntityList() {
        CompoundTag blockEntity;
        if (BlockEntityList.get(this.f_58857_).getBlockEntities(this.type.id).m_128441_(this.id)) {
            StargateJourney.LOGGER.info("Block Entity List already contains " + this.id);
            blockEntity = this.addNewToBlockEntityList();
        } else {
            blockEntity = BlockEntityList.get(this.f_58857_).addBlockEntity(this.f_58857_, this.f_58858_, this.type.id, this.id);
            StargateJourney.LOGGER.info("Block Entity " + this.id + " added.");
        }
        this.addToNetwork = true;
        this.m_6596_();
        return blockEntity;
    }

    public CompoundTag addNewToBlockEntityList() {
        this.setID(this.generateID());
        CompoundTag blockEntity = BlockEntityList.get(this.f_58857_).addBlockEntity(this.f_58857_, this.f_58858_, this.type.id, this.id);
        StargateJourney.LOGGER.info("Block Entity " + this.id + " added.");
        this.addToNetwork = true;
        this.m_6596_();
        return blockEntity;
    }

    public void removeFromBlockEntityList() {
        BlockEntityList.get(this.f_58857_).removeBlockEntity(this.type.id, this.id);
    }

    protected String generateID() {
        return UUID.randomUUID().toString();
    }

    protected void setID(String blockentityID) {
        this.id = blockentityID;
        this.m_6596_();
        StargateJourney.LOGGER.info("Set ID to " + this.id);
    }

    public String getID() {
        return this.id;
    }

    @Override
    public void getStatus(Player player) {
        super.getStatus(player);
        if (this.f_58857_.f_46443_) {
            return;
        }
        player.m_213846_((Component)Component.m_237113_((String)("ID: " + this.id)).m_130940_(ChatFormatting.AQUA));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.add_to_network").m_7220_((Component)Component.m_237113_((String)(": " + this.addToNetwork))).m_130940_(ChatFormatting.YELLOW));
    }

    public static enum Type {
        STARGATE("Stargates"),
        TRANSPORT_RINGS("TransportRings");

        public String id;

        private Type(String id) {
            this.id = id;
        }
    }
}

