/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.povstalec.sgjourney.common.block_entities.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.blocks.CrystalInterfaceBlock;
import net.povstalec.sgjourney.common.capabilities.CCTweakedCapabilities;
import net.povstalec.sgjourney.common.cctweaked.peripherals.CrystalPeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonInterfaceConfig;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import org.jetbrains.annotations.NotNull;

public class CrystalInterfaceEntity
extends BasicInterfaceEntity {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    CrystalPeripheralWrapper peripheralHolder;
    private int inputSignal = 0;

    public CrystalInterfaceEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.CRYSTAL_INTERFACE.get(), pos, state);
        if (ModList.get().isLoaded("computercraft")) {
            this.peripheralHolder = new CrystalPeripheralWrapper(this);
        }
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("Inventory"));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (ModList.get().isLoaded("computercraft") && cap == CCTweakedCapabilities.CAPABILITY_PERIPHERAL) {
            return this.peripheralHolder.newPeripheral().cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean updateInterface(Level level, BlockPos pos, Block block, BlockState state) {
        if (this.peripheralHolder != null) {
            return this.peripheralHolder.resetInterface();
        }
        Block block2 = level.m_8055_(pos).m_60734_();
        if (block2 instanceof CrystalInterfaceBlock) {
            CrystalInterfaceBlock ccInterface = (CrystalInterfaceBlock)block2;
            ccInterface.updateInterface(state, level, pos);
        }
        return true;
    }

    public void setInputSignal(int inputSignal) {
        boolean changed = this.inputSignal != inputSignal;
        this.inputSignal = inputSignal;
        if (changed) {
            this.m_6596_();
        }
    }

    public int getInputSignal() {
        return this.inputSignal;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                CrystalInterfaceEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return CrystalInterfaceEntity.this.isValidCrystal(stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    private boolean isValidCrystal(ItemStack stack) {
        if (stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.MATERIALIZATION_CRYSTAL.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.ENERGY_CRYSTAL.get()) {
            return true;
        }
        return stack.m_41720_() == ItemInit.COMMUNICATION_CRYSTAL.get();
    }

    @Override
    public long capacity() {
        return (Long)CommonInterfaceConfig.advanced_crystal_interface_capacity.get();
    }

    @Override
    public long maxReceive() {
        return (Long)CommonInterfaceConfig.advanced_crystal_interface_max_transfer.get();
    }

    @Override
    public long maxExtract() {
        return (Long)CommonInterfaceConfig.advanced_crystal_interface_max_transfer.get();
    }

    public String getLocalAddress() {
        String dimension = this.f_58857_.m_46472_().m_135782_().toString();
        String galaxy = (String)Universe.get(this.f_58857_).getGalaxiesFromDimension(dimension).m_128728_(0).m_128431_().iterator().next();
        return Universe.get(this.f_58857_).getAddressInGalaxyFromDimension(galaxy, dimension);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrystalInterfaceEntity advancedInterface) {
        BasicInterfaceEntity.tick(level, pos, state, advancedInterface);
    }
}

