/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.client.sound.StargateSoundWrapper;
import net.povstalec.sgjourney.client.sound.sounds.GenericStargateSound;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;

public class SoundAccess {
    protected static Minecraft minecraft = Minecraft.m_91087_();

    public static void playWormholeOpenSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, stargate.getWormholeOpenSound(), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playWormholeIdleSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            if (stargate.wormholeIdleSound == null || !stargate.wormholeIdleSound.hasSound()) {
                stargate.wormholeIdleSound = new StargateSoundWrapper.WormholeIdle(stargate);
            }
            stargate.playWormholeIdleSound();
        }
    }

    public static void playWormholeCloseSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, stargate.getWormholeCloseSound(), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void playChevronSound(BlockPos pos, boolean alternate) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (!(blockEntity instanceof AbstractStargateEntity)) return;
        AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
        if (stargate instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity milkyWayStargate = (MilkyWayStargateEntity)stargate;
            if (alternate) {
                GenericStargateSound sound = new GenericStargateSound(stargate, milkyWayStargate.getChevronEncodeSound(), 0.5f);
                minecraft.m_91106_().m_120367_((SoundInstance)sound);
                return;
            }
        }
        if (stargate instanceof PegasusStargateEntity) {
            PegasusStargateEntity pegasusStargate = (PegasusStargateEntity)stargate;
            if (alternate) {
                GenericStargateSound sound = new GenericStargateSound(stargate, pegasusStargate.chevronIncomingSound(), 0.5f);
                minecraft.m_91106_().m_120367_((SoundInstance)sound);
                return;
            }
        }
        GenericStargateSound sound = new GenericStargateSound(stargate, stargate.getChevronEngageSound(), 0.5f);
        minecraft.m_91106_().m_120367_((SoundInstance)sound);
    }

    public static void playFailSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, stargate.getFailSound(), 0.5f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playRotationSound(BlockPos pos, boolean stop) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            if (stargate.spinSound == null) {
                if (stargate instanceof UniverseStargateEntity) {
                    UniverseStargateEntity universeStargate = (UniverseStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.UniverseRingRotation(universeStargate);
                } else if (stargate instanceof MilkyWayStargateEntity) {
                    MilkyWayStargateEntity milkyWayStargate = (MilkyWayStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.MilkyWayRingRotation(milkyWayStargate);
                } else if (stargate instanceof PegasusStargateEntity) {
                    PegasusStargateEntity pegasusStargate = (PegasusStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.PegasusRingRotation(pegasusStargate);
                }
            }
            if (stop) {
                stargate.stopRotationSound();
            } else {
                stargate.playRotationSound();
            }
        }
    }

    public static void playUniverseStartSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof UniverseStargateEntity) {
            UniverseStargateEntity stargate = (UniverseStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, stargate.getStartSound(), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playMilkyWayBuildupSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)blockEntity;
            if (stargate.buildupSound == null || !stargate.buildupSound.hasSound()) {
                stargate.buildupSound = new StargateSoundWrapper.MilkyWayRingBuildup(stargate);
            }
            stargate.playBuildupSound();
        }
    }
}

