/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.AbstractStargateModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;

public class UniverseStargateModel
extends AbstractStargateModel {
    private static final ResourceLocation RING_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/universe/universe_outer_ring.png");
    private static final ResourceLocation SYMBOL_RING_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/universe/universe_inner_ring.png");
    private static final ResourceLocation CHEVRON_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/universe/universe_chevron.png");
    private static final ResourceLocation ENGAGED_CHEVRON_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/universe/universe_chevron_lit.png");
    private final ModelPart ring;
    private final ModelPart symbolRing;
    private final ModelPart dividers;
    private final ModelPart chevrons;
    private static final int symbolCount = 36;
    private static final double angle = 6.666666507720947;
    private float rotation = 0.0f;

    public UniverseStargateModel(ModelPart ring, ModelPart symbolRing, ModelPart dividers, ModelPart chevrons) {
        super("universe");
        this.ring = ring;
        this.symbolRing = symbolRing;
        this.dividers = dividers;
        this.chevrons = chevrons;
    }

    public void renderStargate(UniverseStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderRing(stargate, stack, source, combinedLight, combinedOverlay);
        this.renderSymbolRing(stargate, stack, source, combinedLight, combinedOverlay, combinedOverlay);
        this.renderChevrons(stargate, stack, source, combinedLight, combinedOverlay, combinedOverlay);
    }

    protected void renderRing(UniverseStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer ringTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)RING_TEXTURE));
        this.ring.m_171327_(0.0f, 0.0f, (float)Math.toRadians(this.rotation));
        this.ring.m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
    }

    protected void renderSymbolRing(UniverseStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, int chevronsActive) {
        int i;
        VertexConsumer symbolRingTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)SYMBOL_RING_TEXTURE));
        for (i = 0; i < 9; ++i) {
            this.getUnderChevronLeft(i).m_171327_(0.0f, 0.0f, (float)Math.toRadians(176.66666674613953 - (double)(40 * i) + (double)this.rotation));
            this.getUnderChevronRight(i).m_171327_(0.0f, 0.0f, (float)Math.toRadians(183.33333325386047 - (double)(40 * i) + (double)this.rotation));
        }
        for (i = 0; i < 9; ++i) {
            this.getUnderChevronLeft(i).m_104301_(stack, symbolRingTexture, combinedLight, combinedOverlay);
            this.getUnderChevronRight(i).m_104301_(stack, symbolRingTexture, combinedLight, combinedOverlay);
        }
        for (i = 0; i < 9; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.getSymbol(i * 4 + j).m_171327_(0.0f, 0.0f, (float)Math.toRadians(170.00000023841858 - (double)(i * 40) - 6.666666507720947 * (double)j + (double)this.rotation));
            }
        }
        for (i = 0; i < 36; ++i) {
            this.getSymbol(i).m_104301_(stack, symbolRingTexture, combinedLight, combinedOverlay);
        }
        for (i = 0; i < 36; ++i) {
            this.getSymbol(i).m_104306_(stack, source.m_6299_(RenderType.m_110482_((ResourceLocation)this.getSymbolTexture(stargate, i))), combinedLight, combinedOverlay, 0.08235294f, 0.03529412f, 0.0f, 1.0f);
        }
        for (i = 0; i < stargate.getAddress().length; ++i) {
            int symbol = stargate.getAddress()[i];
            if (symbol >= 36) continue;
            this.getSymbol(symbol).m_104301_(stack, source.m_6299_(RenderType.m_110482_((ResourceLocation)this.getSymbolTexture(stargate, symbol))), 255, combinedOverlay);
        }
        if (stargate.isConnected()) {
            this.getSymbol(0).m_104301_(stack, source.m_6299_(RenderType.m_110482_((ResourceLocation)this.getSymbolTexture(stargate, 0))), 255, combinedOverlay);
        }
        VertexConsumer ringTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)RING_TEXTURE));
        this.dividers.m_171327_(0.0f, 0.0f, (float)Math.toRadians(this.rotation));
        this.dividers.m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
    }

    protected void renderChevrons(UniverseStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, int chevronsActive) {
        for (int i = 0; i <= 8; ++i) {
            this.renderChevron(stargate, stack, source, combinedLight, combinedOverlay, i);
        }
    }

    protected ModelPart getChevron(int chevron) {
        return this.chevrons.m_171324_("chevron_" + chevron);
    }

    protected void renderChevron(UniverseStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, int chevronNumber) {
        VertexConsumer chevronTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)CHEVRON_TEXTURE));
        this.getChevron(chevronNumber).m_171327_(0.0f, 0.0f, (float)Math.toRadians((float)(-40 * chevronNumber) + this.rotation));
        this.getChevron(chevronNumber).m_104301_(stack, chevronTexture, combinedLight, combinedOverlay);
        if (stargate.isConnected() || stargate.addressBuffer.length > 0) {
            VertexConsumer engagedChevronTexture = source.m_6299_(SGJourneyRenderTypes.stargateChevron(ENGAGED_CHEVRON_TEXTURE));
            this.getChevron(chevronNumber).m_104301_(stack, engagedChevronTexture, 255, combinedOverlay);
        }
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public static LayerDefinition createRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition ring = meshdefinition.m_171576_();
        PartDefinition outerRing = ring.m_171599_("outer_ring", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        UniverseStargateModel.createOuterRing(outerRing);
        PartDefinition backRing = ring.m_171599_("back_ring", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        UniverseStargateModel.createBackRing(backRing);
        PartDefinition innerRing = ring.m_171599_("inner_ring", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        UniverseStargateModel.createInnerRing(innerRing);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static void createOuterRing(PartDefinition outerRing) {
        for (int i = 0; i < 36; ++i) {
            outerRing.m_171599_("outer_ring_" + i, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, -56.0f, -3.5f, 10.0f, 4.0f, 7.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10 * i))));
        }
    }

    public static void createBackRing(PartDefinition backRing) {
        for (int i = 0; i < 54; ++i) {
            backRing.m_171599_("back_ring_" + i, CubeListBuilder.m_171558_().m_171514_(34, 12).m_171481_(-3.0f, -53.0f, -2.5f, 6.0f, 9.0f, 3.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-3.3333332538604736 - 6.666666507720947 * (double)i))));
        }
    }

    public static void createInnerRing(PartDefinition innerRing) {
        for (int i = 0; i < 36; ++i) {
            innerRing.m_171599_("inner_ring_" + i, CubeListBuilder.m_171558_().m_171514_(34, 24).m_171481_(-4.0f, -44.0f, -3.5f, 8.0f, 4.0f, 7.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10 * i))));
        }
    }

    public static LayerDefinition createSymbolRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition symbolRing = meshdefinition.m_171576_();
        UniverseStargateModel.createSymbolRing(symbolRing);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)8, (int)8);
    }

    public static void createSymbolRing(PartDefinition symbolRing) {
        int i;
        for (i = 0; i < 9; ++i) {
            symbolRing.m_171599_("under_chevron_left_" + i, CubeListBuilder.m_171558_().m_171514_(-1, -3).m_171481_(-3.0f, -53.0f, 0.5f, 6.0f, 9.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(176.66666674613953 - (double)(40 * i)))));
        }
        for (i = 0; i < 9; ++i) {
            symbolRing.m_171599_("under_chevron_right_" + i, CubeListBuilder.m_171558_().m_171514_(-1, -3).m_171481_(-3.0f, -53.0f, 0.5f, 6.0f, 9.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(183.33333325386047 - (double)(40 * i)))));
        }
        for (i = 0; i < 9; ++i) {
            for (int j = 0; j < 4; ++j) {
                symbolRing.m_171599_("symbol_" + (i * 4 + j), CubeListBuilder.m_171558_().m_171514_(-1, -3).m_171481_(-3.0f, -53.0f, 0.5f, 6.0f, 9.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(170.00000023841858 - (double)(i * 40) - 6.666666507720947 * (double)j))));
            }
        }
    }

    protected ModelPart getSymbol(int symbol) {
        return this.symbolRing.m_171324_("symbol_" + symbol);
    }

    protected ModelPart getUnderChevronLeft(int chevron) {
        return this.symbolRing.m_171324_("under_chevron_left_" + chevron);
    }

    protected ModelPart getUnderChevronRight(int chevron) {
        return this.symbolRing.m_171324_("under_chevron_right_" + chevron);
    }

    public static LayerDefinition createDividerLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition dividers = meshdefinition.m_171576_();
        UniverseStargateModel.createDividers(dividers);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static void createDividers(PartDefinition dividers) {
        for (int i = 0; i < 54; ++i) {
            if (i % 6 == 0) {
                dividers.m_171599_("divider_" + i, CubeListBuilder.m_171558_().m_171514_(28, 35).m_171481_(-2.0f, -52.0f, -3.5f, 4.0f, 8.0f, 7.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(180.0 - 6.666666507720947 * (double)i))));
                continue;
            }
            dividers.m_171599_("divider_" + i, CubeListBuilder.m_171558_().m_171514_(50, 35).m_171481_(-0.5f, -53.0f, -3.0f, 1.0f, 9.0f, 6.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(180.0 - 6.666666507720947 * (double)i))));
        }
    }

    public static LayerDefinition createChevronLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition chevrons = meshdefinition.m_171576_();
        for (int i = 0; i <= 8; ++i) {
            UniverseStargateModel.createChevron(chevrons.m_171599_("chevron_" + i, CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40 * i)))));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static void createChevron(PartDefinition chevron) {
        PartDefinition chevronLightFront = chevron.m_171599_("chevron_light_front", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)54.5f, (float)4.5f));
        UniverseStargateModel.createChevronLight(chevronLightFront);
        PartDefinition chevronLightBack = chevron.m_171599_("chevron_light_back", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)54.5f, (float)-5.5f));
        UniverseStargateModel.createChevronLight(chevronLightBack);
        PartDefinition outerChevronFront = chevron.m_171599_("outer_chevron_front", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)50.0f, (float)3.5f));
        UniverseStargateModel.createOuterChevron(outerChevronFront);
        PartDefinition outerChevronFrontLights = chevron.m_171599_("outer_chevron_front_lights", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)50.0f, (float)4.0f));
        UniverseStargateModel.createOuterChevronLights(outerChevronFrontLights);
        PartDefinition outerChevronBack = chevron.m_171599_("outer_chevron_back", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)50.0f, (float)-4.5f));
        UniverseStargateModel.createOuterChevron(outerChevronBack);
        PartDefinition outerChevronBackLights = chevron.m_171599_("outer_chevron_back_lights", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)50.0f, (float)-5.0f));
        UniverseStargateModel.createOuterChevronLights(outerChevronBackLights);
    }

    public static void createChevronLight(PartDefinition chevronLight) {
        chevronLight.m_171599_("chevron_top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, 0.0f, 0.0f, 6.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        chevronLight.m_171599_("chevron_upper", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171481_(-2.5f, -1.0f, 0.0f, 5.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        chevronLight.m_171599_("chevron_center", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171481_(-1.5f, -2.0f, 0.0f, 3.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        chevronLight.m_171599_("chevron_bottom", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-1.0f, -4.0f, 0.0f, 2.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        chevronLight.m_171599_("chevron_right", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40.0))));
        chevronLight.m_171599_("chevron_left", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(40.0))));
        chevronLight.m_171599_("chevron_lower_right", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-1.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-25.0))));
        chevronLight.m_171599_("chevron_lower_left", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-1.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(25.0))));
    }

    public static void createOuterChevron(PartDefinition outerChevron) {
        outerChevron.m_171599_("outer_chevron_center", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171481_(-5.0f, 0.0f, 0.0f, 10.0f, 6.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        outerChevron.m_171599_("outer_chevron_bottom_A", CubeListBuilder.m_171558_().m_171514_(20, 7).m_171481_(-2.0f, -1.0f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        outerChevron.m_171599_("outer_chevron_bottom_B", CubeListBuilder.m_171558_().m_171514_(14, 7).m_171481_(-1.0f, -7.0f, 0.0f, 2.0f, 6.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        outerChevron.m_171599_("outer_chevron_bottom_C", CubeListBuilder.m_171558_().m_171514_(20, 7).m_171481_(-2.0f, -7.0f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        outerChevron.m_171599_("outer_chevron_left_top_A", CubeListBuilder.m_171558_().m_171514_(14, 14).m_171481_(-10.0f, -1.0f, 0.0f, 10.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(10.0))));
        outerChevron.m_171599_("outer_chevron_left_top_B", CubeListBuilder.m_171558_().m_171514_(14, 16).m_171481_(-8.0f, -2.0f, 0.0f, 8.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(10.0))));
        outerChevron.m_171599_("outer_chevron_left_top_C", CubeListBuilder.m_171558_().m_171514_(14, 18).m_171481_(-7.0f, -3.0f, 0.0f, 7.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(10.0))));
        outerChevron.m_171599_("outer_chevron_left_A", CubeListBuilder.m_171558_().m_171514_(14, 20).m_171481_(-4.0f, -4.0f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(10.0))));
        outerChevron.m_171599_("outer_chevron_left_B", CubeListBuilder.m_171558_().m_171514_(14, 22).m_171481_(-3.0f, -5.0f, 0.0f, 3.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(10.0))));
        outerChevron.m_171599_("outer_chevron_left_C", CubeListBuilder.m_171558_().m_171514_(14, 24).m_171481_(-2.0f, -6.0f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(10.0))));
        outerChevron.m_171599_("outer_chevron_right_top_A", CubeListBuilder.m_171558_().m_171514_(14, 14).m_171481_(0.0f, -1.0f, 0.0f, 10.0f, 1.0f, 1.0f), PartPose.m_171423_((float)5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0))));
        outerChevron.m_171599_("outer_chevron_right_top_B", CubeListBuilder.m_171558_().m_171514_(14, 16).m_171481_(0.0f, -2.0f, 0.0f, 8.0f, 1.0f, 1.0f), PartPose.m_171423_((float)5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0))));
        outerChevron.m_171599_("outer_chevron_right_top_C", CubeListBuilder.m_171558_().m_171514_(14, 18).m_171481_(0.0f, -3.0f, 0.0f, 7.0f, 1.0f, 1.0f), PartPose.m_171423_((float)5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0))));
        outerChevron.m_171599_("outer_chevron_right_A", CubeListBuilder.m_171558_().m_171514_(14, 20).m_171481_(0.0f, -4.0f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171423_((float)5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0))));
        outerChevron.m_171599_("outer_chevron_right_B", CubeListBuilder.m_171558_().m_171514_(14, 22).m_171481_(0.0f, -5.0f, 0.0f, 3.0f, 1.0f, 1.0f), PartPose.m_171423_((float)5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0))));
        outerChevron.m_171599_("outer_chevron_right_C", CubeListBuilder.m_171558_().m_171514_(14, 24).m_171481_(0.0f, -6.0f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.m_171423_((float)5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0))));
    }

    public static void createOuterChevronLights(PartDefinition outerChevronLights) {
        outerChevronLights.m_171599_("outer_chevron_left_lower_light", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(0.0f, -5.5f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(10.0))));
        outerChevronLights.m_171599_("outer_chevron_left_center_light", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-2.0f, -4.0f, 0.0f, 3.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(10.0))));
        outerChevronLights.m_171599_("outer_chevron_left_upper_light", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-4.0f, -2.5f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(10.0))));
        outerChevronLights.m_171599_("outer_chevron_right_lower_light", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-2.0f, -5.5f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.m_171423_((float)5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0))));
        outerChevronLights.m_171599_("outer_chevron_right_center_light", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-1.0f, -4.0f, 0.0f, 3.0f, 1.0f, 1.0f), PartPose.m_171423_((float)5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0))));
        outerChevronLights.m_171599_("outer_chevron_right_upper_light", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(0.0f, -2.5f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.m_171423_((float)5.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0))));
    }
}

