/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.AbstractStargateModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.TollanStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;

public class TollanStargateModel
extends AbstractStargateModel {
    private static final String CHEVRON = ClientStargateConfig.tollan_stargate_back_lights_up.get() ? "tollan_chevron" : "tollan_chevron_front";
    private static final ResourceLocation RING_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/tollan/tollan_outer_ring.png");
    private static final ResourceLocation SYMBOL_RING_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/tollan/tollan_inner_ring.png");
    private static final ResourceLocation CHEVRON_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/tollan/" + CHEVRON + ".png");
    private static final ResourceLocation ENGAGED_CHEVRON_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/tollan/" + CHEVRON + "_lit.png");
    protected static final float DEFAULT_ANGLE = 10.0f;
    protected static final float DEFAULT_DISTANCE_FROM_CENTER = 48.0f;
    public static final float DEFAULT_Z = 3.0f;
    protected static final int BOXES_PER_RING = 36;
    protected static final float OUTER_CHEVRON_ANGLE = -2.5f;
    protected static final float OUTER_CHEVRON_BOTTOM_X = 4.5f;
    protected static final float OUTER_CHEVRON_CENTER_X = 3.0f;
    protected static final float OUTER_CHEVRON_CENTER_Y = 1.0f;
    protected static final float OUTER_CHEVRON_CENTER_Z = 4.75f;
    protected static final float OUTER_CHEVRON_SIDE_X = 1.0f;
    protected static final float OUTER_CHEVRON_SIDE_Y = 9.0f;
    protected static final float OUTER_CHEVRON_SIDE_Z = 4.75f;
    public static final float OUTER_CHEVRON_X_OFFSET = 1.25f;
    protected static final float OUTER_CHEVRON_Y_OFFSET = 0.375f;
    protected static final float OUTER_CHEVRON_Y_OFFSET_ANGLED = 9.0f;
    protected static final float OUTER_CHEVRON_Z_OFFSET = -2.375f;
    protected static final float CHEVRON_LIGHT_Z = 2.3125f;
    protected static final float CHEVRON_LIGHT_Y_OFFSET = 3.125f;
    protected static final float CHEVRON_LIGHT_Z_OFFSET = 0.0f;
    protected static final float CHEVRON_LIGHT_CENTER_X = 3.375f;
    protected static final float CHEVRON_LIGHT_CENTER_Y = 3.375f;
    protected static final float OUTER_RING_X = 8.4375f;
    protected static final float OUTER_RING_Y = 3.5f;
    protected static final float OUTER_RING_Z = 3.0f;
    protected static final float OUTER_RING_X_CENTER = 4.21875f;
    protected static final float OUTER_RING_Z_CENTER = 1.5f;
    protected static final float BACK_RING_X = 7.875f;
    protected static final float BACK_RING_Y = 3.0f;
    protected static final float BACK_RING_Z = 2.0f;
    protected static final float BACK_RING_Z_OFFSET = 1.5f;
    protected static final float BACK_RING_X_CENTER = 3.9375f;
    protected static final float INNER_RING_X = 7.25f;
    protected static final float INNER_RING_Y = 3.0f;
    protected static final float INNER_RING_Z = 3.0f;
    protected static final float SYMBOL_RING_X = 7.25f;
    protected static final float SYMBOL_RING_Y = 4.0f;
    protected static final float SYMBOL_RING_Z = 0.0f;
    protected static final float SYMBOL_RING_Y_OFFSET = 2.0f;
    protected static final float SYMBOL_RING_Z_OFFSET = 0.625f;
    private final ModelPart ring;
    private final ModelPart symbolRing;
    private final ModelPart chevrons;
    private static final int symbolCount = 39;

    public TollanStargateModel(ModelPart ring, ModelPart symbolRing, ModelPart chevrons) {
        super("tollan");
        this.ring = ring;
        this.symbolRing = symbolRing;
        this.chevrons = chevrons;
    }

    public void renderStargate(TollanStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderRing(stargate, stack, source, combinedLight, combinedOverlay, false);
        this.renderSymbolRing(stargate, stack, source, combinedLight, combinedOverlay);
        this.renderChevrons(stargate, stack, source, combinedLight, combinedOverlay);
    }

    protected void renderRing(TollanStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, boolean isBottomCovered) {
        int i;
        VertexConsumer ringTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)RING_TEXTURE));
        ModelPart outerRing = this.ring.m_171324_("outer_ring");
        ModelPart backRing = this.ring.m_171324_("back_ring");
        ModelPart innerRing = this.ring.m_171324_("inner_ring");
        int start = 0;
        if (isBottomCovered) {
            start = 1;
        }
        for (i = start; i < 36; ++i) {
            outerRing.m_171324_("outer_ring_" + i).m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        }
        for (i = 0; i < 36; ++i) {
            backRing.m_171324_("back_ring_" + i).m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        }
        for (i = start; i < 36; ++i) {
            innerRing.m_171324_("inner_ring_" + i).m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        }
    }

    protected void renderSymbolRing(TollanStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer symbolRingTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)SYMBOL_RING_TEXTURE));
        for (int i = 0; i < 39; ++i) {
            this.getSymbol(i).m_104301_(stack, symbolRingTexture, combinedLight, combinedOverlay);
        }
    }

    protected ModelPart getSymbol(int symbol) {
        return this.symbolRing.m_171324_("symbol_" + symbol);
    }

    protected void renderChevrons(TollanStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderTollanPrimaryChevron(stargate, stack, source, combinedLight, combinedOverlay);
        for (int i = 1; i <= 8; ++i) {
            this.renderChevron(stargate, stack, source, combinedLight, combinedOverlay, i);
        }
    }

    protected ModelPart getChevron(int chevron) {
        return this.chevrons.m_171324_("chevron_" + chevron);
    }

    protected void renderChevron(TollanStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, int chevronNumber) {
        VertexConsumer chevronTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)CHEVRON_TEXTURE));
        this.getChevron(chevronNumber).m_104301_(stack, chevronTexture, combinedLight, combinedOverlay);
        if (stargate.chevronsRendered() >= chevronNumber) {
            VertexConsumer engagedChevronTexture = source.m_6299_(SGJourneyRenderTypes.stargateChevron(ENGAGED_CHEVRON_TEXTURE));
            this.getChevron(chevronNumber).m_104301_(stack, engagedChevronTexture, 255, combinedOverlay);
        }
    }

    protected void renderTollanPrimaryChevron(TollanStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer chevron_texture = source.m_6299_(RenderType.m_110446_((ResourceLocation)CHEVRON_TEXTURE));
        this.getChevron(0).m_104301_(stack, chevron_texture, combinedLight, combinedOverlay);
        if (stargate.isConnected()) {
            VertexConsumer engaged_chevron_texture = source.m_6299_(SGJourneyRenderTypes.stargateChevron(ENGAGED_CHEVRON_TEXTURE));
            this.getChevron(0).m_104301_(stack, engaged_chevron_texture, 255, combinedOverlay);
        }
    }

    public static void createOuterRing(PartDefinition outerRing) {
        for (int i = 0; i < 9; ++i) {
            outerRing.m_171599_("outer_ring_" + 4 * i, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.21875f, -48.0f, -1.5f, 8.4375f, 3.5f, 3.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40.0f * (float)i))));
            outerRing.m_171599_("outer_ring_" + (4 * i + 1), CubeListBuilder.m_171558_().m_171514_(0, 42).m_171481_(-4.21875f, -48.0f, -1.5f, 8.4375f, 3.5f, 3.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 1)))));
            outerRing.m_171599_("outer_ring_" + (4 * i + 2), CubeListBuilder.m_171558_().m_171514_(0, 28).m_171481_(-4.21875f, -48.0f, -1.5f, 8.4375f, 3.5f, 3.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 2)))));
            outerRing.m_171599_("outer_ring_" + (4 * i + 3), CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-4.21875f, -48.0f, -1.5f, 8.4375f, 3.5f, 3.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 3)))));
        }
    }

    public static void createBackRing(PartDefinition backRing) {
        for (int i = 0; i < 9; ++i) {
            backRing.m_171599_("back_ring_" + 4 * i, CubeListBuilder.m_171558_().m_171514_(34, -2).m_171481_(-3.9375f, -44.5f, -1.5f, 7.875f, 3.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40.0f * (float)i))));
            backRing.m_171599_("back_ring_" + (4 * i + 1), CubeListBuilder.m_171558_().m_171514_(34, 6).m_171481_(-3.9375f, -44.5f, -1.5f, 7.875f, 3.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 1)))));
            backRing.m_171599_("back_ring_" + (4 * i + 2), CubeListBuilder.m_171558_().m_171514_(34, 14).m_171481_(-3.9375f, -44.5f, -1.5f, 7.875f, 3.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 2)))));
            backRing.m_171599_("back_ring_" + (4 * i + 3), CubeListBuilder.m_171558_().m_171514_(34, 6).m_171481_(-3.9375f, -44.5f, -1.5f, 7.875f, 3.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 3)))));
        }
    }

    public static void createInnerRing(PartDefinition innerRing) {
        for (int i = 0; i < 36; ++i) {
            innerRing.m_171599_("inner_ring_" + i, CubeListBuilder.m_171558_().m_171514_(34, 26).m_171481_(-3.625f, -41.5f, -1.5f, 7.25f, 3.0f, 3.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)i))));
        }
    }

    public static void createRing(PartDefinition ring) {
        PartDefinition outerRing = ring.m_171599_("outer_ring", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        TollanStargateModel.createOuterRing(outerRing);
        PartDefinition backRing = ring.m_171599_("back_ring", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        TollanStargateModel.createBackRing(backRing);
        PartDefinition innerRing = ring.m_171599_("inner_ring", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        TollanStargateModel.createInnerRing(innerRing);
    }

    public static LayerDefinition createRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition ring = meshdefinition.m_171576_();
        TollanStargateModel.createRing(ring);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static void createSymbolRing(PartDefinition symbolRing, int symbolCount) {
        double angle = 360.0 / (double)symbolCount;
        for (int i = 0; i < symbolCount; ++i) {
            symbolRing.m_171599_("symbol_" + i, CubeListBuilder.m_171558_().m_171514_(-4, 6).m_171481_(-3.625f, -46.0f, 0.625f, 7.25f, 4.0f, 0.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(180.0 - angle * (double)i))));
        }
    }

    public static LayerDefinition createSymbolRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition symbolRing = meshdefinition.m_171576_();
        TollanStargateModel.createSymbolRing(symbolRing, 39);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)8, (int)8);
    }

    public static LayerDefinition createChevronLayer() {
        int i;
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition chevrons = meshdefinition.m_171576_();
        for (i = 0; i <= 3; ++i) {
            TollanStargateModel.createChevron(chevrons.m_171599_("chevron_" + i, CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40 * i)))));
        }
        for (i = 4; i <= 6; ++i) {
            TollanStargateModel.createChevron(chevrons.m_171599_("chevron_" + i, CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40 * i - 80)))));
        }
        for (i = 7; i <= 8; ++i) {
            TollanStargateModel.createChevron(chevrons.m_171599_("chevron_" + i, CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40 * i + 120)))));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static void createChevron(PartDefinition chevron) {
        PartDefinition chevronLight = chevron.m_171599_("chevron_light", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        TollanStargateModel.createChevronLight(chevronLight);
        PartDefinition outerChevron = chevron.m_171599_("outer_chevron", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        TollanStargateModel.createOuterChevron(outerChevron);
        PartDefinition backChevron = chevron.m_171599_("back_chevron", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        TollanStargateModel.createBackChevron(backChevron);
    }

    public static void createChevronLight(PartDefinition chevronLight) {
        chevronLight.m_171599_("chevron_center", CubeListBuilder.m_171558_().m_171514_(22, 5).m_171481_(-1.6875f, -3.125f, 0.0f, 3.375f, 3.375f, 2.3125f), PartPose.m_171419_((float)0.0f, (float)48.0f, (float)0.0f));
    }

    public static void createOuterChevron(PartDefinition outerChevron) {
        outerChevron.m_171599_("chevron_f", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171481_(-2.25f, -0.625f, -2.375f, 4.5f, 1.0f, 4.75f), PartPose.m_171419_((float)0.0f, (float)39.0f, (float)0.0f));
        outerChevron.m_171599_("chevron_b", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171481_(-1.5f, 4.875f, -2.375f, 3.0f, 1.0f, 4.75f), PartPose.m_171419_((float)0.0f, (float)39.0f, (float)0.0f));
        outerChevron.m_171599_("chevron_right_f", CubeListBuilder.m_171558_().m_171514_(10, 29).m_171481_(-2.25f, 0.375f, -2.375f, 1.0f, 9.0f, 4.75f), PartPose.m_171423_((float)0.0f, (float)39.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(2.5))));
        outerChevron.m_171599_("chevron_left_f", CubeListBuilder.m_171558_().m_171514_(10, 29).m_171481_(1.25f, 0.375f, -2.375f, 1.0f, 9.0f, 4.75f), PartPose.m_171423_((float)0.0f, (float)39.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-2.5))));
    }

    public static void createBackChevron(PartDefinition backChevron) {
        backChevron.m_171599_("chevron_b_center", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-1.6875f, -3.125f, 0.0f, 3.375f, 3.375f, 2.3125f), PartPose.m_171419_((float)0.0f, (float)48.0f, (float)-2.3125f));
    }
}

