/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.AbstractStargateModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;

public class PegasusStargateModel
extends AbstractStargateModel {
    private static final ResourceLocation RING_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/pegasus/pegasus_outer_ring.png");
    private static final ResourceLocation SYMBOL_RING_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/pegasus/pegasus_inner_ring.png");
    private final ModelPart ring;
    private final ModelPart symbolRing;
    private final ModelPart dividers;
    private final ModelPart chevrons;
    private static final int symbolCount = 36;
    private int currentSymbol = 0;

    public PegasusStargateModel(ModelPart ring, ModelPart symbolRing, ModelPart dividers, ModelPart chevrons) {
        super("pegasus");
        this.ring = ring;
        this.symbolRing = symbolRing;
        this.dividers = dividers;
        this.chevrons = chevrons;
    }

    public void renderStargate(PegasusStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderRing(stargate, stack, source, combinedLight, combinedOverlay, false);
        this.renderSymbolRing(stargate, stack, source, combinedLight, combinedOverlay);
        this.renderChevrons(stargate, stack, source, combinedLight, combinedOverlay);
    }

    protected void renderRing(PegasusStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, boolean isBottomCovered) {
        int i;
        VertexConsumer ringTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)RING_TEXTURE));
        ModelPart outerRing = this.ring.m_171324_("outer_ring");
        ModelPart backRing = this.ring.m_171324_("back_ring");
        ModelPart innerRing = this.ring.m_171324_("inner_ring");
        int start = 0;
        if (isBottomCovered) {
            start = 1;
        }
        for (i = start; i < 36; ++i) {
            outerRing.m_171324_("outer_ring_" + i).m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        }
        for (i = 0; i < 36; ++i) {
            backRing.m_171324_("back_ring_" + i).m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        }
        for (i = start; i < 36; ++i) {
            innerRing.m_171324_("inner_ring_" + i).m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        }
    }

    protected void renderSymbolRing(PegasusStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer ringTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)RING_TEXTURE));
        this.dividers.m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        VertexConsumer symbolRingTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)SYMBOL_RING_TEXTURE));
        for (int i = 0; i < 36; ++i) {
            this.getSymbol(i).m_104301_(stack, symbolRingTexture, combinedLight, combinedOverlay);
        }
        this.renderSpinningSymbol(stargate, stack, source, combinedLight, combinedOverlay);
        if (stargate.isDialingOut() && stargate.isConnected() || stargate.addressBuffer.length > 0 && !stargate.isConnected()) {
            this.renderLockedSymbols(stargate, stack, source, combinedLight, combinedOverlay);
        } else {
            this.renderIdleSymbols(stargate, stack, source, combinedLight, combinedOverlay);
        }
    }

    protected void renderSpinningSymbol(PegasusStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        if (stargate.symbolBuffer < stargate.addressBuffer.length) {
            for (int i = 0; i < stargate.getAddress().length; ++i) {
                if (stargate.getChevronPosition(i + 1) != this.currentSymbol) continue;
                return;
            }
            this.getSymbol(this.currentSymbol).m_104306_(stack, source.m_6299_(RenderType.m_110482_((ResourceLocation)this.getSymbolTexture(stargate, stargate.addressBuffer[stargate.symbolBuffer]))), 255, combinedOverlay, 0.0f, 0.78431374f, 1.0f, 1.0f);
        }
    }

    protected void renderLockedSymbols(PegasusStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        for (int i = 0; i < stargate.getAddress().length; ++i) {
            this.getSymbol(stargate.getChevronPosition(i + 1)).m_104306_(stack, source.m_6299_(RenderType.m_110482_((ResourceLocation)this.getSymbolTexture(stargate, stargate.getAddress()[i]))), 255, combinedOverlay, 0.0f, 0.78431374f, 1.0f, 1.0f);
        }
    }

    protected void renderIdleSymbols(PegasusStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        float r = 0.0f;
        float g = 100.0f;
        float b = 200.0f;
        int symbolNumber = 36;
        if (stargate.isConnected()) {
            g = 200.0f;
            b = 255.0f;
            symbolNumber = stargate.currentSymbol < 36 ? stargate.currentSymbol : symbolNumber;
        }
        for (int i = 0; i < symbolNumber + 1; ++i) {
            int renderedSymbol = (stargate.isConnected() ? i + 1 : i) % 36;
            this.getSymbol(renderedSymbol).m_104306_(stack, source.m_6299_(RenderType.m_110482_((ResourceLocation)this.getSymbolTexture(stargate, renderedSymbol))), 255, combinedOverlay, r / 255.0f, g / 255.0f, b / 255.0f, 1.0f);
        }
    }

    protected ModelPart getSymbol(int symbol) {
        return this.symbolRing.m_171324_("symbol_" + symbol);
    }

    public void setCurrentSymbol(int currentSymbol) {
        this.currentSymbol = currentSymbol;
    }

    protected void renderChevrons(PegasusStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderPegasusPrimaryChevron(stargate, stack, source, combinedLight, combinedOverlay);
        for (int i = 1; i <= 8; ++i) {
            this.renderChevron(stargate, stack, source, combinedLight, combinedOverlay, i);
        }
    }

    protected ModelPart getChevron(int chevron) {
        return this.chevrons.m_171324_("chevron_" + chevron);
    }

    protected void renderChevron(PegasusStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, int chevronNumber) {
        int chevron = stargate.getEngagedChevrons()[chevronNumber];
        VertexConsumer chevronTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)(ClientStargateConfig.pegasus_stargate_back_lights_up.get() ? this.CHEVRON_TEXTURE : this.CHEVRON_FRONT_TEXTURE)));
        this.getChevron(chevron).m_104301_(stack, chevronTexture, combinedLight, combinedOverlay);
        if (stargate.chevronsRendered() >= chevronNumber) {
            VertexConsumer engagedChevronTexture = source.m_6299_(SGJourneyRenderTypes.stargateChevron(ClientStargateConfig.pegasus_stargate_back_lights_up.get() ? this.ENGAGED_CHEVRON_TEXTURE : this.ENGAGED_CHEVRON_FRONT_TEXTURE));
            this.getChevron(chevron).m_104301_(stack, engagedChevronTexture, 255, combinedOverlay);
        }
    }

    protected void renderPegasusPrimaryChevron(PegasusStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer chevronTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)this.getChevronTexture(ClientStargateConfig.pegasus_stargate_back_lights_up.get(), false)));
        this.getChevron(0).m_104301_(stack, chevronTexture, combinedLight, combinedOverlay);
        if (stargate.isConnected()) {
            VertexConsumer engagedChevronTexture = source.m_6299_(SGJourneyRenderTypes.stargateChevron(this.getChevronTexture(ClientStargateConfig.pegasus_stargate_back_lights_up.get(), true)));
            if (stargate.isDialingOut() || stargate.getKawooshTickCount() > 0) {
                this.getChevron(0).m_104301_(stack, engagedChevronTexture, 255, combinedOverlay);
            }
        }
    }

    public static LayerDefinition createRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition ring = meshdefinition.m_171576_();
        PegasusStargateModel.createRing(ring);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSymbolRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition symbolRing = meshdefinition.m_171576_();
        PegasusStargateModel.createSymbolRing(symbolRing, 36);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)8, (int)8);
    }

    public static LayerDefinition createDividerLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition dividers = meshdefinition.m_171576_();
        PegasusStargateModel.createDividers(dividers, 36);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createChevronLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition chevrons = meshdefinition.m_171576_();
        for (int i = 0; i < 9; ++i) {
            PegasusStargateModel.createChevron(chevrons.m_171599_("chevron_" + i, CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40 * i)))));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

