/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.AbstractStargateModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;

public class MilkyWayStargateModel
extends AbstractStargateModel {
    private static final ResourceLocation RING_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/milky_way/milky_way_outer_ring.png");
    private static final ResourceLocation SYMBOL_RING_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/milky_way/milky_way_inner_ring.png");
    private final ModelPart ring;
    private final ModelPart symbolRing;
    private final ModelPart dividers;
    private final ModelPart chevrons;
    private static final int symbolCount = 39;
    private static final double angle = 9.23076923076923;
    private float rotation = 0.0f;

    public MilkyWayStargateModel(ModelPart ring, ModelPart symbolRing, ModelPart dividers, ModelPart chevrons) {
        super("milky_way");
        this.ring = ring;
        this.symbolRing = symbolRing;
        this.dividers = dividers;
        this.chevrons = chevrons;
    }

    public void renderStargate(MilkyWayStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderRing(stargate, stack, source, combinedLight, combinedOverlay, false);
        this.renderSymbolRing(stargate, stack, source, combinedLight, combinedOverlay);
        this.renderChevrons(stargate, stack, source, combinedLight, combinedOverlay);
    }

    protected void renderRing(MilkyWayStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, boolean isBottomCovered) {
        int i;
        VertexConsumer ringTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)RING_TEXTURE));
        ModelPart outerRing = this.ring.m_171324_("outer_ring");
        ModelPart backRing = this.ring.m_171324_("back_ring");
        ModelPart innerRing = this.ring.m_171324_("inner_ring");
        int start = 0;
        if (isBottomCovered) {
            start = 1;
        }
        for (i = start; i < 36; ++i) {
            outerRing.m_171324_("outer_ring_" + i).m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        }
        for (i = 0; i < 36; ++i) {
            backRing.m_171324_("back_ring_" + i).m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        }
        for (i = start; i < 36; ++i) {
            innerRing.m_171324_("inner_ring_" + i).m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
        }
    }

    protected void renderSymbolRing(MilkyWayStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        int i;
        VertexConsumer symbolRingTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)SYMBOL_RING_TEXTURE));
        for (i = 0; i < 39; ++i) {
            this.getSymbol(i).m_171327_(0.0f, 0.0f, (float)Math.toRadians(180.0 - 9.23076923076923 * (double)i + (double)this.rotation));
        }
        for (i = 0; i < 39; ++i) {
            this.getSymbol(i).m_104301_(stack, symbolRingTexture, combinedLight, combinedOverlay);
        }
        for (i = 0; i < 39; ++i) {
            this.getSymbol(i).m_104306_(stack, source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getSymbolTexture(stargate, i))), combinedLight, combinedOverlay, 0.1882353f, 0.19215687f, 0.24705882f, 1.0f);
        }
        VertexConsumer ringTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)RING_TEXTURE));
        this.dividers.m_171327_(0.0f, 0.0f, (float)Math.toRadians(this.rotation));
        this.dividers.m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
    }

    protected ModelPart getSymbol(int symbol) {
        return this.symbolRing.m_171324_("symbol_" + symbol);
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    protected void renderChevrons(MilkyWayStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        if (ClientStargateConfig.use_movie_stargate_model.get()) {
            this.doMovieChevron(stargate);
            this.renderMoviePrimaryChevron(stargate, stack, source, combinedLight, combinedOverlay);
        } else {
            this.renderMilkyWayPrimaryChevron(stargate, stack, source, combinedLight, combinedOverlay);
        }
        for (int i = 1; i <= 8; ++i) {
            this.renderChevron(stargate, stack, source, combinedLight, combinedOverlay, i);
        }
    }

    protected ModelPart getChevron(int chevron) {
        return this.chevrons.m_171324_("chevron_" + chevron);
    }

    protected ModelPart getMovieChevron() {
        return this.chevrons.m_171324_("movie_chevron");
    }

    protected ModelPart getChevronLight(int chevron) {
        return this.getChevron(chevron).m_171324_("chevron_light");
    }

    protected ModelPart getOuterChevron(int chevron) {
        return this.getChevron(chevron).m_171324_("outer_chevron");
    }

    protected void renderChevron(MilkyWayStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, int chevronNumber) {
        int chevron = stargate.getEngagedChevrons()[chevronNumber];
        VertexConsumer chevronTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)(ClientStargateConfig.milky_way_stargate_back_lights_up.get() ? this.CHEVRON_TEXTURE : this.CHEVRON_FRONT_TEXTURE)));
        this.getChevron(chevron).m_104301_(stack, chevronTexture, combinedLight, combinedOverlay);
        if (stargate.chevronsRendered() >= chevronNumber) {
            VertexConsumer engagedChevronTexture = source.m_6299_(SGJourneyRenderTypes.stargateChevron(ClientStargateConfig.milky_way_stargate_back_lights_up.get() ? this.ENGAGED_CHEVRON_TEXTURE : this.ENGAGED_CHEVRON_FRONT_TEXTURE));
            this.getChevron(chevron).m_104301_(stack, engagedChevronTexture, 255, combinedOverlay);
        }
    }

    protected void controlChevrons(MilkyWayStargateEntity stargate, int chevronsRaised, boolean onlyOuter) {
        int chevron;
        int i;
        for (i = 1; i <= chevronsRaised; ++i) {
            chevron = stargate.getEngagedChevrons()[i];
            this.getChevronLight((int)chevron).f_104201_ = !onlyOuter ? 2.0f : 0.0f;
            this.getOuterChevron((int)chevron).f_104201_ = -2.0f;
        }
        for (i = chevronsRaised + 1; i < 9; ++i) {
            chevron = stargate.getEngagedChevrons()[i];
            this.getChevronLight((int)chevron).f_104201_ = 0.0f;
            this.getOuterChevron((int)chevron).f_104201_ = 0.0f;
        }
    }

    protected void controlChevron(MilkyWayStargateEntity stargate, int chevronRaised) {
        for (int i = 0; i < 9; ++i) {
            int chevron = stargate.getEngagedChevrons()[i];
            this.getChevronLight((int)chevron).f_104201_ = 0.0f;
            this.getOuterChevron((int)chevron).f_104201_ = 0.0f;
        }
        int chevron = stargate.getEngagedChevrons()[chevronRaised];
        this.getChevronLight((int)chevron).f_104201_ = 2.0f;
        this.getOuterChevron((int)chevron).f_104201_ = -2.0f;
    }

    protected void doMovieChevron(MilkyWayStargateEntity stargate) {
        int chevronsRendered = stargate.chevronsRendered();
        if (stargate.isConnected()) {
            this.controlChevrons(stargate, chevronsRendered, true);
        } else if (stargate.isChevronRaised) {
            if (stargate.getCurrentSymbol() == 0) {
                this.controlChevrons(stargate, chevronsRendered, false);
            } else {
                int chevronNumber = chevronsRendered + 1;
                if (chevronNumber < 9) {
                    this.controlChevron(stargate, chevronNumber);
                } else {
                    this.controlChevrons(stargate, chevronsRendered, false);
                }
            }
        } else {
            this.controlChevrons(stargate, 0, false);
        }
    }

    protected void renderMoviePrimaryChevron(MilkyWayStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer chevronTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)this.getChevronTexture(ClientStargateConfig.milky_way_stargate_back_lights_up.get(), false)));
        this.getMovieChevron().m_104301_(stack, chevronTexture, combinedLight, combinedOverlay);
        if (!stargate.isChevronRaised && stargate.isConnected()) {
            VertexConsumer engagedChevronTexture = source.m_6299_(SGJourneyRenderTypes.stargateChevron(this.getChevronTexture(ClientStargateConfig.milky_way_stargate_back_lights_up.get(), true)));
            if (stargate.isDialingOut() || stargate.getKawooshTickCount() > 0) {
                this.getMovieChevron().m_104301_(stack, engagedChevronTexture, 255, combinedOverlay);
            }
        }
    }

    protected void renderMilkyWayPrimaryChevron(MilkyWayStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        if (stargate.isChevronRaised) {
            this.getChevronLight((int)0).f_104201_ = 2.0f;
            this.getOuterChevron((int)0).f_104201_ = -2.0f;
        } else {
            this.getChevronLight((int)0).f_104201_ = 0.0f;
            this.getOuterChevron((int)0).f_104201_ = 0.0f;
        }
        VertexConsumer chevron_texture = source.m_6299_(RenderType.m_110446_((ResourceLocation)this.getChevronTexture(ClientStargateConfig.milky_way_stargate_back_lights_up.get(), false)));
        this.getChevron(0).m_104301_(stack, chevron_texture, combinedLight, combinedOverlay);
        if (stargate.isConnected() && stargate.isDialingOut() || stargate.isChevronRaised || stargate.getKawooshTickCount() > 0) {
            VertexConsumer engaged_chevron_texture = source.m_6299_(SGJourneyRenderTypes.stargateChevron(this.getChevronTexture(ClientStargateConfig.milky_way_stargate_back_lights_up.get(), true)));
            this.getChevron(0).m_104301_(stack, engaged_chevron_texture, 255, combinedOverlay);
        }
    }

    public static LayerDefinition createRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition ring = meshdefinition.m_171576_();
        MilkyWayStargateModel.createRing(ring);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSymbolRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition symbolRing = meshdefinition.m_171576_();
        MilkyWayStargateModel.createSymbolRing(symbolRing, 39);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)8, (int)8);
    }

    public static LayerDefinition createDividerLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition dividers = meshdefinition.m_171576_();
        MilkyWayStargateModel.createDividers(dividers, 39);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createChevronLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition chevrons = meshdefinition.m_171576_();
        MilkyWayStargateModel.createMovieChevron(chevrons.m_171599_("movie_chevron", CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)0.0f)));
        for (int i = 0; i < 9; ++i) {
            MilkyWayStargateModel.createChevron(chevrons.m_171599_("chevron_" + i, CubeListBuilder.m_171558_(), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40 * i)))));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected static void createMovieChevron(PartDefinition chevron) {
        PartDefinition chevronLight = chevron.m_171599_("chevron_light", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        MilkyWayStargateModel.createChevronLight(chevronLight);
        PartDefinition outerChevron = chevron.m_171599_("outer_chevron", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        MilkyWayStargateModel.createOuterMovieChevron(outerChevron);
        PartDefinition backChevron = chevron.m_171599_("back_chevron", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        MilkyWayStargateModel.createBackChevron(backChevron);
    }

    protected static void createOuterMovieChevron(PartDefinition outerChevron) {
        outerChevron.m_171599_("chevron_right_f", CubeListBuilder.m_171558_().m_171514_(16, 29).m_171481_(-1.0f, 2.0f, 0.0f, 3.0f, 8.0f, 1.0f), PartPose.m_171423_((float)2.0f, (float)46.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-22.5))));
        outerChevron.m_171599_("chevron_right_f2", CubeListBuilder.m_171558_().m_171514_(25, 29).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f), PartPose.m_171423_((float)2.0f, (float)46.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-22.5))));
        outerChevron.m_171599_("chevron_right_f3", CubeListBuilder.m_171558_().m_171514_(31, 29).m_171481_(1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171423_((float)2.0f, (float)46.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-22.5))));
        outerChevron.m_171599_("chevron_left_f", CubeListBuilder.m_171558_().m_171514_(16, 29).m_171481_(-2.0f, 2.0f, 0.0f, 3.0f, 8.0f, 1.0f), PartPose.m_171423_((float)-2.0f, (float)46.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(22.5))));
        outerChevron.m_171599_("chevron_left_f2", CubeListBuilder.m_171558_().m_171514_(25, 29).m_171481_(-2.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f), PartPose.m_171423_((float)-2.0f, (float)46.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(22.5))));
        outerChevron.m_171599_("chevron_left_f3", CubeListBuilder.m_171558_().m_171514_(31, 29).m_171481_(-2.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-2.0f, (float)46.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(22.5))));
    }
}

