/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class Stargate {
    private static Component createInfo(String feedback) {
        return Component.m_237115_((String)("message.sgjourney.stargate.info." + feedback));
    }

    private static Component createError(String feedback, boolean majorError) {
        MutableComponent component = Component.m_237115_((String)("message.sgjourney.stargate.error." + feedback));
        return majorError ? component.m_130940_(ChatFormatting.DARK_RED) : component.m_130940_(ChatFormatting.RED);
    }

    public static class RGBA {
        private float red;
        private float green;
        private float blue;
        private float alpha;
        public static final RGBA DEFAULT_RGBA = new RGBA(255, 255, 255, 255);

        public RGBA(int red, int green, int blue, int alpha) {
            this.red = (float)red / 255.0f;
            this.green = (float)green / 255.0f;
            this.blue = (float)blue / 255.0f;
            this.alpha = (float)alpha / 255.0f;
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }

        public float getAlpha() {
            return this.alpha;
        }
    }

    public static enum Feedback {
        NONE(0, FeedbackType.INFO, "none"),
        UNKNOWN_ERROR(-1, FeedbackType.ERROR, "unknown"),
        SYMBOL_ENCODED(1, FeedbackType.INFO, "symbol_encoded"),
        SYMBOL_IN_ADDRESS(-2, FeedbackType.ERROR, "symbol_in_address"),
        SYMBOL_OUT_OF_BOUNDS(-3, FeedbackType.ERROR, "symbol_out_of_bounds"),
        CONNECTION_ESTABLISHED_SYSTEM_WIDE(2, FeedbackType.INFO, "connection_established.system_wide"),
        CONNECTION_ESTABLISHED_INTERSTELLAR(3, FeedbackType.INFO, "connection_established.interstellar"),
        CONNECTION_ESTABLISHED_INTERGALACTIC(4, FeedbackType.INFO, "connection_established.intergalactic"),
        INCOMPLETE_ADDRESS(-4, FeedbackType.MAJOR_ERROR, "incomplete_address"),
        INVALID_ADDRESS(-5, FeedbackType.MAJOR_ERROR, "invalid_address"),
        NOT_ENOUGH_POWER(-6, FeedbackType.MAJOR_ERROR, "not_enough_power"),
        SELF_OBSTRUCTED(-7, FeedbackType.MAJOR_ERROR, "self_obstructed"),
        TARGET_OBSTRUCTED(-8, FeedbackType.ERROR, "target_obstructed"),
        SELF_DIAL(-9, FeedbackType.MAJOR_ERROR, "self_dial"),
        SAME_SYSTEM_DIAL(-10, FeedbackType.MAJOR_ERROR, "same_system_dial"),
        ALREADY_CONNECTED(-11, FeedbackType.MAJOR_ERROR, "already_connected"),
        NO_GALAXY(-12, FeedbackType.MAJOR_ERROR, "no_galaxy"),
        NO_DIMENSIONS(-13, FeedbackType.MAJOR_ERROR, "no_dimensions"),
        NO_STARGATES(-14, FeedbackType.MAJOR_ERROR, "no_stargates"),
        TARGET_RESTRICTED(-15, FeedbackType.MAJOR_ERROR, "target_restricted"),
        CONNECTION_ENDED_BY_DISCONNECT(7, FeedbackType.INFO, "connection_ended.disconnect"),
        CONNECTION_ENDED_BY_POINT_OF_ORIGIN(8, FeedbackType.INFO, "connection_ended.point_of_origin"),
        CONNECTION_ENDED_BY_NETWORK(9, FeedbackType.INFO, "connection_ended.stargate_network"),
        CONNECTION_ENDED_BY_AUTOCLOSE(10, FeedbackType.INFO, "connection_ended.autoclose"),
        EXCEEDED_CONNECTION_TIME(-15, FeedbackType.ERROR, "exceeded_connection_time"),
        RAN_OUT_OF_POWER(-17, FeedbackType.ERROR, "ran_out_of_power"),
        CONNECTION_REROUTED(-18, FeedbackType.ERROR, "connection_rerouted"),
        WRONG_DISCONNECT_SIDE(-18, FeedbackType.ERROR, "wrong_disconnect_side"),
        CONNECTION_FORMING(-20, FeedbackType.ERROR, "connection_forming"),
        STARGATE_DESTROYED(-21, FeedbackType.ERROR, "stargate_destroyed"),
        COULD_NOT_REACH_TARGET_STARGATE(-22, FeedbackType.MAJOR_ERROR, "could_not_reach_target_stargate"),
        INTERRUPTED_BY_INCOMING_CONNECTION(-23, FeedbackType.ERROR, "interrupted_by_incoming_connection"),
        CHEVRON_RAISED(11, FeedbackType.INFO, "chevron_opened"),
        ROTATING(12, FeedbackType.INFO, "rotating"),
        ROTATION_BLOCKED(-24, FeedbackType.INFO, "rotation_blocked"),
        NOT_ROTATING(-25, FeedbackType.INFO, "not_rotating"),
        ROTATION_STOPPED(13, FeedbackType.INFO, "rotation_stopped"),
        CHEVRON_ALREADY_RAISED(-26, FeedbackType.ERROR, "chevron_already_opened"),
        CHEVRON_ALREADY_LOWERED(-27, FeedbackType.ERROR, "chevron_already_closed"),
        CHEVRON_NOT_RAISED(-28, FeedbackType.ERROR, "chevron_not_raised"),
        CANNOT_ENCODE_POINT_OF_ORIGIN(-29, FeedbackType.ERROR, "cannot_encode_point_of_origin");

        private int code;
        private final FeedbackType type;
        private final String message;
        private final Component feedbackMessage;

        private Feedback(int code, FeedbackType type, String message) {
            this.code = code;
            this.type = type;
            this.message = message;
            this.feedbackMessage = type.isError() ? Stargate.createError(message, type == FeedbackType.MAJOR_ERROR) : Stargate.createInfo(message);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Component getFeedbackMessage() {
            return this.feedbackMessage;
        }

        public boolean playFailSound() {
            return this.type.shouldPlaySound();
        }

        public boolean isError() {
            return this.type.isError();
        }
    }

    public static enum FeedbackType {
        INFO,
        ERROR,
        MAJOR_ERROR;


        public boolean isError() {
            return this == ERROR || this == MAJOR_ERROR;
        }

        public boolean shouldPlaySound() {
            return this == MAJOR_ERROR;
        }
    }

    public static enum FilterType {
        NONE,
        WHITELIST,
        BLACKLIST;

    }

    public static enum WormholeTravel {
        ENABLED,
        CREATIVE_ONLY,
        DISABLED;

    }

    public static enum ChevronLockSpeed {
        SLOW(3),
        MEDIUM(2),
        FAST(1);

        private int multiplier;

        private ChevronLockSpeed(int multiplier) {
            this.multiplier = multiplier;
        }

        public int getMultiplier() {
            return this.multiplier;
        }

        public int getChevronWaitTicks() {
            return this.multiplier * 4;
        }

        public int getKawooshStartTicks() {
            return this.getChevronWaitTicks() * 9;
        }
    }

    public static enum Gen {
        NONE(0),
        GEN_1(1),
        GEN_2(2),
        GEN_3(3);

        private final int gen;

        private Gen(int gen) {
            this.gen = gen;
        }

        public int getGen() {
            return this.gen;
        }
    }
}

