/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.stargate.GalaxyType;
import net.povstalec.sgjourney.common.stargate.SolarSystem;
import net.povstalec.sgjourney.common.stargate.Symbols;

public class Galaxy {
    public static final ResourceKey<Registry<Galaxy>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("sgjourney", "galaxy"));
    private static final Codec<Pair<List<Integer>, Boolean>> ADDRESS = Codec.pair((Codec)Codec.INT.listOf().fieldOf("address").codec(), (Codec)Codec.BOOL.fieldOf("randomizable").codec());
    private static final Codec<Pair<ResourceKey<SolarSystem>, Pair<List<Integer>, Boolean>>> SYSTEM_WITH_ADDRESS = Codec.pair((Codec)SolarSystem.RESOURCE_KEY_CODEC.fieldOf("solar_system").codec(), (Codec)ADDRESS.fieldOf("address").codec());
    public static final Codec<Galaxy> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Galaxy::getName), (App)GalaxyType.RESOURCE_KEY_CODEC.fieldOf("type").forGetter(Galaxy::getType), (App)Symbols.RESOURCE_KEY_CODEC.fieldOf("default_symbols").forGetter(Galaxy::getDefaultSymbols), (App)SYSTEM_WITH_ADDRESS.listOf().fieldOf("solar_systems").forGetter(Galaxy::getSystems)).apply((Applicative)instance, Galaxy::new));
    private final String name;
    private final ResourceKey<GalaxyType> type;
    private final ResourceKey<Symbols> defaultSymbols;
    private final List<Pair<ResourceKey<SolarSystem>, Pair<List<Integer>, Boolean>>> systems;

    public Galaxy(String name, ResourceKey<GalaxyType> type, ResourceKey<Symbols> defaultSymbols, List<Pair<ResourceKey<SolarSystem>, Pair<List<Integer>, Boolean>>> systems) {
        this.name = name;
        this.type = type;
        this.defaultSymbols = defaultSymbols;
        this.systems = systems;
    }

    public String getName() {
        return this.name;
    }

    public ResourceKey<GalaxyType> getType() {
        return this.type;
    }

    public ResourceKey<Symbols> getDefaultSymbols() {
        return this.defaultSymbols;
    }

    public List<Pair<ResourceKey<SolarSystem>, Pair<List<Integer>, Boolean>>> getSystems() {
        return this.systems;
    }

    public static Galaxy getGalaxy(Level level, String part1, String part2) {
        return Galaxy.getGalaxy(level, new ResourceLocation(part1, part2));
    }

    public static Galaxy getGalaxy(Level level, ResourceLocation galaxy) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (Galaxy)registry.m_7745_(galaxy);
    }
}

