/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;

public class Dialing {
    private static final String EMPTY = "sgjourney:empty";
    public static final int[] DIALED_7_CHEVRON_CONFIGURATION = new int[]{0, 1, 2, 3, 6, 7, 8, 4, 5};
    public static final int[] DIALED_8_CHEVRON_CONFIGURATION = new int[]{0, 1, 2, 3, 4, 6, 7, 8, 5};
    public static final int[] DIALED_9_CHEVRON_CONFIGURATION = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final int[] DEFAULT_CHEVRON_CONFIGURATION = DIALED_7_CHEVRON_CONFIGURATION;

    public static Stargate.Feedback dialStargate(Level level, AbstractStargateEntity dialingStargate, Address address, boolean doKawoosh) {
        switch (address.getLength()) {
            case 6: {
                return Dialing.get7ChevronStargate(level, dialingStargate, address, doKawoosh);
            }
            case 7: {
                return Dialing.get8ChevronStargate(level, dialingStargate, address, doKawoosh);
            }
            case 8: {
                return Dialing.get9ChevronStargate(level, dialingStargate, address, doKawoosh);
            }
        }
        return dialingStargate.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
    }

    private static Stargate.Feedback get7ChevronStargate(Level level, AbstractStargateEntity dialingStargate, Address address, boolean doKawoosh) {
        String addressString = address.toString();
        ListTag galaxies = Universe.get(level).getGalaxiesFromDimension(level.m_46472_().m_135782_().toString());
        if (galaxies.isEmpty()) {
            return dialingStargate.resetStargate(Stargate.Feedback.NO_GALAXY);
        }
        String solarSystem = EMPTY;
        for (int i = 0; i < galaxies.size(); ++i) {
            String galaxy = (String)galaxies.m_128728_(i).m_128431_().iterator().next();
            solarSystem = Universe.get(level).getSolarSystemInGalaxy(galaxy, addressString);
            if (!solarSystem.equals(EMPTY)) break;
        }
        if (solarSystem.equals(EMPTY)) {
            return dialingStargate.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
        }
        return Dialing.getStargate(level, dialingStargate, solarSystem, doKawoosh);
    }

    private static Stargate.Feedback get8ChevronStargate(Level level, AbstractStargateEntity dialingStargate, Address address, boolean doKawoosh) {
        String addressString = address.toString();
        String solarSystem = Universe.get(level).getSolarSystemFromExtragalacticAddress(addressString);
        if (solarSystem.equals(EMPTY)) {
            return dialingStargate.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
        }
        return Dialing.getStargate(level, dialingStargate, solarSystem, doKawoosh);
    }

    private static Stargate.Feedback getStargate(Level level, AbstractStargateEntity dialingStargate, String systemID, boolean doKawoosh) {
        String currentSystem = Universe.get(level).getSolarSystemFromDimension(level.m_46472_().m_135782_().toString());
        if (systemID.equals(currentSystem)) {
            return dialingStargate.resetStargate(Stargate.Feedback.SAME_SYSTEM_DIAL);
        }
        MinecraftServer server = level.m_7654_();
        CompoundTag solarSystem = StargateNetwork.get(server).getSolarSystem(systemID);
        if (solarSystem.m_128456_()) {
            ListTag dimensionList = Universe.get(server).getDimensionsFromSolarSystem(systemID);
            int dimensions = 0;
            for (int i = 0; i < dimensionList.size(); ++i) {
                ResourceKey<Level> levelKey = Conversion.stringToDimension(dimensionList.m_128778_(i));
                if (!level.m_7654_().m_129784_().contains(levelKey)) continue;
                ServerLevel targetLevel = server.m_129880_(levelKey);
                Dialing.findStargates((Level)targetLevel);
                ++dimensions;
            }
            if (dimensions == 0) {
                return dialingStargate.resetStargate(Stargate.Feedback.NO_DIMENSIONS);
            }
            solarSystem = StargateNetwork.get(server).getSolarSystem(systemID);
            if (solarSystem.m_128456_()) {
                return dialingStargate.resetStargate(Stargate.Feedback.NO_STARGATES);
            }
            solarSystem = StargateNetwork.get(server).getSolarSystem(systemID);
        }
        return Dialing.getPreferredStargate(server, dialingStargate, solarSystem, doKawoosh);
    }

    private static void findStargates(Level level) {
        StargateJourney.LOGGER.info("Attempting to locate the Stargate Structure in " + level.m_46472_().m_135782_().toString());
        int xOffset = (Integer)CommonGenerationConfig.stargate_generation_center_x_chunk_offset.get();
        int zOffset = (Integer)CommonGenerationConfig.stargate_generation_center_z_chunk_offset.get();
        BlockPos blockpos = ((ServerLevel)level).m_215011_(TagInit.Structures.HAS_STARGATE, new BlockPos(xOffset * 16, 0, zOffset * 16), 150, false);
        if (blockpos == null) {
            StargateJourney.LOGGER.info("Stargate Structure not found");
            return;
        }
        ArrayList stargates = new ArrayList();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                ChunkAccess chunk = level.m_46865_(blockpos.m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity patt6071$temp = level.m_7702_(pos);
                    if (patt6071$temp instanceof AbstractStargateEntity) {
                        AbstractStargateEntity stargate = (AbstractStargateEntity)patt6071$temp;
                        stargates.add(stargate);
                    }
                });
            }
        }
        if (stargates.isEmpty()) {
            StargateJourney.LOGGER.info("No Stargates found in Stargate Structure");
            return;
        }
        stargates.stream().forEach(stargate -> stargate.onLoad());
    }

    public static Stargate.Feedback getStargateFromID(MinecraftServer server, AbstractStargateEntity dialingStargate, String id, boolean doKawoosh) {
        CompoundTag stargateList = StargateNetwork.get(server).getStargates();
        if (!stargateList.m_128441_(id)) {
            return dialingStargate.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
        }
        BlockPos pos = Conversion.intArrayToBlockPos(stargateList.m_128469_(id).m_128465_("Coordinates"));
        BlockEntity blockEntity = server.m_129880_(Conversion.stringToDimension(stargateList.m_128469_(id).m_128461_("Dimension"))).m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity targetStargate = (AbstractStargateEntity)blockEntity;
            if (targetStargate.isObstructed()) {
                return dialingStargate.resetStargate(Stargate.Feedback.TARGET_OBSTRUCTED);
            }
            return Dialing.dialStargate(dialingStargate, targetStargate, doKawoosh);
        }
        return dialingStargate.resetStargate(Stargate.Feedback.COULD_NOT_REACH_TARGET_STARGATE);
    }

    public static Stargate.Feedback get9ChevronStargate(Level level, AbstractStargateEntity dialingStargate, Address address, boolean doKawoosh) {
        String id = address.toString();
        return Dialing.getStargateFromID(level.m_7654_(), dialingStargate, id, doKawoosh);
    }

    private static Stargate.Feedback getPreferredStargate(MinecraftServer server, AbstractStargateEntity dialingStargate, CompoundTag solarSystem, boolean doKawoosh) {
        while (!solarSystem.m_128456_()) {
            String preferredStargate = StargateNetwork.get(server).getPreferredStargate(solarSystem);
            if (!preferredStargate.equals(EMPTY)) {
                CompoundTag stargateInfo = solarSystem.m_128469_(preferredStargate);
                int[] coordinates = stargateInfo.m_128465_("Coordinates");
                BlockPos pos = Conversion.intArrayToBlockPos(coordinates);
                ResourceKey<Level> dimension = Conversion.stringToDimension(stargateInfo.m_128461_("Dimension"));
                ServerLevel targetLevel = server.m_129880_(dimension);
                BlockEntity blockEntity = targetLevel.m_7702_(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity targetStargate = (AbstractStargateEntity)blockEntity;
                    if (!targetStargate.isObstructed() && !targetStargate.isRestricted(dialingStargate)) {
                        return Dialing.dialStargate(dialingStargate, targetStargate, doKawoosh);
                    }
                    if (targetStargate.isObstructed() && solarSystem.m_128440_() == 1) {
                        return dialingStargate.resetStargate(Stargate.Feedback.TARGET_OBSTRUCTED);
                    }
                    if (targetStargate.isRestricted(dialingStargate) && solarSystem.m_128440_() == 1) {
                        return dialingStargate.resetStargate(Stargate.Feedback.TARGET_RESTRICTED);
                    }
                }
            }
            solarSystem.m_128473_(preferredStargate);
        }
        return dialingStargate.resetStargate(Stargate.Feedback.UNKNOWN_ERROR);
    }

    private static Stargate.Feedback dialStargate(AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate, boolean doKawoosh) {
        Level level = dialingStargate.m_58904_();
        return StargateNetwork.get(level).createConnection(level.m_7654_(), dialingStargate, dialedStargate, doKawoosh);
    }
}

