/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.blockstates.Orientation;

public class MatrixHelper {
    public static Vec3 rotateVector(Vec3 initialVector, Direction initialDirection, Orientation initialOrientation, Direction destinationDirection, Orientation destinationOrientation) {
        int yRotation;
        Vec3 vector = initialVector;
        int initialHorizontal = initialDirection.m_122416_();
        int destinationHorizontal = destinationDirection.m_122416_();
        Direction.Axis initialRotationAxis = initialDirection.m_122427_().m_122434_();
        Direction.Axis destinationRotationAxis = destinationDirection.m_122427_().m_122434_();
        int initialVertical = initialOrientation.get2DDataValue();
        int destinationVertical = destinationOrientation.get2DDataValue();
        int regular = Orientation.REGULAR.get2DDataValue();
        if (initialVertical > regular) {
            regular += 4;
        }
        int xzRotation1 = regular - initialVertical;
        boolean negativeAxis1 = initialDirection.m_122421_() == Direction.AxisDirection.POSITIVE;
        vector = initialRotationAxis == Direction.Axis.X ? MatrixHelper.xRotateClockwise(vector, xzRotation1, negativeAxis1) : MatrixHelper.zRotateClockwise(vector, xzRotation1, negativeAxis1);
        if (destinationHorizontal - initialHorizontal - 2 < 0) {
            destinationHorizontal += 4;
        }
        if ((yRotation = destinationHorizontal - initialHorizontal - 2) < 0) {
            yRotation += 4;
        }
        vector = MatrixHelper.yRotateClockwise(vector, yRotation);
        if (destinationVertical < Orientation.REGULAR.get2DDataValue()) {
            destinationVertical += 4;
        }
        int xzRotation2 = destinationVertical - Orientation.REGULAR.get2DDataValue();
        boolean negativeAxis2 = destinationDirection.m_122421_() == Direction.AxisDirection.POSITIVE;
        vector = destinationRotationAxis == Direction.Axis.X ? MatrixHelper.xRotateClockwise(vector, xzRotation2, negativeAxis2) : MatrixHelper.zRotateClockwise(vector, xzRotation2, negativeAxis2);
        return vector;
    }

    public static Vec3 yRotateClockwise(Vec3 vector, int numberOfRotations) {
        double x = vector.m_7096_();
        double z = vector.m_7094_();
        for (int i = 0; i < numberOfRotations; ++i) {
            double helper = x;
            x = -z;
            z = helper;
        }
        return new Vec3(x, vector.f_82480_, z);
    }

    public static Vec3 xRotateClockwise(Vec3 vector, int numberOfRotations, boolean clockwise) {
        double y = vector.m_7098_();
        double z = vector.m_7094_();
        int multiplier = clockwise ? 1 : -1;
        for (int i = 0; i < numberOfRotations; ++i) {
            double helper = y;
            y = -z * (double)multiplier;
            z = helper * (double)multiplier;
        }
        return new Vec3(vector.f_82479_, y, z);
    }

    public static Vec3 zRotateClockwise(Vec3 vector, int numberOfRotations, boolean clockwise) {
        double x = vector.m_7096_();
        double y = vector.m_7098_();
        int multiplier = clockwise ? 1 : -1;
        for (int i = 0; i < numberOfRotations; ++i) {
            double helper = y;
            y = -x * (double)multiplier;
            x = helper * (double)multiplier;
        }
        return new Vec3(x, y, vector.f_82481_);
    }
}

