/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.povstalec.sgjourney.common.capabilities.ItemInventoryProvider;
import net.povstalec.sgjourney.common.entities.PlasmaProjectile;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.VialItem;

public class StaffWeaponItem
extends Item {
    public static final String IS_OPEN = "IsOpen";
    private static final float OPEN_ATTACK_DAMAGE = 3.0f;
    private static final float CLOSED_ATTACK_DAMAGE = 6.0f;
    private static final float OPEN_ATTACK_SPEED = -2.4f;
    private static final float CLOSED_ATTACK_SPEED = -2.8f;
    private static final float LIQUID_NAQUADAH_EXPLOSION_POWER = 0.0f;
    private static final float HEAVY_LIQUID_NAQUADAH_EXPLOSION_POWER = 1.0f;
    private static final int LIQUID_NAQUADAH_DEPLETION = 1;
    private static final int HEAVY_LIQUID_NAQUADAH_DEPLETION = 5;
    private final Multimap<Attribute, AttributeModifier> openModifiers;
    private final Multimap<Attribute, AttributeModifier> closedModifiers;

    public StaffWeaponItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder openBuilder = ImmutableMultimap.builder();
        openBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 3.0, AttributeModifier.Operation.ADDITION));
        openBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.openModifiers = openBuilder.build();
        ImmutableMultimap.Builder closedBuilder = ImmutableMultimap.builder();
        closedBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 6.0, AttributeModifier.Operation.ADDITION));
        closedBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.8f, AttributeModifier.Operation.ADDITION));
        this.closedModifiers = closedBuilder.build();
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)this.getNaquadahAmount(stack) / (float)VialItem.getMaxCapacity());
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)this.getNaquadahAmount(stack) / (float)VialItem.getMaxCapacity());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemInventoryProvider(stack){

            @Override
            public int getNumberOfSlots() {
                return 1;
            }

            @Override
            public boolean isValid(int slot, ItemStack stack) {
                return stack.m_150930_((Item)ItemInit.VIAL.get());
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_()) {
            ItemStack mainHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
            if (offHandStack.m_150930_((Item)ItemInit.MATOK.get()) && !level.m_5776_()) {
                offHandStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                    ItemStack returnStack;
                    if (mainHandStack.m_41619_()) {
                        returnStack = itemHandler.extractItem(0, 1, false);
                    } else if (mainHandStack.m_150930_((Item)ItemInit.VIAL.get())) {
                        returnStack = itemHandler.extractItem(0, 1, false);
                        itemHandler.insertItem(0, mainHandStack, false);
                    } else {
                        returnStack = itemHandler.insertItem(0, mainHandStack, false);
                    }
                    player.m_21008_(InteractionHand.MAIN_HAND, returnStack);
                });
                return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
            } else {
                if (!mainHandStack.m_150930_((Item)ItemInit.MATOK.get())) return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
                StaffWeaponItem.setOpen(level, player, mainHandStack, !StaffWeaponItem.isOpen(mainHandStack));
                player.m_36335_().m_41524_((Item)this, 15);
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        } else {
            boolean canShoot;
            if (player.m_6144_()) return InteractionResultHolder.m_19100_((Object)itemstack);
            ItemStack stack = player.m_21120_(hand);
            if (!StaffWeaponItem.isOpen(stack)) return InteractionResultHolder.m_19100_((Object)itemstack);
            boolean bl = canShoot = player.m_7500_() ? true : this.depleteLiquidNaquadah(player.m_21120_(hand));
            if (!canShoot) {
                return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
            }
            level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundInit.MATOK_FIRE.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
            if (!level.m_5776_()) {
                float explosionPower = this.getFluidStack(itemstack).getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get() ? 1.0f : 0.0f;
                PlasmaProjectile plasmaProjectile = new PlasmaProjectile((EntityType<? extends ThrowableProjectile>)((EntityType)EntityInit.JAFFA_PLASMA.get()), (LivingEntity)player, level, explosionPower);
                plasmaProjectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 5.0f, 1.0f);
                level.m_7967_((Entity)plasmaProjectile);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            player.m_36335_().m_41524_((Item)this, 25);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public FluidStack getFluidStack(ItemStack staffWeaponItemStack) {
        Optional optional = staffWeaponItemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> {
            ItemStack inventoryStack = itemHandler.getStackInSlot(0);
            if (inventoryStack.m_150930_((Item)ItemInit.VIAL.get())) {
                return VialItem.getFluidStack(inventoryStack);
            }
            return FluidStack.EMPTY;
        });
        if (optional.isPresent()) {
            return (FluidStack)optional.get();
        }
        return FluidStack.EMPTY;
    }

    public boolean isCorrectFluid(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        return fluid == FluidInit.LIQUID_NAQUADAH_SOURCE.get() || fluid == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
    }

    public int getNaquadahAmount(ItemStack staffWeaponItemStack) {
        FluidStack fluidStack = this.getFluidStack(staffWeaponItemStack);
        if (this.isCorrectFluid(fluidStack)) {
            return fluidStack.getAmount();
        }
        return 0;
    }

    public boolean depleteLiquidNaquadah(ItemStack staffWeaponItemStack) {
        Optional drained = staffWeaponItemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> {
            ItemStack inventoryStack = itemHandler.getStackInSlot(0);
            if (inventoryStack.m_150930_((Item)ItemInit.VIAL.get())) {
                int drainAmount;
                FluidStack fluidStack = this.getFluidStack(staffWeaponItemStack);
                if (!this.isCorrectFluid(fluidStack)) {
                    return false;
                }
                int n = drainAmount = fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() ? 1 : 5;
                if (this.getNaquadahAmount(staffWeaponItemStack) >= drainAmount) {
                    VialItem.drainNaquadah(inventoryStack, drainAmount);
                    return true;
                }
            }
            return false;
        });
        return drained.isPresent() ? (Boolean)drained.get() : false;
    }

    public static boolean isOpen(ItemStack stack) {
        if (stack.m_150930_((Item)ItemInit.MATOK.get())) {
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(IS_OPEN)) {
                tag.m_128379_(IS_OPEN, false);
                stack.m_41751_(tag);
            }
            return tag.m_128471_(IS_OPEN);
        }
        return false;
    }

    public static void setOpen(Level level, Player player, ItemStack stack, boolean isOpen) {
        if (stack.m_150930_((Item)ItemInit.MATOK.get())) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_(IS_OPEN, isOpen);
            stack.m_41751_(tag);
            level.m_5594_(player, player.m_20183_(), isOpen ? (SoundEvent)SoundInit.MATOK_OPEN.get() : (SoundEvent)SoundInit.MATOK_CLOSE.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return StaffWeaponItem.isOpen(stack) ? this.openModifiers : this.closedModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        MutableComponent isOpen = StaffWeaponItem.isOpen(stack) ? Component.m_237115_((String)"tooltip.sgjourney.matok.open").m_130940_(ChatFormatting.YELLOW) : Component.m_237115_((String)"tooltip.sgjourney.matok.closed").m_130940_(ChatFormatting.YELLOW);
        tooltipComponents.add((Component)isOpen);
        FluidStack fluidStack = this.getFluidStack(stack);
        if (!this.getFluidStack(stack).equals((Object)FluidStack.EMPTY)) {
            MutableComponent liquidNaquadah = Component.m_237115_((String)fluidStack.getTranslationKey()).m_130940_(ChatFormatting.GREEN);
            liquidNaquadah.m_7220_((Component)Component.m_237113_((String)(" " + fluidStack.getAmount() + "mB")).m_130940_(ChatFormatting.GREEN));
            tooltipComponents.add((Component)liquidNaquadah);
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.matok.open_close").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.matok.reload").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

