/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.povstalec.sgjourney.common.menu.ClassicDHDMenu;
import net.povstalec.sgjourney.common.menu.CrystallizerMenu;
import net.povstalec.sgjourney.common.menu.DHDCrystalMenu;
import net.povstalec.sgjourney.common.menu.InterfaceMenu;
import net.povstalec.sgjourney.common.menu.MilkyWayDHDMenu;
import net.povstalec.sgjourney.common.menu.NaquadahGeneratorMenu;
import net.povstalec.sgjourney.common.menu.NaquadahLiquidizerMenu;
import net.povstalec.sgjourney.common.menu.PegasusDHDMenu;
import net.povstalec.sgjourney.common.menu.RingPanelMenu;
import net.povstalec.sgjourney.common.menu.ZPMHubMenu;

public class MenuInit {
    public static DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"sgjourney");
    public static final RegistryObject<MenuType<InterfaceMenu>> INTERFACE = MenuInit.registerMenuType(InterfaceMenu::new, "interface");
    public static final RegistryObject<MenuType<RingPanelMenu>> RING_PANEL = MenuInit.registerMenuType(RingPanelMenu::new, "ring_panel");
    public static final RegistryObject<MenuType<DHDCrystalMenu>> DHD_CRYSTAL = MenuInit.registerMenuType(DHDCrystalMenu::new, "dhd_crystal");
    public static final RegistryObject<MenuType<MilkyWayDHDMenu>> MILKY_WAY_DHD = MenuInit.registerMenuType(MilkyWayDHDMenu::new, "milky_way_dhd");
    public static final RegistryObject<MenuType<PegasusDHDMenu>> PEGASUS_DHD = MenuInit.registerMenuType(PegasusDHDMenu::new, "pegasus_dhd");
    public static final RegistryObject<MenuType<ClassicDHDMenu>> CLASSIC_DHD = MenuInit.registerMenuType(ClassicDHDMenu::new, "classic_dhd");
    public static final RegistryObject<MenuType<NaquadahGeneratorMenu>> NAQUADAH_GENERATOR = MenuInit.registerMenuType(NaquadahGeneratorMenu::new, "naquadah_generator");
    public static final RegistryObject<MenuType<ZPMHubMenu>> ZPM_HUB = MenuInit.registerMenuType(ZPMHubMenu::new, "zpm_hub");
    public static final RegistryObject<MenuType<CrystallizerMenu>> CRYSTALLIZER = MenuInit.registerMenuType(CrystallizerMenu::new, "crystallizer");
    public static final RegistryObject<MenuType<NaquadahLiquidizerMenu>> NAQUADAH_LIQUIDIZER = MenuInit.registerMenuType(NaquadahLiquidizerMenu::new, "naquadah_liquidizer");

    private static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> registerMenuType(IContainerFactory<T> factory, String name) {
        return CONTAINERS.register(name, () -> IForgeMenuType.create((IContainerFactory)factory));
    }

    public static void register(IEventBus eventBus) {
        CONTAINERS.register(eventBus);
    }
}

