/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.capabilities.AncientGeneProvider;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.StargateNetworkSettings;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.data.Universe;

public class CommandInit {
    private static final String EMPTY = "sgjourney:empty";
    private static final String STARGATE_NETWORK = "stargateNetwork";
    private static final String TRANSPORTER_NETWORK = "transporterNetwork";
    private static final String GENE = "gene";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"address").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(CommandInit::getAddress))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"extragalacticAddress").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(CommandInit::getExtragalacticAddress))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"getAllStargates").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(CommandInit::getStargates))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"version").executes(CommandInit::getVersion)))).requires(commandSourceStack -> commandSourceStack.m_6761_(0)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"forceStellarUpdate").executes(CommandInit::forceStellarUpdate)))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"settings").then(Commands.m_82127_((String)"get").executes(CommandInit::getSettings))))).requires(commandSourceStack -> commandSourceStack.m_6761_(0)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"settings").then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"useDatapackAddresses").then(Commands.m_82129_((String)"useDatapackAddresses", (ArgumentType)BoolArgumentType.bool()).executes(CommandInit::useDatapackAddresses))))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"settings").then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"generateRandomSolarSystems").then(Commands.m_82129_((String)"generateRandomSolarSystems", (ArgumentType)BoolArgumentType.bool()).executes(CommandInit::generateRandomSolarSystems))))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"settings").then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"randomAddressFromSeed").then(Commands.m_82129_((String)"randomAddressFromSeed", (ArgumentType)BoolArgumentType.bool()).executes(CommandInit::randomAddressFromSeed))))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)TRANSPORTER_NETWORK).then(Commands.m_82127_((String)"getAllTransporters").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(CommandInit::getTransporters))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)GENE).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"ancient").executes(CommandInit::setAncientGene)))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)GENE).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"inherited").executes(CommandInit::setInheritedGene)))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)GENE).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"artificial").executes(CommandInit::setArtificialGene)))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)GENE).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"remove").executes(CommandInit::removeGene))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)"info").executes(CommandInit::printStargateNetworkInfo))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
    }

    private static int getAddress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_().m_135782_().toString();
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        String currentDimension = level.m_46472_().m_135782_().toString();
        ListTag galaxies = Universe.get(level).getGalaxiesFromDimension(currentDimension);
        if (galaxies.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)"You are not located in any Galaxy").m_130940_(ChatFormatting.DARK_RED));
        } else {
            for (int i = 0; i < galaxies.size(); ++i) {
                String galaxy = (String)galaxies.m_128728_(i).m_128431_().iterator().next();
                String address = Universe.get(level).getAddressInGalaxyFromDimension(galaxy, dimension);
                if (address.equals(EMPTY)) {
                    ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)(dimension + " ")).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)"message.sgjourney.command.get_address.located")).m_7220_((Component)Component.m_237113_((String)(" " + galaxy)).m_130940_(ChatFormatting.LIGHT_PURPLE)));
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.get_address.address").m_7220_((Component)Component.m_237113_((String)(" " + dimension + " ")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237115_((String)"message.sgjourney.command.get_address.in_galaxy")).m_7220_((Component)Component.m_237113_((String)(" " + galaxy + " ")).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237115_((String)"message.sgjourney.command.get_address.is")));
                Style style = Style.f_131099_;
                style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.sgjourney.command.click_to_copy.address")));
                style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, address));
                ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)address).m_6270_(style.m_131157_(ChatFormatting.GOLD)));
            }
        }
        return 1;
    }

    private static int getExtragalacticAddress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_().m_135782_().toString();
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        String address = Universe.get(level).getExtragalacticAddressFromDimension(dimension);
        Style style = Style.f_131099_;
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.sgjourney.command.click_to_copy.address")));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, address));
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.get_extragalactic_address.address").m_7220_((Component)Component.m_237113_((String)(" " + dimension + " ")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237115_((String)"message.sgjourney.command.get_extragalactic_address.is")));
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)address).m_6270_(style.m_131157_(ChatFormatting.LIGHT_PURPLE)));
        return 1;
    }

    private static int getStargates(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_().m_135782_().toString();
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        String solarSystem = Universe.get(level).getSolarSystemFromDimension(dimension);
        if (!solarSystem.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.get_stargates").m_7220_((Component)Component.m_237113_((String)(" " + dimension)).m_130940_(ChatFormatting.GOLD)));
            ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)"-------------------------"));
            CompoundTag stargates = StargateNetwork.get(level).getSolarSystem(solarSystem);
            stargates.m_128431_().forEach(stargateID -> {
                CompoundTag stargate = stargates.m_128469_(stargateID);
                String stargateDimension = stargate.m_128461_("Dimension");
                if (stargateDimension.equals(dimension)) {
                    int[] coordinates = stargate.m_128465_("Coordinates");
                    Style style = Style.f_131099_;
                    style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.sgjourney.command.click_to_copy.address")));
                    style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, stargateID));
                    ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)stargateID).m_6270_(style.m_131157_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)(" X: " + coordinates[0] + " Y: " + coordinates[1] + " Z: " + coordinates[2])).m_130940_(ChatFormatting.BLUE)));
                }
            });
            ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)"-------------------------"));
        } else {
            ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)("No Stargates could be located in " + dimension)).m_130940_(ChatFormatting.RED));
        }
        return 1;
    }

    private static int getVersion(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        int version = StargateNetwork.get(level).getVersion();
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.stargate_network_version").m_7220_((Component)Component.m_237113_((String)(": " + version))).m_130940_(ChatFormatting.GREEN));
        return 1;
    }

    private static int forceStellarUpdate(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        StargateNetwork.get(level).stellarUpdate(level.m_7654_(), true);
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.stellar_update").m_130940_(ChatFormatting.RED));
        return 1;
    }

    private static int getSettings(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        boolean useDatapackAddresses = StargateNetworkSettings.get(level).useDatapackAddresses();
        boolean generateRandomSolarSystems = StargateNetworkSettings.get(level).generateRandomSolarSystems();
        boolean randomAddressFromSeed = StargateNetworkSettings.get(level).randomAddressFromSeed();
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.use_datapack_addresses").m_7220_((Component)Component.m_237113_((String)(": " + useDatapackAddresses))).m_130940_(ChatFormatting.GOLD));
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.generate_random_solar_systems").m_7220_((Component)Component.m_237113_((String)(": " + generateRandomSolarSystems))).m_130940_(ChatFormatting.GOLD));
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.random_addresses_from_seed").m_7220_((Component)Component.m_237113_((String)(": " + randomAddressFromSeed))).m_130940_(ChatFormatting.GOLD));
        return 1;
    }

    private static int useDatapackAddresses(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        boolean setting = BoolArgumentType.getBool(context, (String)"useDatapackAddresses");
        StargateNetworkSettings.get(level).setUseDatapackAddresses(setting);
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.changed").m_130940_(ChatFormatting.YELLOW));
        return 1;
    }

    private static int generateRandomSolarSystems(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        boolean setting = BoolArgumentType.getBool(context, (String)"generateRandomSolarSystems");
        StargateNetworkSettings.get(level).setGenerateRandomSolarSystems(setting);
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.changed").m_130940_(ChatFormatting.YELLOW));
        return 1;
    }

    private static int randomAddressFromSeed(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        boolean setting = BoolArgumentType.getBool(context, (String)"randomAddressFromSeed");
        StargateNetworkSettings.get(level).setRandomAddressFromSeed(setting);
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.changed").m_130940_(ChatFormatting.YELLOW));
        return 1;
    }

    private static int getTransporters(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_().m_135782_().toString();
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.get_transporters").m_7220_((Component)Component.m_237113_((String)(" " + dimension)).m_130940_(ChatFormatting.GOLD)));
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)"-------------------------"));
        CompoundTag ringsNetwork = TransporterNetwork.get(level).getRings(dimension);
        System.out.println(ringsNetwork);
        List ringsNList = ringsNetwork.m_128431_().stream().toList();
        for (int i = 0; i < ringsNList.size(); ++i) {
            int[] coords = ringsNetwork.m_128469_((String)ringsNList.get(i)).m_128465_("Coordinates");
            ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)("X: " + coords[0] + " Y: " + coords[1] + " Z: " + coords[2])).m_130940_(ChatFormatting.BLUE));
        }
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)"-------------------------"));
        return 1;
    }

    private static int setAncientGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        entity.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(cap -> cap.giveGene());
        return 1;
    }

    private static int setInheritedGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        entity.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(cap -> cap.inheritGene());
        return 1;
    }

    private static int setArtificialGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        entity.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(cap -> cap.implantGene());
        return 1;
    }

    private static int removeGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        entity.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(cap -> cap.removeGene());
        return 1;
    }

    private static int printStargateNetworkInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        System.out.println("Dimensions:\n" + Universe.get(level).getDimensions());
        System.out.println("Solar Systems:\n" + Universe.get(level).getSolarSystems());
        System.out.println("Galaxies:\n" + Universe.get(level).getGalaxies());
        System.out.println("Extragalactic Addresses:\n" + Universe.get(level).getExtragalacticAddressInfo());
        System.out.println("=============================");
        System.out.println("Stargates:\n" + StargateNetwork.get(level).getStargates());
        System.out.println("Stargates in Solar Systems:\n" + StargateNetwork.get(level).getSolarSystems());
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)"Printed info onto the console"));
        return 1;
    }
}

