/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.povstalec.sgjourney.common.init.TagInit;

public class PlasmaProjectile
extends ThrowableProjectile {
    private float explosionPower = 0.0f;

    public PlasmaProjectile(EntityType<? extends ThrowableProjectile> type, Level level) {
        super(type, level);
    }

    public PlasmaProjectile(EntityType<? extends ThrowableProjectile> type, double x, double y, double z, Level level, float explosionPower) {
        super(type, x, y, z, level);
        this.explosionPower = explosionPower;
    }

    public PlasmaProjectile(EntityType<? extends ThrowableProjectile> type, LivingEntity livingEntityIn, Level level, float explosionPower) {
        super(type, livingEntityIn, level);
        this.explosionPower = explosionPower;
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().m_5776_()) {
            boolean canDestroy = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this.m_19749_());
            this.m_9236_().m_255391_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionPower, canDestroy, canDestroy ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!this.m_9236_().m_5776_()) {
            Entity entity = hitResult.m_82443_();
            Entity attacker = this.m_19749_();
            entity.m_6469_(this.m_9236_().m_269111_().m_269036_(entity, attacker), 14.0f);
            if (attacker instanceof LivingEntity) {
                this.m_19970_((LivingEntity)attacker, entity);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        Entity entity;
        super.m_8060_(result);
        if (!(this.m_9236_().m_5776_() || (entity = this.m_19749_()) instanceof Mob && !ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)entity))) {
            BlockPos blockpos = result.m_82425_().m_121945_(result.m_82434_());
            if (this.m_9236_().m_46859_(blockpos)) {
                for (Direction direction : Direction.values()) {
                    this.trySetFireToBlock(blockpos, blockpos.m_121945_(direction));
                }
            }
        }
    }

    private boolean trySetFireToBlock(BlockPos blockpos, BlockPos nearbyPos) {
        if (this.m_9236_().m_8055_(nearbyPos).m_204336_(TagInit.Blocks.PLASMA_FLAMMABLE)) {
            this.m_9236_().m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos));
            return true;
        }
        return false;
    }

    protected void m_8097_() {
    }
}

