/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.StargateNetworkSettings;
import net.povstalec.sgjourney.common.init.GalaxyInit;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Galaxy;
import net.povstalec.sgjourney.common.stargate.GalaxyType;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.SolarSystem;

public class Universe
extends SavedData {
    private static final ResourceLocation MILKY_WAY = new ResourceLocation("sgjourney", "milky_way");
    private static final String FILE_NAME = "sgjourney-universe";
    private static final String DIMENSIONS = "Dimensions";
    private static final String SOLAR_SYSTEMS = "SolarSystems";
    private static final String GALAXIES = "Galaxies";
    private static final String EXTRAGALACTIC_ADDRESS_INFO = "ExtragalacticAddressInfo";
    private static final String SOLAR_SYSTEM_DIMENSIONS = "SolarSystemDimensions";
    private static final String SOLAR_SYSTEM_GALAXIES = "SolarSystemGalaxies";
    private static final String EXTRAGALACTIC_ADDRESS = "ExtragalacticAddress";
    private static final String SYMBOLS = "Symbols";
    private static final String POINT_OF_ORIGIN = "PointOfOrigin";
    private static final String GENERATED = "Generated";
    private static final String EMPTY = "sgjourney:empty";
    private CompoundTag universe = new CompoundTag();

    public void generateUniverseInfo(MinecraftServer server) {
        this.registerSolarSystemsFromDataPacks(server);
        if (this.generateRandomSolarSystems(server)) {
            this.generateAndRegisterSolarSystems(server);
        }
        this.addSolarSystemsToGalaxies(server);
        this.addGeneratedSolarSystemsToGalaxies(server);
        this.m_77762_();
    }

    public void eraseUniverseInfo() {
        this.universe = new CompoundTag();
        this.m_77762_();
    }

    private boolean useDatapackAddresses(MinecraftServer server) {
        return StargateNetworkSettings.get(server).useDatapackAddresses();
    }

    private boolean generateRandomSolarSystems(MinecraftServer server) {
        return StargateNetworkSettings.get(server).generateRandomSolarSystems();
    }

    private boolean randomAddressFromSeed(MinecraftServer server) {
        return StargateNetworkSettings.get(server).randomAddressFromSeed();
    }

    private void registerSolarSystemsFromDataPacks(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry solarSystemRegistry = registries.m_175515_(SolarSystem.REGISTRY_KEY);
        Set solarSystemSet = solarSystemRegistry.m_6579_();
        solarSystemSet.forEach(solarSystem -> this.addSolarSystemFromDataPack(server, (SolarSystem)solarSystem.getValue(), ((ResourceKey)solarSystem.getKey()).m_135782_().toString()));
        StargateJourney.LOGGER.info("Datapack Solar Systems registered");
    }

    private void generateAndRegisterSolarSystems(MinecraftServer server) {
        Set levelSet = server.m_129784_();
        levelSet.forEach(dimension -> {
            if (!this.getDimensions().m_128441_(dimension.m_135782_().toString())) {
                this.generateNewSolarSystem(server, (ResourceKey<Level>)dimension);
            }
        });
        StargateJourney.LOGGER.info("Solar Systems generated");
    }

    private void addSolarSystemFromDataPack(MinecraftServer server, SolarSystem system, String systemID) {
        String extragalacticAddress;
        if (this.useDatapackAddresses(server)) {
            extragalacticAddress = new Address(system.getAddressArray()).toString();
        } else {
            int prefix = system.getSymbolPrefix();
            long seed = this.generateRandomAddressSeed(server, systemID);
            extragalacticAddress = this.generateExtragalacticAddress(prefix <= 0 ? 1 : prefix, seed);
        }
        String pointOfOrigin = system.getPointOfOrigin().m_135782_().toString();
        String symbols = system.getSymbols().m_135782_().toString();
        List<ResourceKey<Level>> dimensions = system.getDimensions();
        this.saveSolarSystem(systemID, extragalacticAddress, pointOfOrigin, symbols, dimensions, false);
    }

    private void generateNewSolarSystem(MinecraftServer server, ResourceKey<Level> dimension) {
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry galaxyRegistry = registries.m_175515_(Galaxy.REGISTRY_KEY);
        Galaxy defaultGalaxy = (Galaxy)galaxyRegistry.m_7745_(MILKY_WAY);
        String defaultSymbols = defaultGalaxy.getDefaultSymbols().m_135782_().toString();
        String name = dimension.m_135782_().toString();
        long seed = this.generateRandomAddressSeed(server, name);
        Random random = new Random(seed);
        int prefixValue = random.nextInt(1, 100);
        String prefix = prefixValue < 10 ? "P0" + prefixValue : "P" + prefixValue;
        String systemID = prefix + "-" + seed;
        String extragalacticAddress = this.generateExtragalacticAddress(1, seed);
        String pointOfOrigin = PointOfOrigin.getRandomPointOfOrigin(server, seed).m_135782_().toString();
        List<ResourceKey<Level>> dimensions = List.of(dimension);
        this.saveSolarSystem(systemID, extragalacticAddress, pointOfOrigin, defaultSymbols, dimensions, true);
    }

    protected long generateRandomAddressSeed(MinecraftServer server, String name) {
        long seed = this.randomAddressFromSeed(server) ? server.m_129910_().m_246337_().m_245499_() : 0L;
        for (int i = 0; i < name.length(); ++i) {
            seed += (long)Character.valueOf(name.charAt(i)).charValue();
        }
        return seed;
    }

    protected String generateExtragalacticAddress(int prefix, long seed) {
        String extragalacticAddressString;
        int i = 0;
        while (true) {
            extragalacticAddressString = new Address().randomAddress(prefix, 7, 36, seed += (long)i).toString();
            if (!this.getExtragalacticAddressInfo().m_128441_(extragalacticAddressString)) break;
            ++i;
        }
        return extragalacticAddressString;
    }

    private void saveSolarSystem(String systemID, String extragalacticAddress, String pointOfOrigin, String symbols, List<ResourceKey<Level>> dimensions, boolean generated) {
        this.saveSolarSystemInfo(systemID, extragalacticAddress, pointOfOrigin, symbols, generated);
        this.saveDimensionInfo(systemID, dimensions);
        StargateJourney.LOGGER.info("Saved Solar System: " + systemID + " PoO: " + pointOfOrigin + " Symbols: " + symbols);
    }

    private void saveSolarSystemInfo(String systemID, String extragalacticAddress, String pointOfOrigin, String symbols, boolean generated) {
        CompoundTag solarSystems = this.getSolarSystems();
        CompoundTag solarSystem = new CompoundTag();
        ListTag dimensionList = new ListTag();
        CompoundTag extragalacticAddresses = this.getExtragalacticAddressInfo();
        extragalacticAddresses.m_128359_(extragalacticAddress, systemID);
        this.universe.m_128365_(EXTRAGALACTIC_ADDRESS_INFO, (Tag)extragalacticAddresses);
        solarSystem.m_128359_(POINT_OF_ORIGIN, pointOfOrigin);
        solarSystem.m_128359_(SYMBOLS, symbols);
        solarSystem.m_128359_(EXTRAGALACTIC_ADDRESS, extragalacticAddress);
        solarSystem.m_128365_(SOLAR_SYSTEM_DIMENSIONS, (Tag)dimensionList);
        solarSystem.m_128379_(GENERATED, generated);
        solarSystems.m_128365_(systemID, (Tag)solarSystem);
        this.universe.m_128365_(SOLAR_SYSTEMS, (Tag)solarSystems);
    }

    private void saveDimensionInfo(String systemID, List<ResourceKey<Level>> dimensions) {
        dimensions.forEach(level -> {
            String dimension;
            CompoundTag dimensionList = this.getDimensions();
            if (!dimensionList.m_128441_(dimension = level.m_135782_().toString())) {
                CompoundTag solarSystems = this.getSolarSystems();
                CompoundTag solarSystem = this.getSolarSystem(systemID);
                ListTag solarSystemDimensionList = solarSystem.m_128437_(SOLAR_SYSTEM_DIMENSIONS, 8);
                solarSystemDimensionList.add((Object)StringTag.m_129297_((String)dimension));
                solarSystem.m_128365_(SOLAR_SYSTEM_DIMENSIONS, (Tag)solarSystemDimensionList);
                solarSystems.m_128365_(systemID, (Tag)solarSystem);
                this.universe.m_128365_(SOLAR_SYSTEMS, (Tag)solarSystems);
                dimensionList.m_128359_(dimension, systemID);
                this.universe.m_128365_(DIMENSIONS, (Tag)dimensionList);
                StargateJourney.LOGGER.info("Registered Dimension " + dimension + " under Solar System " + systemID);
            } else {
                StargateJourney.LOGGER.info(dimension + " is already registered in a Solar System");
            }
        });
    }

    private void addSolarSystemsToGalaxies(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry galaxyRegistry = registries.m_175515_(Galaxy.REGISTRY_KEY);
        Set galaxySet = galaxyRegistry.m_6579_();
        galaxySet.forEach(galaxy -> ((Galaxy)galaxy.getValue()).getSystems().forEach(system -> {
            String address;
            String galaxyID = ((ResourceKey)galaxy.getKey()).m_135782_().toString();
            String systemID = ((ResourceKey)system.getFirst()).m_135782_().toString();
            if (this.useDatapackAddresses(server)) {
                address = new Address(((List)((Pair)system.getSecond()).getFirst()).stream().mapToInt(integer -> integer).toArray()).toString();
            } else {
                ResourceKey<GalaxyType> type = ((Galaxy)galaxy.getValue()).getType();
                int size = GalaxyInit.getGalaxyType(type.m_135782_()).getSize();
                long systemValue = this.generateRandomAddressSeed(server, systemID);
                address = this.generateAddress(galaxyID, size, systemValue);
            }
            this.registerGalaxyReferences(galaxyID, systemID, address);
        }));
    }

    private void addGeneratedSolarSystemsToGalaxies(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry galaxyRegistry = registries.m_175515_(Galaxy.REGISTRY_KEY);
        CompoundTag solarSystems = this.getSolarSystems();
        String galaxyID = MILKY_WAY.toString();
        Galaxy defaultGalaxy = (Galaxy)galaxyRegistry.m_7745_(MILKY_WAY);
        ResourceKey<GalaxyType> type = defaultGalaxy.getType();
        int size = GalaxyInit.getGalaxyType(type.m_135782_()).getSize();
        solarSystems.m_128431_().stream().forEach(systemID -> {
            boolean generated = this.getSolarSystem((String)systemID).m_128471_(GENERATED);
            if (generated) {
                long systemValue = this.generateRandomAddressSeed(server, (String)systemID);
                String address = this.generateAddress(galaxyID, size, systemValue);
                this.registerGalaxyReferences(galaxyID, (String)systemID, address);
            }
        });
    }

    protected String generateAddress(String galaxyID, int galaxySize, long seed) {
        String addressString;
        int i = 0;
        while (true) {
            addressString = new Address().randomAddress(6, galaxySize, seed += (long)i).toString();
            if (!this.getGalaxy(galaxyID).m_128441_(addressString)) break;
            ++i;
        }
        return addressString;
    }

    private void registerGalaxyReferences(String galaxyID, String systemID, String address) {
        CompoundTag galaxies = this.getGalaxies();
        CompoundTag galaxy = this.getGalaxy(galaxyID);
        CompoundTag solarSystems = this.getSolarSystems();
        CompoundTag solarSystem = this.getSolarSystem(systemID);
        ListTag galaxyList = solarSystem.m_128437_(SOLAR_SYSTEM_GALAXIES, 10);
        CompoundTag galaxyTag = new CompoundTag();
        galaxyTag.m_128359_(galaxyID, address);
        galaxyList.add((Object)galaxyTag);
        solarSystem.m_128365_(SOLAR_SYSTEM_GALAXIES, (Tag)galaxyList);
        solarSystems.m_128365_(systemID, (Tag)solarSystem);
        this.universe.m_128365_(SOLAR_SYSTEMS, (Tag)solarSystems);
        galaxy.m_128359_(address, systemID);
        galaxies.m_128365_(galaxyID, (Tag)galaxy);
        this.universe.m_128365_(GALAXIES, (Tag)galaxies);
        StargateJourney.LOGGER.info("Registered Solar System " + systemID + " under Galaxy " + galaxyID);
    }

    public CompoundTag getDimensions() {
        return this.universe.m_6426_().m_128469_(DIMENSIONS);
    }

    public String getSolarSystemFromDimension(String dimension) {
        if (!this.getDimensions().m_128441_(dimension)) {
            return EMPTY;
        }
        return this.getDimensions().m_128461_(dimension);
    }

    public CompoundTag getSolarSystems() {
        return this.universe.m_6426_().m_128469_(SOLAR_SYSTEMS);
    }

    public CompoundTag getSolarSystem(String systemID) {
        if (!this.getSolarSystems().m_128441_(systemID)) {
            return new CompoundTag();
        }
        return this.getSolarSystems().m_128469_(systemID);
    }

    public ListTag getDimensionsFromSolarSystem(String systemID) {
        if (this.getSolarSystem(systemID).m_128456_() || !this.getSolarSystem(systemID).m_128441_(SOLAR_SYSTEM_DIMENSIONS)) {
            return new ListTag();
        }
        return this.getSolarSystem(systemID).m_128437_(SOLAR_SYSTEM_DIMENSIONS, 8);
    }

    public ListTag getGalaxiesFromSolarSystem(String systemID) {
        if (this.getSolarSystem(systemID).m_128456_() || !this.getSolarSystem(systemID).m_128441_(SOLAR_SYSTEM_GALAXIES)) {
            return new ListTag();
        }
        return this.getSolarSystem(systemID).m_128437_(SOLAR_SYSTEM_GALAXIES, 10);
    }

    public CompoundTag getGalaxies() {
        return this.universe.m_6426_().m_128469_(GALAXIES);
    }

    private CompoundTag getGalaxy(String galaxyID) {
        if (!this.getGalaxies().m_128441_(galaxyID)) {
            return new CompoundTag();
        }
        return this.getGalaxies().m_128469_(galaxyID);
    }

    public String getSolarSystemInGalaxy(String galaxyID, String address) {
        if (this.getGalaxy(galaxyID).m_128456_() || !this.getGalaxy(galaxyID).m_128441_(address)) {
            return EMPTY;
        }
        return this.getGalaxy(galaxyID).m_128461_(address);
    }

    public ListTag getGalaxiesFromDimension(String dimension) {
        String solarSystem = this.getSolarSystemFromDimension(dimension);
        if (solarSystem.equals(EMPTY)) {
            return new ListTag();
        }
        return this.getGalaxiesFromSolarSystem(solarSystem);
    }

    public String getAddressInGalaxyFromDimension(String galaxy, String dimension) {
        String solarSystem = this.getSolarSystemFromDimension(dimension);
        return this.getAddressInGalaxyFromSolarSystem(galaxy, solarSystem);
    }

    public String getAddressInGalaxyFromSolarSystem(String galaxy, String solarSystem) {
        ListTag galaxyList = this.getGalaxiesFromSolarSystem(solarSystem);
        if (!galaxyList.isEmpty()) {
            for (int i = 0; i < galaxyList.size(); ++i) {
                String entry = (String)galaxyList.m_128728_(i).m_128431_().iterator().next();
                if (!entry.equals(galaxy)) continue;
                String address = galaxyList.m_128728_(i).m_128461_(entry);
                return address;
            }
        }
        return EMPTY;
    }

    public CompoundTag getExtragalacticAddressInfo() {
        return this.universe.m_6426_().m_128469_(EXTRAGALACTIC_ADDRESS_INFO);
    }

    public String getSolarSystemFromExtragalacticAddress(String extragalacticAddress) {
        if (!this.getExtragalacticAddressInfo().m_128441_(extragalacticAddress)) {
            return EMPTY;
        }
        return this.getExtragalacticAddressInfo().m_128461_(extragalacticAddress);
    }

    public String getExtragalacticAddressFromDimension(String dimension) {
        if (!this.getSolarSystem(this.getSolarSystemFromDimension(dimension)).m_128441_(EXTRAGALACTIC_ADDRESS)) {
            return EMPTY;
        }
        return this.getSolarSystem(this.getSolarSystemFromDimension(dimension)).m_128461_(EXTRAGALACTIC_ADDRESS);
    }

    public String getPointOfOrigin(String dimension) {
        if (!this.getSolarSystem(this.getSolarSystemFromDimension(dimension)).m_128441_(POINT_OF_ORIGIN)) {
            return EMPTY;
        }
        return this.getSolarSystem(this.getSolarSystemFromDimension(dimension)).m_128461_(POINT_OF_ORIGIN);
    }

    public String getSymbols(String dimension) {
        if (!this.getSolarSystem(this.getSolarSystemFromDimension(dimension)).m_128441_(SYMBOLS)) {
            return EMPTY;
        }
        return this.getSolarSystem(this.getSolarSystemFromDimension(dimension)).m_128461_(SYMBOLS);
    }

    public static Universe create() {
        return new Universe();
    }

    public static Universe load(CompoundTag tag) {
        Universe data = Universe.create();
        data.universe = tag.m_6426_();
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.universe.m_6426_();
        return tag;
    }

    @Nonnull
    public static Universe get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return Universe.get(level.m_7654_());
    }

    @Nonnull
    public static Universe get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (Universe)storage.m_164861_(Universe::load, Universe::create, FILE_NAME);
    }
}

