/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.config.CommonStargateNetworkConfig;

public class StargateNetworkSettings
extends SavedData {
    private static final String FILE_NAME = "sgjourney-stargate_network_settings";
    private static final String USE_DATAPACK_ADDRESSES = "UseDatapackAddresses";
    private static final String GENERATE_RANDOM_SOLAR_SYSTEMS = "GenerateRandomSolarSystems";
    private static final String RANDOM_ADDRESS_FROM_SEED = "RandomAddressFromSeed";
    private CompoundTag stargateNetworkSettings = new CompoundTag();

    public void updateSettings() {
        CompoundTag network = this.stargateNetworkSettings.m_6426_();
        StargateJourney.LOGGER.info("Attempting to update settings");
        if (!network.m_128441_(USE_DATAPACK_ADDRESSES)) {
            boolean useDatapackAddresses = CommonStargateNetworkConfig.use_datapack_addresses.get();
            StargateJourney.LOGGER.info("Use Datapack Addresses updated to " + useDatapackAddresses);
            this.stargateNetworkSettings.m_128379_(USE_DATAPACK_ADDRESSES, useDatapackAddresses);
        }
        if (!network.m_128441_(GENERATE_RANDOM_SOLAR_SYSTEMS)) {
            boolean generateRandomSolarSystems = CommonStargateNetworkConfig.generate_random_solar_systems.get();
            StargateJourney.LOGGER.info("Generate random Solar Systems updated to " + generateRandomSolarSystems);
            this.stargateNetworkSettings.m_128379_(GENERATE_RANDOM_SOLAR_SYSTEMS, generateRandomSolarSystems);
        }
        if (!network.m_128441_(RANDOM_ADDRESS_FROM_SEED)) {
            boolean randomAddressFromSeed = CommonStargateNetworkConfig.random_addresses_from_seed.get();
            StargateJourney.LOGGER.info("Random Address from Seed updated to " + randomAddressFromSeed);
            this.stargateNetworkSettings.m_128379_(RANDOM_ADDRESS_FROM_SEED, randomAddressFromSeed);
        }
        this.m_77762_();
    }

    public boolean useDatapackAddresses() {
        return this.stargateNetworkSettings.m_6426_().m_128471_(USE_DATAPACK_ADDRESSES);
    }

    public boolean generateRandomSolarSystems() {
        return this.stargateNetworkSettings.m_6426_().m_128471_(GENERATE_RANDOM_SOLAR_SYSTEMS);
    }

    public boolean randomAddressFromSeed() {
        return this.stargateNetworkSettings.m_6426_().m_128471_(RANDOM_ADDRESS_FROM_SEED);
    }

    public void setUseDatapackAddresses(boolean useDatapackAddresses) {
        this.stargateNetworkSettings.m_128379_(USE_DATAPACK_ADDRESSES, useDatapackAddresses);
        this.m_77762_();
    }

    public void setGenerateRandomSolarSystems(boolean generateRandomSolarSystems) {
        this.stargateNetworkSettings.m_128379_(GENERATE_RANDOM_SOLAR_SYSTEMS, generateRandomSolarSystems);
        this.m_77762_();
    }

    public void setRandomAddressFromSeed(boolean randomAddressFromSeed) {
        this.stargateNetworkSettings.m_128379_(RANDOM_ADDRESS_FROM_SEED, randomAddressFromSeed);
        this.m_77762_();
    }

    public static StargateNetworkSettings create(MinecraftServer server) {
        return new StargateNetworkSettings();
    }

    public static StargateNetworkSettings load(MinecraftServer server, CompoundTag tag) {
        StargateNetworkSettings data = StargateNetworkSettings.create(server);
        data.stargateNetworkSettings = tag;
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.stargateNetworkSettings.m_6426_();
        return tag;
    }

    @Nonnull
    public static StargateNetworkSettings get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return StargateNetworkSettings.get(level.m_7654_());
    }

    @Nonnull
    public static StargateNetworkSettings get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (StargateNetworkSettings)storage.m_164861_(tag -> StargateNetworkSettings.load(server, tag), () -> StargateNetworkSettings.create(server), FILE_NAME);
    }
}

