/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.cctweaked.methods;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Map;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.InterfaceMethod;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.stargate.Address;

public class InterfaceMethods {

    public static class AddressToDimension
    implements InterfaceMethod<AbstractStargateEntity> {
        @Override
        public String getName() {
            return "calculateSolarSystem";
        }

        @Override
        public MethodResult use(IComputerAccess computer, ILuaContext context, AbstractInterfaceEntity interfaceEntity, AbstractStargateEntity stargate, IArguments arguments) throws LuaException {
            MethodResult result = context.executeMainThreadTask(() -> {
                Map addressTable = arguments.getTable(0);
                Address address = new Address(addressTable);
                String dimension = stargate.m_58904_().m_46472_().m_135782_().toString();
                String galaxy = (String)Universe.get(stargate.m_58904_()).getGalaxiesFromDimension(dimension).m_128728_(0).m_128431_().iterator().next();
                String solarSystem = Universe.get(stargate.m_58904_()).getSolarSystemInGalaxy(galaxy, address.toString());
                return new Object[]{solarSystem};
            });
            return result;
        }
    }

    public static class AddressToString
    implements InterfaceMethod<BlockEntity> {
        @Override
        public String getName() {
            return "addressToString";
        }

        @Override
        public MethodResult use(IComputerAccess computer, ILuaContext context, AbstractInterfaceEntity interfaceEntity, BlockEntity stargate, IArguments arguments) throws LuaException {
            Map addressTable = arguments.getTable(0);
            Address address = new Address(addressTable);
            return MethodResult.of((Object)address.toString());
        }
    }

    public static class SetEnergyTarget
    implements InterfaceMethod<BlockEntity> {
        @Override
        public String getName() {
            return "setEnergyTarget";
        }

        @Override
        public MethodResult use(IComputerAccess computer, ILuaContext context, AbstractInterfaceEntity interfaceEntity, BlockEntity stargate, IArguments arguments) throws LuaException {
            long energyTarget = arguments.getLong(0);
            interfaceEntity.setEnergyTarget(energyTarget);
            return MethodResult.of();
        }
    }
}

