/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;
import net.povstalec.sgjourney.common.stargate.ConnectionState;

public abstract class AbstractStargateBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.m_61587_((String)"orientation", Orientation.class);
    public static final EnumProperty<StargatePart> PART = EnumProperty.m_61587_((String)"stargate_part", StargatePart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<ConnectionState> CONNECTION_STATE = EnumProperty.m_61587_((String)"connection_state", ConnectionState.class);
    public static final IntegerProperty CHEVRONS_ACTIVE = IntegerProperty.m_61631_((String)"chevrons_active", (int)0, (int)9);
    protected VoxelShapeProvider shapeProvider;

    public AbstractStargateBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(ORIENTATION, (Comparable)((Object)Orientation.REGULAR))).m_61124_(CONNECTION_STATE, (Comparable)((Object)ConnectionState.IDLE))).m_61124_((Property)CHEVRONS_ACTIVE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)StargatePart.BASE)));
        this.shapeProvider = new VoxelShapeProvider(width, horizontalOffset);
    }

    public ArrayList<StargatePart> getParts() {
        return StargatePart.DEFAULT_PARTS;
    }

    public VoxelShape getShapeFromArray(VoxelShape[][] shapes, Direction direction, Orientation orientation) {
        int horizontal = direction.m_122416_();
        int vertical = orientation.get2DDataValue();
        return shapes[vertical][horizontal % shapes[vertical].length];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{ORIENTATION}).m_61104_(new Property[]{PART}).m_61104_(new Property[]{CONNECTION_STATE}).m_61104_(new Property[]{CHEVRONS_ACTIVE});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        if (state.m_61143_(ORIENTATION) != Orientation.REGULAR) {
            return this.shapeProvider.HORIZONTAL;
        }
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? this.shapeProvider.Z_FULL : this.shapeProvider.X_FULL;
    }

    public BlockState m_7417_(BlockState oldState, Direction direction, BlockState newState, LevelAccessor levelAccessor, BlockPos oldPos, BlockPos newPos) {
        if (((Boolean)oldState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(oldPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(oldState, direction, newState, levelAccessor, oldPos, newPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        AbstractStargateEntity stargate = this.getStargate(level, pos, state);
        if (stargate != null && !level.m_5776_() && !player.m_7500_()) {
            ItemStack itemstack = new ItemStack((ItemLike)this.m_5456_());
            stargate.m_187476_(itemstack);
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            itementity.m_149678_();
            level.m_7967_((Entity)itementity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public abstract AbstractStargateEntity getStargate(Level var1, BlockPos var2, BlockState var3);
}

