/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.StargateVariantItem;
import net.povstalec.sgjourney.common.stargate.ConnectionState;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

public abstract class AbstractStargateBaseBlock
extends AbstractStargateBlock
implements EntityBlock {
    public static final String EMPTY = "sgjourney:empty";

    public AbstractStargateBaseBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties, width, horizontalOffset);
    }

    public abstract AbstractStargateRingBlock getRing();

    public boolean setVariant(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof StargateVariantItem) {
            if (!stack.m_41782_()) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                    if (stargate.getVariant().equals(EMPTY)) {
                        player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.same_variant"), true);
                        return true;
                    }
                    stargate.setVariant(EMPTY);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return true;
            }
            Optional<String> variant = StargateVariantItem.getVariantString(stack);
            if (variant.isPresent()) {
                if (level.m_5776_()) {
                    return true;
                }
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                    if (variant.get().equals(stargate.getVariant())) {
                        player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.same_variant"), true);
                        return true;
                    }
                    RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
                    Registry variantRegistry = registries.m_175515_(StargateVariant.REGISTRY_KEY);
                    Optional<StargateVariant> stargateVariant = Optional.ofNullable((StargateVariant)variantRegistry.m_7745_(new ResourceLocation(variant.get())));
                    if (stargateVariant.isPresent() && !stargateVariant.get().getBaseStargate().equals((Object)BlockEntityType.m_58954_((BlockEntityType)stargate.m_58903_()))) {
                        player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.incorrect_stargate_type"), true);
                        return true;
                    }
                    stargate.setVariant(variant.get());
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return true;
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.invalid_variant"), true);
                return true;
            }
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_21120_(hand).m_150930_((Item)ItemInit.STARGATE_VARIANT_CRYSTAL.get())) {
            return this.setVariant(level, pos, player, hand) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        Orientation orientation = Orientation.getOrientationFromXRot(player);
        if (orientation == Orientation.REGULAR && blockpos.m_123342_() > level.m_151558_() - 6) {
            return null;
        }
        for (StargatePart part : this.getParts()) {
            if (part.equals((Object)StargatePart.BASE) || level.m_8055_(part.getRingPos(blockpos, context.m_8125_().m_122424_(), orientation)).m_60629_(context)) continue;
            if (player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.not_enough_space"), true);
            }
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)ORIENTATION, (Comparable)((Object)orientation));
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public abstract BlockState ringState();

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        for (StargatePart part : this.getParts()) {
            if (part.equals((Object)StargatePart.BASE)) continue;
            level.m_7731_(part.getRingPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION))), (BlockState)((BlockState)((BlockState)((BlockState)this.ringState().m_61124_((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).m_61124_((Property)AbstractStargateRingBlock.FACING, (Comparable)((Direction)level.m_8055_(pos).m_61143_((Property)FACING)))).m_61124_((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)((Orientation)((Object)level.m_8055_(pos).m_61143_((Property)ORIENTATION)))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(part.getRingPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION)))).m_76152_() == Fluids.f_76193_)), 3);
        }
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
                stargate.bypassDisconnectStargate(Stargate.Feedback.STARGATE_DESTROYED);
                stargate.removeFromBlockEntityList();
            }
            for (StargatePart part : this.getParts()) {
                BlockPos ringPos;
                BlockState state;
                if (part.equals((Object)StargatePart.BASE) || !((state = level.m_8055_(ringPos = part.getRingPos(pos, (Direction)oldState.m_61143_((Property)FACING), (Orientation)((Object)oldState.m_61143_((Property)ORIENTATION))))).m_60734_() instanceof AbstractStargateBlock)) continue;
                boolean waterlogged = state.m_60734_() instanceof AbstractStargateRingBlock ? (Boolean)state.m_61143_((Property)AbstractStargateRingBlock.WATERLOGGED) : false;
                level.m_7731_(ringPos, waterlogged ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 3);
            }
            super.m_6810_(oldState, level, pos, newState, isMoving);
        }
    }

    public void updateStargate(Level level, BlockPos pos, BlockState state, ConnectionState connectionState, int chevronsActive) {
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)CONNECTION_STATE, (Comparable)((Object)connectionState))).m_61124_((Property)CHEVRONS_ACTIVE, (Comparable)Integer.valueOf(chevronsActive)), 2);
        for (StargatePart part : this.getParts()) {
            BlockPos ringPos;
            if (part.equals((Object)StargatePart.BASE) || !(level.m_8055_(ringPos = part.getRingPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION)))).m_60734_() instanceof AbstractStargateBlock)) continue;
            level.m_7731_(part.getRingPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION))), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.ringState().m_61124_((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).m_61124_((Property)AbstractStargateRingBlock.CONNECTION_STATE, (Comparable)((Object)((ConnectionState)((Object)level.m_8055_(pos).m_61143_((Property)CONNECTION_STATE)))))).m_61124_((Property)AbstractStargateRingBlock.CHEVRONS_ACTIVE, (Comparable)((Integer)level.m_8055_(pos).m_61143_((Property)CHEVRONS_ACTIVE)))).m_61124_((Property)AbstractStargateRingBlock.FACING, (Comparable)((Direction)level.m_8055_(pos).m_61143_((Property)FACING)))).m_61124_((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)((Orientation)((Object)level.m_8055_(pos).m_61143_((Property)ORIENTATION)))))).m_61124_((Property)AbstractStargateRingBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(part.getRingPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION)))).m_76152_() == Fluids.f_76193_)), 3);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag blockEntityTag;
        long energy = 0L;
        String id = "";
        if (stack.m_41782_()) {
            String variant;
            blockEntityTag = stack.m_41783_().m_128469_("BlockEntityTag");
            if (blockEntityTag.m_128441_("Variant") && !(variant = blockEntityTag.m_128461_("Variant")).equals(EMPTY)) {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.variant").m_7220_((Component)Component.m_237113_((String)(": " + variant))).m_130940_(ChatFormatting.GREEN));
            }
            if (blockEntityTag.m_128441_("Energy")) {
                energy = blockEntityTag.m_128454_("Energy");
            }
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + energy + " FE"))).m_130940_(ChatFormatting.DARK_RED));
        if (stack.m_41782_()) {
            blockEntityTag = stack.m_41783_().m_128469_("BlockEntityTag");
            if (blockEntityTag.m_128441_("DisplayID") && blockEntityTag.m_128471_("DisplayID") || ((Boolean)CommonStargateConfig.always_display_stargate_id.get()).booleanValue()) {
                if (blockEntityTag.m_128441_("ID")) {
                    id = blockEntityTag.m_128461_("ID");
                }
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.address").m_7220_((Component)Component.m_237113_((String)(": " + id))).m_130940_(ChatFormatting.AQUA));
            }
            if (blockEntityTag.m_128441_("Upgraded") && blockEntityTag.m_128471_("Upgraded")) {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.upgraded").m_130940_(ChatFormatting.DARK_GREEN));
            }
        }
        if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("AddToNetwork") && !stack.m_41783_().m_128469_("BlockEntityTag").m_128471_("AddToNetwork")) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.not_added_to_network").m_130940_(ChatFormatting.YELLOW));
        }
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }

    public static ItemStack excludeFromNetwork(ItemStack stack) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128379_("AddToNetwork", false);
        stack.m_41700_("BlockEntityTag", (Tag)compoundtag);
        return stack;
    }

    @Override
    public AbstractStargateEntity getStargate(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
            return stargate;
        }
        return null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typeA, BlockEntityType<E> typeB, BlockEntityTicker<? super E> ticker) {
        return typeB == typeA ? ticker : null;
    }
}

