/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractCrystallizerEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.items.StargateUpgradeItem;
import net.povstalec.sgjourney.common.recipe.CrystallizerRecipe;

public class CrystallizerEntity
extends AbstractCrystallizerEntity {
    public CrystallizerEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.CRYSTALLIZER.get(), pos, state);
    }

    @Override
    public Fluid getDesiredFluid() {
        return (Fluid)FluidInit.LIQUID_NAQUADAH_SOURCE.get();
    }

    @Override
    protected boolean hasIngredients() {
        Level level = this.m_58904_();
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CrystallizerRecipe.Type.INSTANCE, (Container)inventory, level);
        if (!recipe.isPresent()) {
            return false;
        }
        if (!((Boolean)CommonStargateConfig.enable_classic_stargate_upgrades.get()).booleanValue() && ((CrystallizerRecipe)recipe.get()).m_8043_(null).m_41720_() instanceof StargateUpgradeItem) {
            return false;
        }
        return CrystallizerEntity.hasSpaceInOutputSlot(inventory, ((CrystallizerRecipe)recipe.get()).m_8043_(null));
    }

    @Override
    protected void crystallize() {
        Level level = this.m_58904_();
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CrystallizerRecipe.Type.INSTANCE, (Container)inventory, level);
        if (this.hasIngredients()) {
            this.useUpItems((CrystallizerRecipe)recipe.get(), 0);
            this.useUpItems((CrystallizerRecipe)recipe.get(), 1);
            this.useUpItems((CrystallizerRecipe)recipe.get(), 2);
            this.itemHandler.setStackInSlot(3, ((CrystallizerRecipe)recipe.get()).m_8043_(null));
            this.progress = 0;
        }
    }

    protected void useUpItems(CrystallizerRecipe recipe, int slot) {
        this.itemHandler.extractItem(slot, recipe.getAmountInSlot(slot), false);
    }
}

