/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.tech.AbstractInterfaceBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.capabilities.CCTweakedCapabilities;
import net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals.InterfacePeripheralWrapper;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundInterfaceUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInterfaceEntity
extends EnergyBlockEntity {
    public static final String ENERGY_TARGET = "EnergyTarget";
    private static final long DEFAULT_ENERGY_TARGET = 200000L;
    private int desiredSymbol = 0;
    private int currentSymbol = 0;
    private boolean rotate = false;
    private boolean rotateClockwise = true;
    private long energyTarget = 200000L;
    public EnergyBlockEntity energyBlockEntity = null;
    protected InterfacePeripheralWrapper peripheralWrapper;
    protected InterfaceType interfaceType;

    public AbstractInterfaceEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InterfaceType interfaceType) {
        super(type, pos, state);
        this.interfaceType = interfaceType;
        if (ModList.get().isLoaded("computercraft")) {
            this.peripheralWrapper = new InterfacePeripheralWrapper(this);
        }
    }

    @Override
    public void onLoad() {
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58904_().m_8055_(pos);
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof AbstractInterfaceBlock) {
            AbstractInterfaceBlock ccInterface = (AbstractInterfaceBlock)block;
            ccInterface.updateInterface(state, level, pos);
        }
        super.onLoad();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyTarget = tag.m_128454_(ENERGY_TARGET);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128356_(ENERGY_TARGET, this.energyTarget);
        super.m_183515_(tag);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (ModList.get().isLoaded("computercraft") && cap == CCTweakedCapabilities.CAPABILITY_PERIPHERAL) {
            return this.peripheralWrapper.newPeripheral().cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean updateInterface(Level level, BlockPos pos, Block block, BlockState state) {
        if (this.peripheralWrapper != null) {
            return this.peripheralWrapper.resetInterface();
        }
        Block block2 = level.m_8055_(pos).m_60734_();
        if (block2 instanceof AbstractInterfaceBlock) {
            AbstractInterfaceBlock ccInterface = (AbstractInterfaceBlock)block2;
            ccInterface.updateInterface(state, level, pos);
        }
        return true;
    }

    public Direction getDirection() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof AbstractInterfaceBlock) {
            return (Direction)gateState.m_61143_((Property)AbstractInterfaceBlock.FACING);
        }
        StargateJourney.LOGGER.error("Couldn't find Direction");
        return null;
    }

    @Nullable
    public EnergyBlockEntity findEnergyBlockEntity() {
        EnergyBlockEntity energyBlockEntity;
        BlockEntity blockEntity;
        Direction direction = this.getDirection();
        if (direction == null) {
            return null;
        }
        BlockPos realPos = this.m_58899_().m_121945_(direction);
        BlockState state = this.f_58857_.m_8055_(realPos);
        if (this.f_58857_.m_8055_(realPos).m_60734_() instanceof AbstractStargateRingBlock) {
            realPos = ((StargatePart)((Object)state.m_61143_((Property)AbstractStargateRingBlock.PART))).getBaseBlockPos(realPos, (Direction)state.m_61143_((Property)AbstractStargateRingBlock.FACING), (Orientation)((Object)state.m_61143_((Property)AbstractStargateRingBlock.ORIENTATION)));
        }
        return (blockEntity = this.f_58857_.m_7702_(realPos)) instanceof EnergyBlockEntity ? (energyBlockEntity = (EnergyBlockEntity)blockEntity) : null;
    }

    public InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return side != this.getDirection();
    }

    @Override
    protected boolean outputsEnergy() {
        return true;
    }

    @Override
    protected boolean receivesEnergy() {
        return true;
    }

    @Override
    protected void outputEnergy(Direction outputDirection) {
        if (this.energyBlockEntity.getEnergyStored() >= this.energyTarget) {
            return;
        }
        long simulatedOutputAmount = this.ENERGY_STORAGE.extractLongEnergy(this.maxExtract(), true);
        long simulatedReceiveAmount = this.energyBlockEntity.ENERGY_STORAGE.receiveLongEnergy(simulatedOutputAmount, true);
        this.ENERGY_STORAGE.extractLongEnergy(simulatedReceiveAmount, false);
        this.energyBlockEntity.ENERGY_STORAGE.receiveLongEnergy(simulatedReceiveAmount, false);
    }

    public long getEnergyTarget() {
        return this.energyTarget;
    }

    public void setEnergyTarget(long energyTarget) {
        this.energyTarget = energyTarget;
    }

    public InterfacePeripheralWrapper getPeripheralWrapper() {
        if (!ModList.get().isLoaded("computercraft")) {
            return null;
        }
        return this.peripheralWrapper;
    }

    public void queueEvent(String eventName, Object ... objects) {
        if (!ModList.get().isLoaded("computercraft")) {
            return;
        }
        if (this.peripheralWrapper != null) {
            this.peripheralWrapper.queueEvent(eventName, objects);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractInterfaceEntity interfaceEntity) {
        interfaceEntity.energyBlockEntity = interfaceEntity.findEnergyBlockEntity();
        if (interfaceEntity.energyBlockEntity != null) {
            int lastSymbol = interfaceEntity.currentSymbol;
            interfaceEntity.outputEnergy(interfaceEntity.getDirection());
            EnergyBlockEntity energyBlockEntity = interfaceEntity.energyBlockEntity;
            if (energyBlockEntity instanceof MilkyWayStargateEntity) {
                MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)energyBlockEntity;
                interfaceEntity.rotateStargate(stargate);
            }
            if (lastSymbol != interfaceEntity.currentSymbol && !level.m_5776_()) {
                AbstractInterfaceEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                level.m_46590_(pos, state.m_60734_(), (Direction)state.m_61143_((Property)AbstractInterfaceBlock.FACING));
            }
        }
        if (level.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(interfaceEntity.f_58858_)), (Object)new ClientboundInterfaceUpdatePacket(interfaceEntity.f_58858_, interfaceEntity.getEnergyStored()));
    }

    private void rotateStargate(MilkyWayStargateEntity stargate) {
        if (this.rotate) {
            if (stargate.isCurrentSymbol(this.desiredSymbol)) {
                this.rotate = false;
            } else {
                stargate.rotate(this.rotateClockwise);
            }
        }
        this.currentSymbol = stargate.getCurrentSymbol();
    }

    public static enum InterfaceType {
        BASIC("basic_interface"),
        CRYSTAL("crystal_interface"),
        ADVANCED_CRYSTAL("advanced_crystal_interface");

        private String typeName;

        private InterfaceType(String typeName) {
            this.typeName = typeName;
        }

        public String getName() {
            return this.typeName;
        }

        public boolean hasCrystalMethods() {
            return this == CRYSTAL || this == ADVANCED_CRYSTAL;
        }

        public boolean hasAdvancedCrystalMethods() {
            return this == ADVANCED_CRYSTAL;
        }
    }
}

