/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.sound.SoundWrapper;
import net.povstalec.sgjourney.common.block_entities.SGJourneyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.tech.AdvancedCrystalInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.tech.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.tech.CrystalInterfaceEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundStargateUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.ConnectionState;
import net.povstalec.sgjourney.common.stargate.Dialing;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.Symbols;
import net.povstalec.sgjourney.common.stargate.Wormhole;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStargateEntity
extends SGJourneyBlockEntity {
    private static final String EVENT_CHEVRON_ENGAGED = "stargate_chevron_engaged";
    private static final String EVENT_RESET = "stargate_reset";
    public static final String RESTRICT_NETWORK = "RestrictNetwork";
    public static final float STANDARD_THICKNESS = 9.0f;
    public static final float VERTICAL_CENTER_STANDARD_HEIGHT = 0.5f;
    public static final float HORIZONTAL_CENTER_STANDARD_HEIGHT = 0.28125f;
    protected final Stargate.Gen generation;
    protected int network;
    protected boolean restrictNetwork = false;
    protected BlockPos centerPosition;
    protected Direction direction;
    protected Orientation orientation;
    protected Stargate.Feedback recentFeedback = Stargate.Feedback.NONE;
    protected int kawooshTick = 0;
    protected int animationTick = 0;
    protected int[] engagedChevrons = Dialing.DEFAULT_CHEVRON_CONFIGURATION;
    protected int timesOpened = 0;
    protected String pointOfOrigin = "sgjourney:empty";
    protected String symbols = "sgjourney:empty";
    protected String variant = "sgjourney:empty";
    protected Address address = new Address();
    protected String connectionID = "sgjourney:empty";
    protected Wormhole wormhole = new Wormhole();
    protected boolean hasDHD = false;
    protected boolean advancedProtocolsEnabled = false;
    protected int openSoundLead = 28;
    protected float verticalCenterHeight;
    protected float horizontalCenterHeight;
    public SoundWrapper wormholeIdleSound = null;
    public SoundWrapper wormholeOpenSound = null;
    public SoundWrapper spinSound = null;
    protected boolean displayID = false;
    protected boolean upgraded = false;

    public AbstractStargateEntity(BlockEntityType<?> blockEntity, BlockPos pos, BlockState state, Stargate.Gen gen, int defaultNetwork, float verticalCenterHeight, float horizontalCenterHeight) {
        super(blockEntity, pos, state, SGJourneyBlockEntity.Type.STARGATE);
        this.generation = gen;
        this.network = defaultNetwork;
        this.verticalCenterHeight = verticalCenterHeight;
        this.horizontalCenterHeight = horizontalCenterHeight;
    }

    public AbstractStargateEntity(BlockEntityType<?> blockEntity, BlockPos pos, BlockState state, Stargate.Gen gen, int defaultNetwork) {
        this(blockEntity, pos, state, gen, defaultNetwork, 0.5f, 0.28125f);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.timesOpened = tag.m_128451_("TimesOpened");
        this.address.fromArray(tag.m_128465_("Address"));
        this.network = tag.m_128451_("Network");
        this.restrictNetwork = tag.m_128471_(RESTRICT_NETWORK);
        this.connectionID = tag.m_128461_("ConnectionID");
        this.advancedProtocolsEnabled = tag.m_128471_("AdvancedProtocolsEnabled");
        this.displayID = tag.m_128471_("DisplayID");
        this.upgraded = tag.m_128471_("Upgraded");
        this.variant = tag.m_128461_("Variant");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128405_("TimesOpened", this.timesOpened);
        tag.m_128385_("Address", this.address.toArray());
        tag.m_128405_("Network", this.network);
        tag.m_128379_(RESTRICT_NETWORK, this.restrictNetwork);
        tag.m_128359_("ConnectionID", this.connectionID);
        tag.m_128379_("AdvancedProtocolsEnabled", this.advancedProtocolsEnabled);
        tag.m_128379_("DisplayID", this.displayID);
        tag.m_128379_("Upgraded", this.upgraded);
        tag.m_128359_("Variant", this.variant);
        super.m_183515_(tag);
    }

    public CompoundTag serializeStargateInfo() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("TimesOpened", this.timesOpened);
        tag.m_128385_("Address", this.address.toArray());
        tag.m_128405_("Network", this.network);
        tag.m_128379_(RESTRICT_NETWORK, this.restrictNetwork);
        tag.m_128359_("ConnectionID", this.connectionID);
        tag.m_128379_("AdvancedProtocolsEnabled", this.advancedProtocolsEnabled);
        tag.m_128359_("ID", this.getID());
        tag.m_128379_("AddToNetwork", this.addToNetwork);
        tag.m_128356_("Energy", this.getEnergyStored());
        tag.m_128379_("DisplayID", this.displayID);
        tag.m_128379_("Upgraded", this.upgraded);
        return tag;
    }

    public void deserializeStargateInfo(CompoundTag tag, boolean isUpgraded) {
        this.timesOpened = tag.m_128451_("TimesOpened");
        this.address.fromArray(tag.m_128465_("Address"));
        this.network = tag.m_128451_("Network");
        this.restrictNetwork = tag.m_128471_(RESTRICT_NETWORK);
        this.connectionID = tag.m_128461_("ConnectionID");
        this.advancedProtocolsEnabled = tag.m_128471_("AdvancedProtocolsEnabled");
        this.setID(tag.m_128461_("ID"));
        this.addToNetwork = tag.m_128471_("AddToNetwork");
        this.setEnergy(tag.m_128454_("Energy"));
        this.displayID = tag.m_128471_("DisplayID");
        this.upgraded = isUpgraded ? isUpgraded : tag.m_128471_("Upgraded");
        this.m_6596_();
    }

    @Override
    public CompoundTag addToBlockEntityList() {
        CompoundTag blockEntity = super.addToBlockEntityList();
        StargateNetwork.get(this.f_58857_).addStargate(this.f_58857_.m_7654_(), this.getID(), blockEntity, this.getGeneration().getGen());
        return blockEntity;
    }

    @Override
    public CompoundTag addNewToBlockEntityList() {
        CompoundTag blockEntity = super.addNewToBlockEntityList();
        StargateNetwork.get(this.f_58857_).addStargate(this.f_58857_.m_7654_(), this.getID(), blockEntity, this.getGeneration().getGen());
        return blockEntity;
    }

    @Override
    public void removeFromBlockEntityList() {
        super.removeFromBlockEntityList();
        StargateNetwork.get(this.f_58857_).removeStargate(this.f_58857_, this.getID());
    }

    @Override
    protected String generateID() {
        String addressString;
        Random random = new Random();
        Address address = new Address().randomAddress(8, 36, random.nextLong());
        do {
            addressString = address.toString();
        } while (BlockEntityList.get(this.f_58857_).getBlockEntities(SGJourneyBlockEntity.Type.STARGATE.id).m_128441_(addressString));
        return addressString;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.getCenterPos().m_123341_() - 3), (double)(this.getCenterPos().m_123342_() - 3), (double)(this.getCenterPos().m_123343_() - 3), (double)(this.getCenterPos().m_123341_() + 4), (double)(this.getCenterPos().m_123342_() + 4), (double)(this.getCenterPos().m_123343_() + 4));
    }

    public static int getChevron(AbstractStargateEntity stargate, int chevronNumber) {
        if (chevronNumber < 0 || chevronNumber > 8) {
            return 0;
        }
        return stargate.getEngagedChevrons()[chevronNumber];
    }

    public Stargate.Feedback engageSymbol(int symbol) {
        if (this.f_58857_.m_5776_()) {
            return Stargate.Feedback.NONE;
        }
        if (symbol == 0) {
            return this.setRecentFeedback(this.lockPrimaryChevron());
        }
        return this.setRecentFeedback(this.encodeChevron(symbol, false, false));
    }

    public Stargate.Feedback encodeChevron(int symbol, boolean incoming, boolean encodeSound) {
        if (this.address.containsSymbol(symbol)) {
            return this.setRecentFeedback(Stargate.Feedback.SYMBOL_IN_ADDRESS);
        }
        if (!this.address.canGrow()) {
            return this.resetStargate(Stargate.Feedback.INVALID_ADDRESS);
        }
        this.growAddress(symbol);
        this.chevronSound(false, incoming, false, encodeSound);
        if (!incoming) {
            this.updateBasicInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
            this.updateCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
        } else {
            this.updateBasicInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming);
            this.updateCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming);
        }
        this.updateAdvancedCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
        this.m_6596_();
        return Stargate.Feedback.SYMBOL_ENCODED;
    }

    protected Stargate.Feedback lockPrimaryChevron() {
        if (this.f_58857_.m_5776_()) {
            return Stargate.Feedback.NONE;
        }
        if (!this.address.isComplete()) {
            this.chevronSound(true, false, false, false);
            return this.resetStargate(Stargate.Feedback.INCOMPLETE_ADDRESS);
        }
        if (!this.isConnected()) {
            if (!this.isObstructed()) {
                this.chevronSound(true, false, false, false);
                this.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength() + 1, false, 0);
                return this.setRecentFeedback(this.engageStargate(this.getAddress(), true));
            }
            return this.resetStargate(Stargate.Feedback.SELF_OBSTRUCTED, false);
        }
        return this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT);
    }

    public void chevronSound(boolean primary, boolean incoming, boolean open, boolean encode) {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Chevron(this.f_58858_, primary, incoming, open, encode));
        }
    }

    public void openWormholeSound() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.OpenWormhole(this.f_58858_));
    }

    public void idleWormholeSound() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.IdleWormhole(this.f_58858_));
    }

    public void closeWormholeSound() {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.CloseWormhole(this.f_58858_));
        }
    }

    public abstract void playRotationSound();

    public abstract void stopRotationSound();

    public void playWormholeIdleSound() {
        this.wormholeIdleSound.playSound();
    }

    public Stargate.Feedback engageStargate(Address address, boolean doKawoosh) {
        return Dialing.dialStargate(this.f_58857_, this, address, doKawoosh);
    }

    public void connectStargate(String connectionID, ConnectionState connectionState) {
        this.connectionID = connectionID;
        this.setConnected(connectionState);
        ++this.timesOpened;
        this.animationTick = 0;
        this.m_6596_();
        this.updateStargate(false);
    }

    public static double kawooshFunction(int kawooshTime) {
        return 8.0 * Math.sin(Math.PI * (double)kawooshTime / 40.0);
    }

    public void doKawoosh(int kawooshTime) {
        this.setKawooshTickCount(kawooshTime);
        this.updateClient();
        if (kawooshTime > 40) {
            return;
        }
        Direction axisDirection = this.getDirection().m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        Direction direction = Orientation.getEffectiveDirection(this.getDirection(), this.getOrientation());
        double frontMultiplier = AbstractStargateEntity.kawooshFunction(kawooshTime);
        if (((Boolean)CommonStargateConfig.kawoosh_destroys_blocks.get()).booleanValue()) {
            this.destroyBlocks(frontMultiplier, axisDirection, direction);
        }
        if (((Boolean)CommonStargateConfig.kawoosh_disintegrates_entities.get()).booleanValue()) {
            this.disintegrateEntities(frontMultiplier, axisDirection, direction);
        }
    }

    protected void destroyBlocks(double frontMultiplier, Direction axisDirection, Direction direction) {
        BlockPos centerPos = this.getCenterPos();
        for (int width = -1; width <= 1; ++width) {
            for (int height = -1; height <= 1; ++height) {
                BlockPos pos = centerPos.m_5484_(axisDirection, width).m_5484_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.f_58857_.m_8055_(pos);
                if (state.m_60734_() instanceof AbstractStargateBlock) continue;
                for (int i = 0; i < (int)Math.round(frontMultiplier); ++i) {
                    BlockState relativeState;
                    BlockPos relativePos = pos.m_5484_(direction, i);
                    if (this.f_58857_.m_8055_(relativePos).m_60713_(Blocks.f_50016_) || (relativeState = this.f_58857_.m_8055_(relativePos)).m_204336_(TagInit.Blocks.KAWOOSH_IMMUNE)) continue;
                    this.f_58857_.m_46961_(relativePos, false);
                }
            }
        }
    }

    protected void disintegrateEntities(double frontMultiplier, Direction axisDirection, Direction direction) {
        Vec3 centerVector = this.getCenter();
        Vec3 backVector = centerVector.m_231075_(axisDirection, -2.25).m_231075_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), -2.25);
        frontMultiplier = frontMultiplier > 7.0 ? 7.0 : frontMultiplier;
        Vec3 facingVector = Orientation.getEffectiveVector(direction, this.getOrientation());
        facingVector = facingVector.m_82542_(frontMultiplier, frontMultiplier, frontMultiplier);
        facingVector = facingVector.m_82549_(centerVector);
        facingVector = facingVector.m_231075_(axisDirection, 2.25).m_231075_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), 2.25);
        AABB kawooshHitbox = new AABB(backVector.m_7096_(), backVector.m_7098_(), backVector.m_7094_(), facingVector.m_7096_(), facingVector.m_7098_(), facingVector.m_7094_());
        this.f_58857_.m_45976_(Entity.class, kawooshHitbox).stream().forEach(entity -> {
            if (this.shouldDisintegrate((Entity)entity)) {
                entity.m_6074_();
            }
        });
    }

    public boolean shouldDisintegrate(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return false;
        }
        if (!((Boolean)CommonStargateConfig.kawoosh_disintegrates_items.get()).booleanValue() && entity instanceof ItemEntity) {
            return false;
        }
        return !entity.m_6095_().m_204039_(TagInit.Entities.KAWOOSH_IMMUNE);
    }

    public Stargate.Feedback resetStargate(Stargate.Feedback feedback, boolean updateInterfaces) {
        if (this.isConnected()) {
            this.closeWormholeSound();
            this.setConnected(ConnectionState.IDLE);
        }
        this.resetAddress(updateInterfaces);
        this.connectionID = "sgjourney:empty";
        this.setKawooshTickCount(0);
        this.setTickCount(0);
        this.updateClient();
        if (feedback.playFailSound() && !this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Fail(this.f_58858_));
        }
        this.updateBasicInterfaceBlocks(EVENT_RESET, feedback.getCode());
        this.updateCrystalInterfaceBlocks(EVENT_RESET, feedback.getCode(), feedback.getMessage());
        this.updateAdvancedCrystalInterfaceBlocks(EVENT_RESET, feedback.getCode(), feedback.getMessage());
        this.m_6596_();
        StargateJourney.LOGGER.info("Reset Stargate at " + this.m_58899_().m_123341_() + " " + this.m_58899_().m_123342_() + " " + this.m_58899_().m_123343_() + " " + this.m_58904_().m_46472_().m_135782_().toString() + " " + feedback.getMessage());
        return this.setRecentFeedback(feedback);
    }

    public Stargate.Feedback resetStargate(Stargate.Feedback feedback) {
        return this.resetStargate(feedback, true);
    }

    public Stargate.Feedback disconnectStargate(Stargate.Feedback feedback) {
        if (this.isConnected()) {
            if (!((Boolean)CommonStargateConfig.end_connection_from_both_ends.get()).booleanValue() && !this.isDialingOut()) {
                return Stargate.Feedback.WRONG_DISCONNECT_SIDE;
            }
            if (this.getOpenTime() <= 0) {
                return Stargate.Feedback.CONNECTION_FORMING;
            }
        }
        return this.bypassDisconnectStargate(feedback);
    }

    public Stargate.Feedback bypassDisconnectStargate(Stargate.Feedback feedback) {
        if (this.connectionID != null && !this.connectionID.equals("sgjourney:empty")) {
            StargateNetwork.get(this.f_58857_).terminateConnection(this.f_58857_.m_7654_(), this.connectionID, feedback);
        }
        return this.resetStargate(feedback, false);
    }

    public void updateStargate(boolean updateInterfaces) {
        this.updateStargate(this.f_58857_, this.getID(), this.timesOpened, this.hasDHD, updateInterfaces);
    }

    private void updateStargate(Level level, String id, int timesOpened, boolean hasDHD, boolean updateInterfaces) {
        StargateNetwork.get(level).updateStargate(level, id, timesOpened, hasDHD);
        this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), updateInterfaces);
    }

    protected void growAddress(int symbol) {
        this.address.addSymbol(symbol);
        this.setStargateState(this.getConnectionState(), this.getChevronsEngaged(), true);
        this.updateClient();
    }

    protected void resetAddress(boolean updateInterfaces) {
        this.address.reset();
        this.engagedChevrons = Dialing.DEFAULT_CHEVRON_CONFIGURATION;
        this.setStargateState(ConnectionState.IDLE, 0, updateInterfaces);
    }

    public String getConnectionAddress(int addressLength) {
        String dimension = this.f_58857_.m_46472_().m_135782_().toString();
        switch (addressLength) {
            case 6: {
                String galaxy = (String)Universe.get(this.f_58857_).getGalaxiesFromDimension(dimension).m_128728_(0).m_128431_().iterator().next();
                return Universe.get(this.f_58857_).getAddressInGalaxyFromDimension(galaxy, dimension);
            }
            case 7: {
                return Universe.get(this.f_58857_).getExtragalacticAddressFromDimension(dimension);
            }
        }
        return this.getID();
    }

    public Stargate.Feedback setRecentFeedback(Stargate.Feedback feedback) {
        this.recentFeedback = feedback;
        return this.getRecentFeedback();
    }

    public Stargate.Feedback getRecentFeedback() {
        return this.recentFeedback;
    }

    public void setPointOfOrigin(Level level) {
        this.pointOfOrigin = Universe.get(level).getPointOfOrigin(level.m_46472_().m_135782_().toString());
        this.m_6596_();
    }

    protected boolean isPointOfOriginValid(Level level) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
        if (!this.isLocationValid(this.pointOfOrigin)) {
            return false;
        }
        return pointOfOriginRegistry.m_7804_(new ResourceLocation(this.pointOfOrigin));
    }

    public void setSymbols(Level level) {
        this.symbols = Universe.get(level).getSymbols(level.m_46472_().m_135782_().toString());
        this.m_6596_();
    }

    protected boolean areSymbolsValid(Level level) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry symbolRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
        if (!this.isLocationValid(this.symbols)) {
            return false;
        }
        return symbolRegistry.m_7804_(new ResourceLocation(this.symbols));
    }

    private boolean isLocationValid(String location) {
        String[] split = location.split(":");
        if (split.length != 2) {
            return false;
        }
        if (!ResourceLocation.m_135843_((String)split[0])) {
            return false;
        }
        return ResourceLocation.m_135841_((String)split[1]);
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int network) {
        this.network = network;
    }

    public boolean getRestrictNetwork() {
        return this.restrictNetwork;
    }

    public void setRestrictNetwork(boolean restrictNetwork) {
        this.restrictNetwork = restrictNetwork;
    }

    public boolean isRestricted(AbstractStargateEntity dialingStargate) {
        if (this.getRestrictNetwork()) {
            return dialingStargate.getNetwork() != this.getNetwork();
        }
        return false;
    }

    public int getMaxGateOpenTime() {
        return (Integer)CommonStargateConfig.max_wormhole_open_time.get() * 20;
    }

    public Stargate.Gen getGeneration() {
        return this.generation;
    }

    public void setKawooshTickCount(int kawooshTick) {
        this.kawooshTick = kawooshTick;
    }

    public int getKawooshTickCount() {
        return this.kawooshTick;
    }

    public void setTickCount(int animationTick) {
        this.animationTick = animationTick;
    }

    public int getTickCount() {
        return this.animationTick;
    }

    public int increaseTickCount() {
        ++this.animationTick;
        return this.animationTick;
    }

    public void setDHD(boolean hasDHD, boolean enableAdvancedProtocols) {
        if (this.hasDHD != hasDHD) {
            this.updateStargate(this.f_58857_, this.getID(), this.timesOpened, hasDHD, false);
        }
        this.advancedProtocolsEnabled = hasDHD ? enableAdvancedProtocols : false;
        this.hasDHD = hasDHD;
    }

    public boolean advancedProtocolsEnabled() {
        return this.advancedProtocolsEnabled;
    }

    public boolean hasDHD() {
        return this.hasDHD;
    }

    public int getOpenTime() {
        if (this.f_58857_.m_5776_()) {
            return 0;
        }
        return StargateNetwork.get(this.f_58857_).getOpenTime(this.connectionID);
    }

    public int getTimeSinceLastTraveler() {
        if (this.f_58857_.m_5776_()) {
            return 0;
        }
        return StargateNetwork.get(this.f_58857_).getTimeSinceLastTraveler(this.connectionID);
    }

    public int getTimesOpened() {
        return this.timesOpened;
    }

    public void setPointOfOrigin(String pointOfOrigin) {
        this.pointOfOrigin = pointOfOrigin;
        this.m_6596_();
    }

    public String getPointOfOrigin() {
        return this.pointOfOrigin;
    }

    public void setSymbols(String symbols) {
        this.symbols = symbols;
        this.m_6596_();
    }

    public String getSymbols() {
        return this.symbols;
    }

    public void setVariant(String variant) {
        this.variant = variant;
        this.m_6596_();
    }

    public String getVariant() {
        return this.variant;
    }

    public void setAddress(Address address) {
        this.address = address;
        this.m_6596_();
    }

    public Address getAddress() {
        return this.address;
    }

    public int getChevronsEngaged() {
        int chevronsEngaged = this.address.getLength();
        return this.isConnected() ? chevronsEngaged + 1 : chevronsEngaged;
    }

    public void setEngagedChevrons(int[] engagedChevrons) {
        this.engagedChevrons = engagedChevrons;
    }

    public static int[] getChevronConfiguration(int addressLength) {
        switch (addressLength) {
            case 6: {
                return Dialing.DIALED_7_CHEVRON_CONFIGURATION;
            }
            case 7: {
                return Dialing.DIALED_8_CHEVRON_CONFIGURATION;
            }
            case 8: {
                return Dialing.DIALED_9_CHEVRON_CONFIGURATION;
            }
        }
        return Dialing.DEFAULT_CHEVRON_CONFIGURATION;
    }

    public int[] getEngagedChevrons() {
        return this.engagedChevrons;
    }

    public int chevronsRendered() {
        return this.address.getLength();
    }

    public BlockPos getCenterPos() {
        if (this.centerPosition == null) {
            BlockPos mainBlockPos = this.m_58899_();
            Direction centerDirection = Orientation.getCenterDirection(this.getDirection(), this.getOrientation());
            this.centerPosition = mainBlockPos.m_5484_(centerDirection, 3);
        }
        return this.centerPosition;
    }

    public Vec3 getCenter() {
        BlockPos centerPos = this.getCenterPos();
        double y = this.getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = this.getHorizontalCenterHeight();
        }
        return new Vec3((double)centerPos.m_123341_() + 0.5, (double)centerPos.m_123342_() + y, (double)centerPos.m_123343_() + 0.5);
    }

    public Vec3 getRelativeCenter() {
        BlockPos mainBlockPos = this.m_58899_();
        BlockPos centerPos = this.getCenterPos();
        double y = this.getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = this.getHorizontalCenterHeight();
        }
        return new Vec3((double)(centerPos.m_123341_() - mainBlockPos.m_123341_()) + 0.5, (double)(centerPos.m_123342_() - mainBlockPos.m_123342_()) + y, (double)(centerPos.m_123343_() - mainBlockPos.m_123343_()) + 0.5);
    }

    protected BlockState getState() {
        BlockPos gatePos = this.m_58899_();
        return this.f_58857_.m_8055_(gatePos);
    }

    public Orientation getOrientation() {
        if (this.orientation == null) {
            BlockState gateState = this.getState();
            if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
                this.orientation = (Orientation)((Object)gateState.m_61143_((Property)AbstractStargateBaseBlock.ORIENTATION));
            } else {
                StargateJourney.LOGGER.error("Couldn't find Stargate Orientation");
            }
        }
        return this.orientation;
    }

    public Direction getDirection() {
        if (this.direction == null) {
            BlockState gateState = this.getState();
            if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
                this.direction = (Direction)gateState.m_61143_((Property)AbstractStargateBaseBlock.FACING);
            } else {
                StargateJourney.LOGGER.error("Couldn't find Stargate Direction");
            }
        }
        return this.direction;
    }

    public void setConnected(ConnectionState connectionState) {
        this.setStargateState(connectionState, this.getChevronsEngaged(), true);
    }

    public void setStargateState(ConnectionState connectionState, int chevronsEngaged, boolean updateInterfaces) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargate = (AbstractStargateBaseBlock)block;
            stargate.updateStargate(this.f_58857_, gatePos, gateState, connectionState, chevronsEngaged);
            if (updateInterfaces) {
                this.updateInterfaceBlocks(null, new Object[0]);
            }
        } else {
            StargateJourney.LOGGER.error("Couldn't find Stargate");
        }
        this.m_6596_();
    }

    public ConnectionState getConnectionState() {
        BlockState gateState = this.getState();
        if (gateState.m_60734_() instanceof AbstractStargateBaseBlock) {
            return (ConnectionState)((Object)gateState.m_61143_((Property)AbstractStargateBaseBlock.CONNECTION_STATE));
        }
        return ConnectionState.IDLE;
    }

    public boolean isConnected() {
        return this.getConnectionState().isConnected();
    }

    public boolean isDialingOut() {
        return this.getConnectionState().isDialingOut();
    }

    public boolean isObstructed() {
        Direction direction = this.getDirection().m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        BlockPos centerPos = this.getCenterPos();
        int obstructingBlocks = 0;
        for (int width = -2; width <= 2; ++width) {
            for (int height = -2; height <= 2; ++height) {
                BlockPos pos = centerPos.m_5484_(direction, width).m_5484_(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.f_58857_.m_8055_(pos);
                if ((state.m_247087_() || state.m_60734_() instanceof AbstractStargateBlock) && !state.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) continue;
                ++obstructingBlocks;
            }
        }
        return obstructingBlocks >= (Integer)CommonStargateConfig.max_obstructive_blocks.get();
    }

    public void updateBasicInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.m_121945_(direction);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (!(blockEntity instanceof BasicInterfaceEntity)) continue;
                    BasicInterfaceEntity interfaceEntity = (BasicInterfaceEntity)blockEntity;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
                    interfaceEntity.m_6596_();
                }
            }
        }
    }

    public void updateCrystalInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.m_121945_(direction);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (!(blockEntity instanceof CrystalInterfaceEntity)) continue;
                    CrystalInterfaceEntity interfaceEntity = (CrystalInterfaceEntity)blockEntity;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
                    interfaceEntity.m_6596_();
                }
            }
        }
    }

    public void updateAdvancedCrystalInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.getState();
        Block block = gateState.m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.m_61143_(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.m_121945_(direction);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (!(blockEntity instanceof AdvancedCrystalInterfaceEntity)) continue;
                    AdvancedCrystalInterfaceEntity interfaceEntity = (AdvancedCrystalInterfaceEntity)blockEntity;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
                    interfaceEntity.m_6596_();
                }
            }
        }
    }

    public void updateInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        this.updateBasicInterfaceBlocks(eventName, objects);
        this.updateCrystalInterfaceBlocks(eventName, objects);
        this.updateAdvancedCrystalInterfaceBlocks(eventName, objects);
    }

    public Wormhole getWormhole() {
        return this.wormhole;
    }

    public void setOpenSoundLead(int openSoundLead) {
        this.openSoundLead = openSoundLead;
    }

    public int getOpenSoundLead() {
        return this.openSoundLead;
    }

    public abstract Stargate.ChevronLockSpeed getChevronLockSpeed();

    public abstract SoundEvent getRotationSound();

    public abstract SoundEvent getChevronEngageSound();

    public SoundEvent getChevronIncomingSound() {
        return this.getChevronEngageSound();
    }

    public abstract SoundEvent getWormholeOpenSound();

    public SoundEvent getWormholeIdleSound() {
        return (SoundEvent)SoundInit.WORMHOLE_IDLE.get();
    }

    public abstract SoundEvent getWormholeCloseSound();

    public abstract SoundEvent getFailSound();

    @Override
    public void getStatus(Player player) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.point_of_origin").m_7220_((Component)Component.m_237113_((String)(": " + this.pointOfOrigin))).m_130940_(ChatFormatting.DARK_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.symbols").m_7220_((Component)Component.m_237113_((String)(": " + this.symbols))).m_130940_(ChatFormatting.LIGHT_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.open_time").m_7220_((Component)Component.m_237113_((String)(": " + this.getOpenTime() + "/" + this.getMaxGateOpenTime()))).m_130940_(ChatFormatting.DARK_AQUA));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.times_opened").m_7220_((Component)Component.m_237113_((String)(": " + this.timesOpened))).m_130940_(ChatFormatting.BLUE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.has_dhd").m_7220_((Component)Component.m_237113_((String)(": " + this.hasDHD))).m_130940_(ChatFormatting.GOLD));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.advanced_protocols_enabled").m_7220_((Component)Component.m_237113_((String)(": " + this.advancedProtocolsEnabled))).m_130940_(ChatFormatting.RED));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.last_traveler_time").m_7220_((Component)Component.m_237113_((String)(": " + this.getTimeSinceLastTraveler()))).m_130940_(ChatFormatting.DARK_PURPLE));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.address").m_7220_((Component)Component.m_237113_((String)(": " + this.address.toString()))).m_130940_(ChatFormatting.GREEN));
        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.recent_feedback").m_7220_((Component)Component.m_237113_((String)": ").m_7220_(this.getRecentFeedback().getFeedbackMessage())).m_130940_(ChatFormatting.WHITE));
        super.getStatus(player);
    }

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return false;
    }

    @Override
    public long capacity() {
        return (Long)CommonStargateConfig.stargate_energy_capacity.get();
    }

    @Override
    public long maxReceive() {
        return (Long)CommonStargateConfig.stargate_energy_max_receive.get();
    }

    @Override
    public long maxExtract() {
        return (Long)CommonStargateConfig.intergalactic_connection_energy_cost.get();
    }

    public float getVerticalCenterHeight() {
        return this.verticalCenterHeight;
    }

    public float getHorizontalCenterHeight() {
        return this.horizontalCenterHeight;
    }

    public double getGateAddition() {
        return this.getOrientation() == Orientation.REGULAR ? (double)this.getVerticalCenterHeight() : (double)this.getHorizontalCenterHeight();
    }

    public abstract void registerInterfaceMethods(StargatePeripheralWrapper var1);

    public void doWhileDialed(int openTime, Stargate.ChevronLockSpeed chevronLockSpeed) {
    }

    public void updateClient() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundStargateUpdatePacket(this.f_58858_, this.address.toArray(), this.engagedChevrons, this.kawooshTick, this.animationTick, this.pointOfOrigin, this.symbols, this.variant));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractStargateEntity stargate) {
        if (stargate.isConnected()) {
            stargate.increaseTickCount();
        }
        if (level.m_5776_()) {
            return;
        }
        stargate.updateClient();
    }
}

