/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.capabilities.ZeroPointEnergy;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import org.jetbrains.annotations.NotNull;

public class ZPMHubEntity
extends EnergyBlockEntity {
    private static final long maxTransfer = (Long)CommonZPMConfig.zpm_hub_max_transfer.get();
    private static final long maxEnergyDisplayed = (Long)CommonZPMConfig.zpm_energy_per_level_of_entropy.get();
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();

    public ZPMHubEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.ZPM_HUB.get(), pos, state);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("Inventory"));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                ZPMHubEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.m_41720_() == ItemInit.ZPM.get();
                    }
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return side == Direction.DOWN;
    }

    @Override
    protected boolean receivesEnergy() {
        return false;
    }

    @Override
    public long capacity() {
        return maxEnergyDisplayed;
    }

    @Override
    public long maxReceive() {
        return 0L;
    }

    @Override
    public long maxExtract() {
        return maxTransfer;
    }

    @Override
    public void outputEnergy(Direction outputDirection) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.m_150930_((Item)ItemInit.ZPM.get())) {
            stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                if (energy instanceof ZeroPointEnergy) {
                    ZeroPointEnergy zpmEnergy = (ZeroPointEnergy)((Object)energy);
                    BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(outputDirection));
                    if (blockEntity == null) {
                        return;
                    }
                    blockEntity.getCapability(ForgeCapabilities.ENERGY, outputDirection.m_122424_()).ifPresent(blockEntityEnergy -> {
                        if (blockEntityEnergy instanceof SGJourneyEnergy) {
                            SGJourneyEnergy sgjourneyEnergy = (SGJourneyEnergy)((Object)((Object)blockEntityEnergy));
                            long simulatedOutputAmount = zpmEnergy.extractLongEnergy(this.maxExtract(), true);
                            long simulatedReceiveAmount = sgjourneyEnergy.receiveLongEnergy(simulatedOutputAmount, true);
                            zpmEnergy.extractLongEnergy(simulatedReceiveAmount, false);
                            sgjourneyEnergy.receiveLongEnergy(simulatedReceiveAmount, false);
                        } else {
                            int simulatedOutputAmount = zpmEnergy.extractEnergy(SGJourneyEnergy.getRegularEnergy(this.maxExtract()), true);
                            int simulatedReceiveAmount = blockEntityEnergy.receiveEnergy(simulatedOutputAmount, true);
                            zpmEnergy.extractLongEnergy(simulatedReceiveAmount, false);
                            blockEntityEnergy.receiveEnergy(simulatedReceiveAmount, false);
                        }
                    });
                }
            });
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ZPMHubEntity hub) {
        if (level.f_46443_) {
            return;
        }
        hub.outputEnergy(Direction.DOWN);
    }
}

