/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import java.util.List;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.SGJourneyBlockEntity;
import net.povstalec.sgjourney.common.blocks.TransportRingsBlock;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundRingsUpdatePacket;

public class TransportRingsEntity
extends SGJourneyBlockEntity {
    ItemStack stack0;
    ItemStack stack1;
    ItemStack stack2;
    private BlockPos transportPos;
    private BlockPos targetPos;
    public boolean isSender;
    public int emptySpace = 0;
    public int ticks;
    public int progressOld = 0;
    public int progress = 0;
    public int transportHeight = 0;
    public int transportLight;
    private TransportRingsEntity target;

    public TransportRingsEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.TRANSPORT_RINGS.get(), pos, state, SGJourneyBlockEntity.Type.TRANSPORT_RINGS);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public CompoundTag addNewToBlockEntityList() {
        CompoundTag blockEntity = super.addNewToBlockEntityList();
        TransporterNetwork.get(this.f_58857_).addToNetwork(this.getID(), BlockEntityList.get(this.f_58857_).getBlockEntities("TransportRings").m_128469_(this.getID()));
        return blockEntity;
    }

    @Override
    public CompoundTag addToBlockEntityList() {
        CompoundTag blockEntity = super.addToBlockEntityList();
        TransporterNetwork.get(this.f_58857_).addToNetwork(this.getID(), BlockEntityList.get(this.f_58857_).getBlockEntities("TransportRings").m_128469_(this.getID()));
        return blockEntity;
    }

    @Override
    public void removeFromBlockEntityList() {
        super.removeFromBlockEntityList();
        TransporterNetwork.get(this.f_58857_).removeFromNetwork(this.f_58857_, this.getID());
    }

    public boolean canTransport() {
        return !this.isActivated();
    }

    private void activate(BlockPos targetPos, boolean isSender) {
        this.target = (TransportRingsEntity)this.f_58857_.m_7702_(targetPos);
        if (!(targetPos.equals((Object)this.m_58899_()) || this.isActivated() || this.target.isActivated())) {
            if (isSender) {
                this.target.activate(this.m_58899_(), false);
                this.isSender = true;
            } else {
                this.target.isSender = false;
            }
            this.setActivated(true);
            this.emptySpace = this.getEmptySpace();
            this.transportPos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + this.emptySpace, this.m_58899_().m_123343_());
            int difference = Math.abs(this.getTransportHeight() - this.target.getTransportHeight());
            this.ticks = this.transportHeight >= this.target.transportHeight ? 0 : -difference;
            this.progress = 0;
            this.targetPos = targetPos;
            this.target = (TransportRingsEntity)this.f_58857_.m_7702_(targetPos);
            if (this.f_58857_.m_5776_()) {
                this.transportLight = LevelRenderer.m_109541_((BlockAndTintGetter)this.f_58857_, (BlockPos)this.transportPos);
            }
            this.loadChunk(true);
        } else {
            this.target = null;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundRingsUpdatePacket(this.m_58899_(), this.emptySpace, this.transportHeight, this.transportLight));
    }

    public int getTransportHeight() {
        this.transportHeight = this.getEmptySpace() > 0 ? Math.abs(this.getEmptySpace() * 4) + 8 : Math.abs(this.getEmptySpace() * 4) - 2;
        return this.transportHeight;
    }

    public void activate(BlockPos targetPos) {
        this.activate(targetPos, true);
    }

    public void deactivate() {
        this.isSender = false;
        this.setActivated(false);
        this.ticks = 0;
        this.progressOld = 0;
        this.progress = 0;
        this.loadChunk(false);
    }

    private void loadChunk(boolean load) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        ForgeChunkManager.forceChunk((ServerLevel)this.f_58857_.m_7654_().m_129880_(this.f_58857_.m_46472_()), (String)"sgjourney", (BlockPos)this.m_58899_(), (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45578_, (int)this.f_58857_.m_46865_((BlockPos)this.m_58899_()).m_7697_().f_45579_, (boolean)load, (boolean)true);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TransportRingsEntity rings) {
        if (rings.isActivated()) {
            ++rings.ticks;
        }
        rings.doProgress();
        if (rings.ticks > 0 && rings.progress <= 0) {
            rings.deactivate();
        }
        if (level.m_5776_()) {
            return;
        }
        if (rings.ticks == rings.transportHeight + 22 && rings.isSender && level.m_7702_(rings.targetPos) instanceof TransportRingsEntity) {
            rings.startTransporting();
        }
    }

    private void doProgress() {
        this.progressOld = this.progress;
        if (this.ticks > 0 && this.ticks <= this.transportHeight + 17) {
            this.progress = this.ticks;
        } else if (this.ticks >= this.transportHeight + 42 && this.progress > 0) {
            --this.progress;
        }
    }

    public void setProgress(int progress) {
        this.progressOld = this.progress;
        this.progress = progress;
    }

    public float getProgress(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.progress : Mth.m_14179_((float)partialTick, (float)this.progressOld, (float)this.progress);
    }

    public void getStatus() {
        System.out.println("ID: " + this.getID());
        if (this.m_58899_() != null) {
            System.out.println("Pos: " + this.m_58899_().m_123341_() + " " + this.m_58899_().m_123342_() + " " + this.m_58899_().m_123343_());
        }
        if (this.targetPos != null) {
            System.out.println("Target: " + this.targetPos.m_123341_() + " " + this.targetPos.m_123342_() + " " + this.targetPos.m_123343_());
        }
        if (this.transportPos != null) {
            System.out.println("Transport: " + this.transportPos.m_123341_() + " " + this.transportPos.m_123342_() + " " + this.transportPos.m_123343_());
        }
        System.out.println("Sending: " + this.isSender);
        System.out.println("Ticks: " + this.ticks);
    }

    private void startTransporting() {
        AABB localBox = new AABB((double)(this.transportPos.m_123341_() - 1), (double)this.transportPos.m_123342_(), (double)(this.transportPos.m_123343_() - 1), (double)(this.transportPos.m_123341_() + 2), (double)(this.transportPos.m_123342_() + 3), (double)(this.transportPos.m_123343_() + 2));
        List localEntities = this.f_58857_.m_45976_(Entity.class, localBox);
        AABB targetBox = new AABB((double)(this.target.transportPos.m_123341_() - 1), (double)this.target.transportPos.m_123342_(), (double)(this.target.transportPos.m_123343_() - 1), (double)(this.target.transportPos.m_123341_() + 2), (double)(this.target.transportPos.m_123342_() + 3), (double)(this.target.transportPos.m_123343_() + 2));
        List targetEntities = this.f_58857_.m_45976_(Entity.class, targetBox);
        if (!localEntities.isEmpty()) {
            localEntities.stream().forEach(this::transportToTarget);
        }
        if (!targetEntities.isEmpty()) {
            targetEntities.stream().forEach(this::transportFromTarget);
        }
    }

    private void transportToTarget(Entity entity) {
        double x_offset = entity.m_20185_() - (double)this.transportPos.m_123341_();
        double y_offset = entity.m_20186_() - (double)this.transportPos.m_123342_();
        double z_offset = entity.m_20189_() - (double)this.transportPos.m_123343_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_6021_((double)this.target.transportPos.m_123341_() + x_offset, (double)this.target.transportPos.m_123342_() + y_offset, (double)this.target.transportPos.m_123343_() + z_offset);
        } else {
            entity.m_6021_((double)this.target.transportPos.m_123341_() + x_offset, (double)this.target.transportPos.m_123342_() + y_offset, (double)this.target.transportPos.m_123343_() + z_offset);
        }
        System.out.println("Transporting to target: " + entity.toString());
    }

    private void transportFromTarget(Entity entity) {
        double x_offset = entity.m_20185_() - (double)this.target.transportPos.m_123341_();
        double y_offset = entity.m_20186_() - (double)this.target.transportPos.m_123342_();
        double z_offset = entity.m_20189_() - (double)this.target.transportPos.m_123343_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_6021_((double)this.transportPos.m_123341_() + x_offset, (double)this.transportPos.m_123342_() + y_offset, (double)this.transportPos.m_123343_() + z_offset);
        } else {
            entity.m_6021_((double)this.transportPos.m_123341_() + x_offset, (double)this.transportPos.m_123342_() + y_offset, (double)this.transportPos.m_123343_() + z_offset);
        }
        System.out.println("Transporting from target: " + entity.toString());
    }

    public boolean isActivated() {
        BlockPos pos = this.m_58899_();
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60713_((Block)BlockInit.TRANSPORT_RINGS.get())) {
            return (Boolean)this.f_58857_.m_8055_(pos).m_61143_((Property)TransportRingsBlock.ACTIVATED);
        }
        return false;
    }

    public void setActivated(boolean active) {
        BlockPos pos = this.m_58899_();
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60713_((Block)BlockInit.TRANSPORT_RINGS.get())) {
            this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)TransportRingsBlock.ACTIVATED, (Comparable)Boolean.valueOf(active)), 2);
        }
    }

    private int getEmptySpace() {
        BlockPos pos = this.m_58899_();
        BlockState state = this.f_58857_.m_8055_(pos);
        if (!state.m_60713_((Block)BlockInit.TRANSPORT_RINGS.get())) {
            return 0;
        }
        if (state.m_61143_((Property)TransportRingsBlock.FACING) == Direction.DOWN) {
            for (int i = 4; i <= 16; ++i) {
                if (this.f_58857_.m_8055_(pos.m_6625_(i)).m_247087_() || !this.f_58857_.m_8055_(pos.m_6625_(i - 1)).m_247087_() || !this.f_58857_.m_8055_(pos.m_6625_(i - 2)).m_247087_() || !this.f_58857_.m_8055_(pos.m_6625_(i - 3)).m_247087_()) continue;
                return -i + 1;
            }
        } else {
            for (int i = 1; i <= 16; ++i) {
                if (!this.f_58857_.m_8055_(pos.m_6630_(i)).m_247087_() || !this.f_58857_.m_8055_(pos.m_6630_(i + 1)).m_247087_() || !this.f_58857_.m_8055_(pos.m_6630_(i + 2)).m_247087_()) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public long capacity() {
        return 0L;
    }

    @Override
    public long maxReceive() {
        return 0L;
    }

    @Override
    public long maxExtract() {
        return 0L;
    }
}

