/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.AbstractStargateModel;
import net.povstalec.sgjourney.client.models.SGJourneyModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargateVariant;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class UniverseStargateModel
extends AbstractStargateModel<UniverseStargateEntity> {
    protected static final int UNIVERSE_SIDES = 54;
    protected static final float UNIVERSE_ANGLE = 6.6666665f;
    protected static final float STARGATE_SYMBOL_RING_OUTER_HEIGHT = 3.1875f;
    protected static final float STARGATE_SYMBOL_RING_INNER_HEIGHT = 2.6875f;
    protected static final float STARGATE_SYMBOL_RING_OUTER_LENGTH = SGJourneyModel.getUsedWidth(54, 3.1875f, 3.5f);
    protected static final float STARGATE_SYMBOL_RING_OUTER_CENTER = STARGATE_SYMBOL_RING_OUTER_LENGTH / 2.0f;
    protected static final float STARGATE_SYMBOL_RING_INNER_LENGTH = SGJourneyModel.getUsedWidth(54, 2.6875f, 3.5f);
    protected static final float STARGATE_SYMBOL_RING_INNER_CENTER = STARGATE_SYMBOL_RING_INNER_LENGTH / 2.0f;
    protected static final float STARGATE_RING_FRONT_THICKNESS = 3.0f;
    protected static final float STARGATE_RING_BACK_THICKNESS = 4.0f;
    protected static final float STARGATE_RING_OFFSET = 0.21875f;
    protected static final float STARGATE_RING_DIVIDE_OFFSET = 0.03125f;
    protected static final float SYMBOL_OFFSET = 0.21975f;
    protected static final float STARGATE_RING_OUTER_RADIUS = 3.499f;
    protected static final float STARGATE_RING_OUTER_LENGTH = SGJourneyModel.getUsedWidth(54, 3.499f, 3.5f);
    protected static final float STARGATE_RING_OUTER_CENTER = STARGATE_RING_OUTER_LENGTH / 2.0f;
    protected static final float STARGATE_RING_STOP_RADIUS = 3.0625f;
    protected static final float STARGATE_RING_STOP_LENGTH = SGJourneyModel.getUsedWidth(54, 3.0625f, 3.5f);
    protected static final float STARGATE_RING_STOP_CENTER = STARGATE_RING_STOP_LENGTH / 2.0f;
    protected static final float STARGATE_RING_INNER_HEIGHT = 2.501f;
    protected static final float STARGATE_RING_INNER_LENGTH = SGJourneyModel.getUsedWidth(54, 2.501f, 3.5f);
    protected static final float STARGATE_RING_INNER_CENTER = STARGATE_RING_INNER_LENGTH / 2.0f;
    protected static final float STARGATE_RING_HEIGHT = 0.99800014f;
    protected static final float STARGATE_SYMBOL_RING_HEIGHT = 0.5f;
    protected static final float CHEVRON_LIGHT_THICKNESS = 0.0625f;
    protected static final float CHEVRON_LIGHT_Z_OFFSET = 0.28125f;
    protected static final float CHEVRON_LIGHT_TOP_LENGTH = 0.25f;
    protected static final float CHEVRON_LIGHT_TOP_CENTER = 0.125f;
    protected static final float CHEVRON_LIGHT_TOP_HEIGHT = 0.3125f;
    protected static final float CHEVRON_LIGHT_MID1_LENGTH = 0.375f;
    protected static final float CHEVRON_LIGHT_MID1_CENTER = 0.1875f;
    protected static final float CHEVRON_LIGHT_MID1_HEIGHT = 0.25f;
    protected static final float CHEVRON_LIGHT_MID2_LENGTH = 0.1875f;
    protected static final float CHEVRON_LIGHT_MID2_CENTER = 0.09375f;
    protected static final float CHEVRON_LIGHT_MID2_HEIGHT = 0.125f;
    protected static final float CHEVRON_LIGHT_BOTTOM_LENGTH = 0.0625f;
    protected static final float CHEVRON_LIGHT_BOTTOM_CENTER = 0.03125f;
    protected static final float CHEVRON_LIGHT_BOTTOM_HEIGHT = 0.0f;
    protected static final float OUTER_CHEVRON_THICKNESS = 0.03125f;
    protected static final float OUTER_CHEVRON_Z_OFFSET = 0.25f;
    private float rotation = 0.0f;
    protected static final float DEFAULT_DISTANCE_FROM_CENTER = 56.0f;
    protected static final int BOXES_PER_RING = 36;

    public UniverseStargateModel() {
        super(new ResourceLocation("sgjourney", "universe"), (short)36);
        this.symbolColor = new Stargate.RGBA(21, 9, 0, 255);
        this.engagedSymbolColor = new Stargate.RGBA(200, 220, 255, 255);
    }

    protected boolean useAlternateModel(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent() && stargateVariant.get().useAlternateModel().isPresent()) {
            return stargateVariant.get().useAlternateModel().get();
        }
        return ClientStargateConfig.universe_front_rotates.get();
    }

    public float getRotation(boolean shouldRotate) {
        return shouldRotate ? this.rotation : 0.0f;
    }

    @Override
    protected boolean symbolsGlow(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, boolean isEngaged) {
        if (stargateVariant.isPresent()) {
            if (isEngaged) {
                if (!stargate.isConnected() && stargateVariant.get().encodedSymbolsGlow().isPresent()) {
                    return stargateVariant.get().encodedSymbolsGlow().get();
                }
                if (stargateVariant.get().engagedSymbolsGlow().isPresent()) {
                    return stargateVariant.get().engagedSymbolsGlow().get();
                }
            }
            if (!isEngaged && stargateVariant.get().symbolsGlow().isPresent()) {
                return stargateVariant.get().symbolsGlow().get();
            }
        }
        return isEngaged;
    }

    @Override
    protected boolean engageEncodedSymbols(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent() && stargateVariant.get().engageEncodedSymbols().isPresent()) {
            return stargateVariant.get().engageEncodedSymbols().get();
        }
        return true;
    }

    @Override
    protected Stargate.RGBA getSymbolColor(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, boolean isEngaged) {
        if (stargateVariant.isPresent()) {
            if (isEngaged) {
                if (!stargate.isConnected() && stargateVariant.get().getEncodedSymbolRGBA().isPresent()) {
                    return stargateVariant.get().getEncodedSymbolRGBA().get();
                }
                if (stargateVariant.get().getEngagedSymbolRGBA().isPresent()) {
                    return stargateVariant.get().getEngagedSymbolRGBA().get();
                }
            } else if (!isEngaged && stargateVariant.get().getSymbolRGBA().isPresent()) {
                return stargateVariant.get().getSymbolRGBA().get();
            }
        }
        return isEngaged ? this.engagedSymbolColor : this.symbolColor;
    }

    @Override
    public void renderRing(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, float partialTick, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderOuterRingFront(stargate, stargateVariant, stack, consumer, source, combinedLight, combinedOverlay);
        this.renderOuterRingBack(stargate, stargateVariant, stack, consumer, source, combinedLight, combinedOverlay);
        this.renderSymbols(stargate, stargateVariant, stack, consumer, source, combinedLight, this.getRotation(true));
    }

    protected void renderOuterRingFront(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        for (int j = 0; j < 54; ++j) {
            stack.m_85836_();
            stack.m_252781_(Axis.f_252403_.m_252977_((float)j * 6.6666665f - 3.3333333f + this.getRotation(true)));
            Matrix4f matrix4 = stack.m_85850_().m_252922_();
            Matrix3f matrix3 = stack.m_85850_().m_252943_();
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -STARGATE_RING_OUTER_CENTER, 3.499f, 0.03125f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0625f, -STARGATE_RING_OUTER_CENTER, 3.499f, 0.21875f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.109375f, STARGATE_RING_OUTER_CENTER, 3.499f, 0.21875f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.109375f, STARGATE_RING_OUTER_CENTER, 3.499f, 0.03125f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0625f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -STARGATE_RING_OUTER_CENTER, 3.499f, 0.21875f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.10962498f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.21875f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.35912502f, STARGATE_RING_INNER_CENTER, 2.501f, 0.21875f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.35912502f, STARGATE_RING_OUTER_CENTER, 3.499f, 0.21875f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.10962498f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.21875f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.734375f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.03125f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.6875f, STARGATE_RING_INNER_CENTER, 2.501f, 0.03125f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.6875f, STARGATE_RING_INNER_CENTER, 2.501f, 0.21875f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.734375f);
            if (this.useAlternateModel(stargate, stargateVariant)) {
                SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, STARGATE_RING_OUTER_CENTER, 3.499f, 0.03125f, (52.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.10962498f, STARGATE_RING_INNER_CENTER, 2.501f, 0.03125f, (52.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.35912502f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.03125f, (52.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.35912502f, -STARGATE_RING_OUTER_CENTER, 3.499f, 0.03125f, (52.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.10962498f);
            }
            stack.m_85849_();
        }
    }

    protected void renderOuterRingBack(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        for (int j = 0; j < 54; ++j) {
            stack.m_85836_();
            stack.m_252781_(Axis.f_252403_.m_252977_((float)j * -6.6666665f + 3.3333333f + this.getRotation(!this.useAlternateModel(stargate, stargateVariant))));
            Matrix4f matrix4 = stack.m_85850_().m_252922_();
            Matrix3f matrix3 = stack.m_85850_().m_252943_();
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -STARGATE_RING_OUTER_CENTER, 3.499f, -0.21875f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0f, -STARGATE_RING_OUTER_CENTER, 3.499f, 0.03125f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0625f, STARGATE_RING_OUTER_CENTER, 3.499f, 0.03125f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0625f, STARGATE_RING_OUTER_CENTER, 3.499f, -0.21875f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, STARGATE_RING_OUTER_CENTER, 3.499f, -0.21875f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.37524998f, STARGATE_RING_INNER_CENTER, 2.501f, -0.21875f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.62475f, -STARGATE_RING_INNER_CENTER, 2.501f, -0.21875f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.62475f, -STARGATE_RING_OUTER_CENTER, 3.499f, -0.21875f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.37524998f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, STARGATE_RING_INNER_CENTER, 2.501f, -0.21875f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.625f, STARGATE_RING_INNER_CENTER, 2.501f, 0.03125f, (8.0f * (float)(j % 6) + 4.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.6875f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.03125f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.6875f, -STARGATE_RING_INNER_CENTER, 2.501f, -0.21875f, (8.0f * (float)(j % 6) + 4.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.625f);
            if (this.useAlternateModel(stargate, stargateVariant)) {
                SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -STARGATE_RING_OUTER_CENTER, 3.499f, 0.03125f, (52.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.10962498f, -STARGATE_RING_INNER_CENTER, 2.501f, 0.03125f, (52.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.35912502f, STARGATE_RING_INNER_CENTER, 2.501f, 0.03125f, (52.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.35912502f, STARGATE_RING_OUTER_CENTER, 3.499f, 0.03125f, (52.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.10962498f);
            }
            stack.m_85849_();
        }
    }

    protected void renderSymbols(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, float rotation) {
        for (int j = 0; j < this.numberOfSymbols; ++j) {
            boolean symbolEngaged = false;
            if (this.engageEncodedSymbols(stargate, stargateVariant) && (!stargate.isConnected() || stargate.isDialingOut())) {
                if (j == 0) {
                    symbolEngaged = stargate.isConnected();
                } else {
                    for (int i = 0; i < stargate.getAddress().getLength(); ++i) {
                        int addressSymbol = stargate.getAddress().toArray()[i];
                        if (addressSymbol != j) continue;
                        symbolEngaged = true;
                    }
                }
            } else if (stargate.isConnected()) {
                symbolEngaged = this.engageSymbolsOnIncoming(stargate, stargateVariant);
            }
            this.renderSymbol(stargate, stargateVariant, stack, consumer, source, this.symbolsGlow(stargate, stargateVariant, symbolEngaged) ? 0xF000F0 : combinedLight, j, j, rotation, this.getSymbolColor(stargate, stargateVariant, symbolEngaged));
        }
    }

    protected void renderSymbol(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int symbolNumber, int symbolRendered, float rotation, Stargate.RGBA symbolColor) {
        consumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getSymbolTexture(stargate, stargateVariant, symbolRendered)));
        stack.m_85836_();
        int symbolRow = symbolNumber / 4;
        int symbolInRow = symbolNumber % 4;
        stack.m_252781_(Axis.f_252403_.m_252977_(-10.0f + (float)symbolRow * -40.0f + (float)symbolInRow * -6.6666665f + rotation));
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, symbolColor.getRed(), symbolColor.getGreen(), symbolColor.getBlue(), symbolColor.getAlpha(), -STARGATE_SYMBOL_RING_OUTER_CENTER, 3.1875f, 0.21975f, (8.0f - STARGATE_SYMBOL_RING_OUTER_CENTER * 32.0f) / 16.0f, 0.0f, -STARGATE_SYMBOL_RING_INNER_CENTER, 2.6875f, 0.21975f, (8.0f - STARGATE_SYMBOL_RING_INNER_CENTER * 32.0f) / 16.0f, 1.0f, STARGATE_SYMBOL_RING_INNER_CENTER, 2.6875f, 0.21975f, (8.0f + STARGATE_SYMBOL_RING_INNER_CENTER * 32.0f) / 16.0f, 1.0f, STARGATE_SYMBOL_RING_OUTER_CENTER, 3.1875f, 0.21975f, (8.0f + STARGATE_SYMBOL_RING_OUTER_CENTER * 32.0f) / 16.0f, 0.0f);
        stack.m_85849_();
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    @Override
    protected boolean isPrimaryChevronEngaged(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        return stargate.isConnected() || stargate.addressBuffer.getLength() > 0;
    }

    @Override
    protected boolean isChevronEngaged(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, int chevronNumber) {
        return stargate.isConnected() || stargate.addressBuffer.getLength() > 0;
    }

    @Override
    protected void renderPrimaryChevron(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, boolean chevronEngaged) {
        this.renderChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, 0, chevronEngaged);
    }

    @Override
    protected void renderChevron(UniverseStargateEntity stargate, Optional<StargateVariant> stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int chevronNumber, boolean chevronEngaged) {
        int light = chevronEngaged ? 0xF000F0 : combinedLight;
        stack.m_85836_();
        stack.m_252781_(Axis.f_252403_.m_252977_(-40.0f * (float)chevronNumber + this.getRotation(true)));
        stack.m_252880_(0.0f, 3.15625f, 0.0f);
        this.renderChevronLight(stargate, stack, consumer, source, light, chevronNumber, chevronEngaged);
        this.renderOuterChevron(stargate, stack, consumer, source, light, chevronNumber, chevronEngaged);
        stack.m_85849_();
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        stack.m_252781_(Axis.f_252403_.m_252977_(40.0f * (float)chevronNumber - this.getRotation(!this.useAlternateModel(stargate, stargateVariant))));
        stack.m_252880_(0.0f, 3.15625f, 0.0f);
        this.renderChevronLight(stargate, stack, consumer, source, light, chevronNumber, chevronEngaged);
        this.renderOuterChevron(stargate, stack, consumer, source, light, chevronNumber, chevronEngaged);
        stack.m_85849_();
    }

    protected void renderChevronLight(UniverseStargateEntity stargate, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int chevronNumber, boolean chevronEngaged) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -0.125f, 0.3125f, 0.21875f, 0.203125f, 0.734375f, -0.125f, 0.3125f, 0.28125f, 0.203125f, 0.75f, 0.125f, 0.3125f, 0.28125f, 0.265625f, 0.75f, 0.125f, 0.3125f, 0.21875f, 0.265625f, 0.734375f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.125f, 0.3125f, 0.28125f, 0.203125f, 0.75f, -0.1875f, 0.25f, 0.28125f, 0.1875f, 0.765625f, 0.1875f, 0.25f, 0.28125f, 0.28125f, 0.765625f, 0.125f, 0.3125f, 0.28125f, 0.265625f, 0.75f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, 1.0f, 0.0f, -0.125f, 0.3125f, 0.21875f, 0.171875f, 0.75f, -0.1875f, 0.25f, 0.21875f, 0.171875f, 0.765625f, -0.1875f, 0.25f, 0.28125f, 0.1875f, 0.765625f, -0.125f, 0.3125f, 0.28125f, 0.1875f, 0.75f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, 1.0f, 0.0f, 0.125f, 0.3125f, 0.28125f, 0.28125f, 0.75f, 0.1875f, 0.25f, 0.28125f, 0.28125f, 0.765625f, 0.1875f, 0.25f, 0.21875f, 0.296875f, 0.765625f, 0.125f, 0.3125f, 0.21875f, 0.296875f, 0.75f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.1875f, 0.25f, 0.28125f, 0.1875f, 0.765625f, -0.09375f, 0.125f, 0.28125f, 0.2109375f, 0.796875f, 0.09375f, 0.125f, 0.28125f, 0.2578125f, 0.796875f, 0.1875f, 0.25f, 0.28125f, 0.28125f, 0.765625f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, -1.0f, 0.0f, -0.1875f, 0.25f, 0.21875f, 0.171875f, 0.765625f, -0.09375f, 0.125f, 0.21875f, 0.171875f, 0.796875f, -0.09375f, 0.125f, 0.28125f, 0.1875f, 0.796875f, -0.1875f, 0.25f, 0.28125f, 0.1875f, 0.765625f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, -1.0f, 0.0f, 0.1875f, 0.25f, 0.28125f, 0.28125f, 0.765625f, 0.09375f, 0.125f, 0.28125f, 0.28125f, 0.796875f, 0.09375f, 0.125f, 0.21875f, 0.296875f, 0.796875f, 0.1875f, 0.25f, 0.21875f, 0.296875f, 0.765625f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.09375f, 0.125f, 0.28125f, 0.2109375f, 0.796875f, -0.03125f, 0.0f, 0.28125f, 0.2265625f, 0.828125f, 0.03125f, 0.0f, 0.28125f, 0.2421875f, 0.828125f, 0.09375f, 0.125f, 0.28125f, 0.2578125f, 0.796875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, -1.0f, 0.0f, -0.09375f, 0.125f, 0.21875f, 0.171875f, 0.796875f, -0.03125f, 0.0f, 0.21875f, 0.171875f, 0.828125f, -0.03125f, 0.0f, 0.28125f, 0.1875f, 0.828125f, -0.09375f, 0.125f, 0.28125f, 0.1875f, 0.796875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, -1.0f, 0.0f, 0.09375f, 0.125f, 0.28125f, 0.28125f, 0.796875f, 0.03125f, 0.0f, 0.28125f, 0.28125f, 0.828125f, 0.03125f, 0.0f, 0.21875f, 0.296875f, 0.828125f, 0.09375f, 0.125f, 0.21875f, 0.296875f, 0.796875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, -0.03125f, 0.0f, 0.28125f, 0.2265625f, 0.828125f, -0.03125f, 0.0f, 0.21875f, 0.2265625f, 0.84375f, 0.03125f, 0.0f, 0.21875f, 0.2421875f, 0.84375f, 0.03125f, 0.0f, 0.28125f, 0.2421875f, 0.828125f);
    }

    protected void renderOuterChevron(UniverseStargateEntity stargate, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int chevronNumber, boolean chevronEngaged) {
        this.renderLightStrip(stargate, stack, consumer, source, combinedLight, 0.25f, 0.0625f, 0.03125f, -0.375f, 0.21875f, 0.25f, 10.0f, 5.0f, 48.0f);
        this.renderLightStrip(stargate, stack, consumer, source, combinedLight, 0.1875f, 0.0625f, 0.03125f, -0.25f, 0.125f, 0.25f, 10.0f, 6.0f, 52.0f);
        this.renderLightStrip(stargate, stack, consumer, source, combinedLight, 0.125f, 0.0625f, 0.03125f, -0.15625f, 0.03125f, 0.25f, 10.0f, 7.0f, 56.0f);
        this.renderLightStrip(stargate, stack, consumer, source, combinedLight, 0.25f, 0.0625f, 0.03125f, 0.375f, 0.21875f, 0.25f, -10.0f, 21.0f, 48.0f);
        this.renderLightStrip(stargate, stack, consumer, source, combinedLight, 0.1875f, 0.0625f, 0.03125f, 0.25f, 0.125f, 0.25f, -10.0f, 21.0f, 52.0f);
        this.renderLightStrip(stargate, stack, consumer, source, combinedLight, 0.125f, 0.0625f, 0.03125f, 0.15625f, 0.03125f, 0.25f, -10.0f, 21.0f, 56.0f);
    }

    protected void renderLightStrip(UniverseStargateEntity stargate, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, float xSize, float ySize, float zSize, float xPos, float yPos, float zPos, float rotation, float textureX, float textureY) {
        stack.m_85836_();
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        float halfX = xSize / 2.0f;
        float halfY = ySize / 2.0f;
        float r1 = CoordinateHelper.cartesianToPolarR(-halfX, halfY);
        float phi1 = CoordinateHelper.cartesianToPolarPhi(-halfX, halfY);
        float x1 = xPos + CoordinateHelper.polarToCartesianX(r1, phi1 + rotation);
        float y1 = yPos + CoordinateHelper.polarToCartesianY(r1, phi1 + rotation);
        float r2 = CoordinateHelper.cartesianToPolarR(-halfX, -halfY);
        float phi2 = CoordinateHelper.cartesianToPolarPhi(-halfX, -halfY);
        float x2 = xPos + CoordinateHelper.polarToCartesianX(r2, phi2 + rotation);
        float y2 = yPos + CoordinateHelper.polarToCartesianY(r2, phi2 + rotation);
        float r3 = CoordinateHelper.cartesianToPolarR(halfX, -halfY);
        float phi3 = CoordinateHelper.cartesianToPolarPhi(halfX, -halfY);
        float x3 = xPos + CoordinateHelper.polarToCartesianX(r3, phi3 + rotation);
        float y3 = yPos + CoordinateHelper.polarToCartesianY(r3, phi3 + rotation);
        float r4 = CoordinateHelper.cartesianToPolarR(halfX, halfY);
        float phi4 = CoordinateHelper.cartesianToPolarPhi(halfX, halfY);
        float x4 = xPos + CoordinateHelper.polarToCartesianX(r4, phi4 + rotation);
        float y4 = yPos + CoordinateHelper.polarToCartesianY(r4, phi4 + rotation);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, x1, y1, 0.21875f, textureX / 64.0f, (textureY - zSize * 16.0f) / 64.0f, x1, y1, zPos, textureX / 64.0f, textureY / 64.0f, x4, y4, zPos, (textureX + xSize * 16.0f) / 64.0f, textureY / 64.0f, x4, y4, 0.21875f, (textureX + xSize * 16.0f) / 64.0f, (textureY - zSize * 16.0f) / 64.0f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, x1, y1, zPos, textureX / 64.0f, textureY / 64.0f, x2, y2, zPos, textureX / 64.0f, (textureY - ySize * 16.0f) / 64.0f, x3, y3, zPos, (textureX + xSize * 16.0f) / 64.0f, (textureY - ySize * 16.0f) / 64.0f, x4, y4, zPos, (textureX + xSize * 16.0f) / 64.0f, textureY / 64.0f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, -1.0f, 0.0f, x1, y1, 0.21875f, (textureX - zSize * 16.0f) / 64.0f, textureY / 64.0f, x2, y2, 0.21875f, (textureX - zSize * 16.0f) / 64.0f, (textureY + ySize * 16.0f) / 64.0f, x2, y2, zPos, textureX / 64.0f, (textureY + ySize * 16.0f) / 64.0f, x1, y1, zPos, textureX / 64.0f, textureY / 64.0f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, -1.0f, 0.0f, x4, y4, zPos, (textureX + xSize * 16.0f) / 64.0f, textureY / 64.0f, x3, y3, zPos, (textureX + xSize * 16.0f) / 64.0f, (textureY + ySize * 16.0f) / 64.0f, x3, y3, 0.21875f, (textureX + xSize * 16.0f + zSize * 16.0f) / 64.0f, (textureY + ySize * 16.0f) / 64.0f, x4, y4, 0.21875f, (textureX + xSize * 16.0f + zSize * 16.0f) / 64.0f, textureY / 64.0f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, x2, y2, zPos, textureX / 64.0f, textureY / 64.0f, x2, y2, 0.21875f, textureX / 64.0f, (textureY + zSize * 16.0f) / 64.0f, x3, y3, 0.21875f, (textureX + xSize * 16.0f) / 64.0f, (textureY + zSize * 16.0f) / 64.0f, x3, y3, zPos, (textureX + xSize * 16.0f) / 64.0f, textureY / 64.0f);
        stack.m_85849_();
    }
}

