/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.GenericStargateModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

public class PegasusStargateModel
extends GenericStargateModel<PegasusStargateEntity> {
    private static final int RED = 0;
    private static final int GREEN = 100;
    private static final int BLUE = 200;
    private static final int ENGAGED_GREEN = 200;
    private static final int ENGAGED_BLUE = 255;
    protected int currentSymbol = 0;
    protected final ResourceLocation alternateStargateTexture = new ResourceLocation(this.namespace, "textures/entity/stargate/" + this.name + "/" + this.name + "_stargate_alternate.png");
    protected final ResourceLocation alternateEngagedTexture = new ResourceLocation(this.namespace, "textures/entity/stargate/" + this.name + "/" + this.name + "_stargate_alternate_engaged.png");

    public PegasusStargateModel() {
        super(new ResourceLocation("sgjourney", "pegasus"), (short)36, new Stargate.RGBA(0, 100, 200, 255));
        this.engagedSymbolColor = new Stargate.RGBA(0, 200, 255, 255);
    }

    @Override
    public void renderStargate(PegasusStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        Optional<StargateVariant> stargateVariant = this.getStargateVariant(stargate);
        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.stargate(this.getStargateTexture(stargate, stargateVariant)));
        this.renderOuterRing(stack, consumer, source, combinedLight);
        this.renderSymbolRing(stargate, stargateVariant, stack, consumer, source, combinedLight, 0.0f);
        this.renderChevrons(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
    }

    @Override
    protected boolean useMovieStargateModel(PegasusStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent() && stargateVariant.get().useAlternateModel().isPresent()) {
            return stargateVariant.get().useAlternateModel().get();
        }
        return false;
    }

    public void setCurrentSymbol(int currentSymbol) {
        this.currentSymbol = currentSymbol;
    }

    @Override
    protected Stargate.RGBA getSymbolColor(PegasusStargateEntity stargate, Optional<StargateVariant> stargateVariant, boolean isEngaged) {
        if (stargateVariant.isPresent()) {
            if (isEngaged) {
                if (!stargate.isConnected() && stargateVariant.get().getEncodedSymbolRGBA().isPresent()) {
                    return stargateVariant.get().getEncodedSymbolRGBA().get();
                }
                if (stargateVariant.get().getEngagedSymbolRGBA().isPresent()) {
                    return stargateVariant.get().getEngagedSymbolRGBA().get();
                }
            } else if (!isEngaged && stargateVariant.get().getSymbolRGBA().isPresent()) {
                return stargateVariant.get().getSymbolRGBA().get();
            }
        }
        return isEngaged ? this.engagedSymbolColor : this.symbolColor;
    }

    @Override
    protected ResourceLocation getStargateTexture(PegasusStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent()) {
            return stargateVariant.get().getTexture();
        }
        return ClientStargateConfig.pegasus_stargate_back_lights_up.get() ? this.alternateStargateTexture : this.stargateTexture;
    }

    @Override
    protected ResourceLocation getEngagedTexture(PegasusStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent()) {
            return stargateVariant.get().getEngagedTexture();
        }
        return ClientStargateConfig.pegasus_stargate_back_lights_up.get() ? this.alternateEngagedTexture : this.engagedTexture;
    }

    protected void renderSpinningSymbol(PegasusStargateEntity stargate, Optional<StargateVariant> stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, float rotation) {
        if (!stargate.isConnected() && stargate.symbolBuffer < stargate.addressBuffer.getLength()) {
            for (int i = 0; i < stargate.getAddress().getLength(); ++i) {
                if (stargate.getChevronPosition(i + 1) != this.currentSymbol) continue;
                return;
            }
            int renderedSymbol = stargate.addressBuffer.getSymbol(stargate.symbolBuffer);
            this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, this.currentSymbol, renderedSymbol, 0.0f, this.getSymbolColor(stargate, stargateVariant, true));
        }
    }

    @Override
    protected void renderSymbols(PegasusStargateEntity stargate, Optional<StargateVariant> stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, float rotation) {
        if (stargate.isDialingOut() && stargate.isConnected() || stargate.addressBuffer.getLength() > 0 && !stargate.isConnected()) {
            this.renderSpinningSymbol(stargate, stargateVariant, stack, consumer, source, combinedLight, rotation);
            if (stargate.isConnected()) {
                this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, 0, 0, 0.0f, this.getSymbolColor(stargate, stargateVariant, true));
            }
            for (int i = 0; i < stargate.getAddress().getLength(); ++i) {
                int symbolNumber = stargate.getChevronPosition(i + 1);
                this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, symbolNumber, stargate.getAddress().toArray()[i], 0.0f, this.getSymbolColor(stargate, stargateVariant, true));
            }
        } else {
            Stargate.RGBA symbolColor = this.getSymbolColor(stargate, stargateVariant, false);
            int symbolNumber = this.numberOfSymbols;
            if (stargate.isConnected()) {
                symbolColor = this.getSymbolColor(stargate, stargateVariant, true);
                int n = symbolNumber = stargate.currentSymbol < this.numberOfSymbols ? stargate.currentSymbol : symbolNumber;
                if (stargate.getKawooshTickCount() > 0) {
                    this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, 0, 0, 0.0f, symbolColor);
                }
            }
            for (int i = 0; i < symbolNumber; ++i) {
                int renderedSymbol = (stargate.isConnected() ? i + 1 : i) % this.numberOfSymbols;
                this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, renderedSymbol, renderedSymbol, 0.0f, symbolColor);
            }
        }
    }
}

