/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargateVariant;
import net.povstalec.sgjourney.common.stargate.Symbols;

public abstract class AbstractStargateModel<StargateEntity extends AbstractStargateEntity> {
    protected static final float DEFAULT_RADIUS = 3.5f;
    protected static final int DEFAULT_SIDES = 36;
    protected static final float DEFAULT_RING_HEIGHT = 1.0f;
    protected static final float STARGATE_RING_SHRINK = 0.001f;
    protected static final float DEFAULT_ANGLE = 10.0f;
    protected static final float NUMBER_OF_CHEVRONS = 9.0f;
    protected static final float CHEVRON_ANGLE = 40.0f;
    protected static final int MAX_LIGHT = 0xF000F0;
    public static final ResourceLocation ERROR_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/error.png");
    public static final ResourceLocation EMPTY_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/empty.png");
    public static final String EMPTY = "sgjourney:empty";
    private static Minecraft minecraft = Minecraft.m_91087_();
    protected final String namespace;
    protected final String name;
    protected final ResourceLocation stargateTexture;
    protected final ResourceLocation engagedTexture;
    protected Stargate.RGBA symbolColor = Stargate.RGBA.DEFAULT_RGBA;
    protected Stargate.RGBA engagedSymbolColor = Stargate.RGBA.DEFAULT_RGBA;
    protected final short numberOfSymbols;

    public AbstractStargateModel(ResourceLocation stargateName, short numberOfSymbols) {
        this.namespace = stargateName.m_135827_();
        this.name = stargateName.m_135815_();
        this.stargateTexture = new ResourceLocation(this.namespace, "textures/entity/stargate/" + this.name + "/" + this.name + "_stargate.png");
        this.engagedTexture = new ResourceLocation(this.namespace, "textures/entity/stargate/" + this.name + "/" + this.name + "_stargate_engaged.png");
        this.numberOfSymbols = numberOfSymbols;
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.namespace, this.name + "_stargate");
    }

    public boolean canUseVariant(StargateVariant variant) {
        return variant.getBaseStargate().equals((Object)this.getResourceLocation());
    }

    public static Optional<StargateVariant> getVariant(AbstractStargateEntity stargate) {
        Optional<StargateVariant> optional = Optional.empty();
        if (!ClientStargateConfig.stargate_variants.get()) {
            return optional;
        }
        String variantString = stargate.getVariant();
        if (variantString.equals(EMPTY)) {
            return optional;
        }
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry variantRegistry = registries.m_175515_(StargateVariant.REGISTRY_KEY);
        optional = Optional.ofNullable((StargateVariant)variantRegistry.m_7745_(new ResourceLocation(variantString)));
        return optional;
    }

    protected Optional<StargateVariant> getStargateVariant(StargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = AbstractStargateModel.getVariant(stargate);
        if (stargateVariant.isPresent() && this.canUseVariant(stargateVariant.get())) {
            return stargateVariant;
        }
        return Optional.empty();
    }

    protected ResourceLocation getSymbolTexture(AbstractStargateEntity stargate, Optional<StargateVariant> stargateVariant, int symbol) {
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry symbolRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
        Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
        if (symbol > 0) {
            if (stargateVariant.isPresent() && stargateVariant.get().getSymbols().isPresent() && symbolRegistry.m_142003_(stargateVariant.get().getSymbols().get())) {
                return ((Symbols)symbolRegistry.m_6246_(stargateVariant.get().getSymbols().get())).texture(symbol - 1);
            }
            String symbols = stargate.getSymbols();
            if (this.isLocationValid(symbols) && symbolRegistry.m_7804_(new ResourceLocation(symbols))) {
                return ((Symbols)symbolRegistry.m_7745_(new ResourceLocation(symbols))).texture(symbol - 1);
            }
            if (symbols.equals(EMPTY)) {
                return EMPTY_LOCATION;
            }
            return ERROR_LOCATION;
        }
        if (stargateVariant.isPresent() && stargateVariant.get().getPointOfOrigin().isPresent() && pointOfOriginRegistry.m_142003_(stargateVariant.get().getPointOfOrigin().get())) {
            return ((PointOfOrigin)pointOfOriginRegistry.m_6246_(stargateVariant.get().getPointOfOrigin().get())).texture();
        }
        String pointOfOrigin = stargate.getPointOfOrigin();
        if (this.isLocationValid(pointOfOrigin) && pointOfOriginRegistry.m_7804_(new ResourceLocation(pointOfOrigin))) {
            return ((PointOfOrigin)pointOfOriginRegistry.m_7745_(new ResourceLocation(pointOfOrigin))).texture();
        }
        if (pointOfOrigin.equals(EMPTY)) {
            return EMPTY_LOCATION;
        }
        return ERROR_LOCATION;
    }

    protected ResourceLocation getStargateTexture(StargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent()) {
            return stargateVariant.get().getTexture();
        }
        return this.stargateTexture;
    }

    protected ResourceLocation getEngagedTexture(StargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent()) {
            return stargateVariant.get().getEngagedTexture();
        }
        return this.engagedTexture;
    }

    private boolean isLocationValid(String location) {
        String[] split = location.split(":");
        if (split.length != 2) {
            return false;
        }
        if (!ResourceLocation.m_135843_((String)split[0])) {
            return false;
        }
        return ResourceLocation.m_135841_((String)split[1]);
    }

    public void renderStargate(StargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        Optional<StargateVariant> stargateVariant = this.getStargateVariant(stargate);
        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.stargate(this.getStargateTexture(stargate, stargateVariant)));
        this.renderRing(stargate, stargateVariant, partialTick, stack, consumer, source, combinedLight, combinedOverlay);
        this.renderChevrons(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
    }

    public abstract void renderRing(StargateEntity var1, Optional<StargateVariant> var2, float var3, PoseStack var4, VertexConsumer var5, MultiBufferSource var6, int var7, int var8);

    protected boolean isPrimaryChevronRaised(StargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        return false;
    }

    protected boolean isPrimaryChevronLowered(StargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        return false;
    }

    protected boolean isPrimaryChevronEngaged(StargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (((AbstractStargateEntity)((Object)stargate)).isConnected()) {
            return ((AbstractStargateEntity)((Object)stargate)).isDialingOut() || ((AbstractStargateEntity)((Object)stargate)).getKawooshTickCount() > 0;
        }
        return false;
    }

    protected boolean isChevronRaised(StargateEntity stargate, Optional<StargateVariant> stargateVariant, int chevronNumber) {
        return false;
    }

    protected boolean isChevronLowered(StargateEntity stargate, Optional<StargateVariant> stargateVariant, int chevronNumber) {
        return false;
    }

    protected boolean isChevronEngaged(StargateEntity stargate, Optional<StargateVariant> stargateVariant, int chevronNumber) {
        return ((AbstractStargateEntity)((Object)stargate)).chevronsRendered() >= chevronNumber;
    }

    protected abstract void renderPrimaryChevron(StargateEntity var1, Optional<StargateVariant> var2, PoseStack var3, VertexConsumer var4, MultiBufferSource var5, int var6, boolean var7);

    protected abstract void renderChevron(StargateEntity var1, Optional<StargateVariant> var2, PoseStack var3, VertexConsumer var4, MultiBufferSource var5, int var6, int var7, boolean var8);

    protected void renderChevrons(StargateEntity stargate, Optional<StargateVariant> stargateVariant, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        int chevronNumber;
        VertexConsumer consumer;
        if (StargateJourney.isOculusLoaded()) {
            consumer = source.m_6299_(SGJourneyRenderTypes.engagedChevron(this.getEngagedTexture(stargate, stargateVariant)));
            if (this.isPrimaryChevronEngaged(stargate, stargateVariant)) {
                this.renderPrimaryChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, true);
            }
            chevronNumber = 1;
            while ((float)chevronNumber < 9.0f) {
                if (this.isChevronEngaged(stargate, stargateVariant, chevronNumber)) {
                    this.renderChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, chevronNumber, true);
                }
                ++chevronNumber;
            }
        }
        consumer = source.m_6299_(SGJourneyRenderTypes.chevron(this.getStargateTexture(stargate, stargateVariant)));
        this.renderPrimaryChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, false);
        chevronNumber = 1;
        while ((float)chevronNumber < 9.0f) {
            this.renderChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, chevronNumber, false);
            ++chevronNumber;
        }
        if (!StargateJourney.isOculusLoaded()) {
            consumer = source.m_6299_(SGJourneyRenderTypes.engagedChevron(this.getEngagedTexture(stargate, stargateVariant)));
            if (this.isPrimaryChevronEngaged(stargate, stargateVariant)) {
                this.renderPrimaryChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, true);
            }
            chevronNumber = 1;
            while ((float)chevronNumber < 9.0f) {
                if (this.isChevronEngaged(stargate, stargateVariant, chevronNumber)) {
                    this.renderChevron(stargate, stargateVariant, stack, consumer, source, combinedLight, chevronNumber, true);
                }
                ++chevronNumber;
            }
        }
    }

    protected boolean symbolsGlow(StargateEntity stargate, Optional<StargateVariant> stargateVariant, boolean isEngaged) {
        if (stargateVariant.isPresent()) {
            if (isEngaged) {
                if (!((AbstractStargateEntity)((Object)stargate)).isConnected() && stargateVariant.get().encodedSymbolsGlow().isPresent()) {
                    return stargateVariant.get().encodedSymbolsGlow().get();
                }
                if (stargateVariant.get().engagedSymbolsGlow().isPresent()) {
                    return stargateVariant.get().engagedSymbolsGlow().get();
                }
            }
            if (!isEngaged && stargateVariant.get().symbolsGlow().isPresent()) {
                return stargateVariant.get().symbolsGlow().get();
            }
        }
        return false;
    }

    protected boolean engageEncodedSymbols(StargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent() && stargateVariant.get().engageEncodedSymbols().isPresent()) {
            return stargateVariant.get().engageEncodedSymbols().get();
        }
        return false;
    }

    protected boolean engageSymbolsOnIncoming(StargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent() && stargateVariant.get().engageSymbolsOnIncoming().isPresent()) {
            return stargateVariant.get().engageSymbolsOnIncoming().get();
        }
        return false;
    }

    protected Stargate.RGBA getSymbolColor(StargateEntity stargate, Optional<StargateVariant> stargateVariant, boolean isEngaged) {
        if (stargateVariant.isPresent()) {
            if (isEngaged) {
                if (!((AbstractStargateEntity)((Object)stargate)).isConnected() && stargateVariant.get().getEncodedSymbolRGBA().isPresent()) {
                    return stargateVariant.get().getEncodedSymbolRGBA().get();
                }
                if (stargateVariant.get().getEngagedSymbolRGBA().isPresent()) {
                    return stargateVariant.get().getEngagedSymbolRGBA().get();
                }
            } else if (!isEngaged && stargateVariant.get().getSymbolRGBA().isPresent()) {
                return stargateVariant.get().getSymbolRGBA().get();
            }
        }
        return this.symbolColor;
    }
}

