/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.api.IRuneColorProvider;
import org.violetmoon.quark.api.QuarkCapabilities;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.network.message.UpdateTridentMessage;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.quark.content.tools.client.render.GlintRenderTypes;
import org.violetmoon.quark.content.tools.item.RuneItem;
import org.violetmoon.quark.content.tools.recipe.SmithingRuneRecipe;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerTick;
import org.violetmoon.zeta.event.play.loading.ZLootTableLoad;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.network.IZetaMessage;
import org.violetmoon.zeta.network.ZetaNetworkDirection;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.ItemNBTHelper;

@ZetaLoadModule(category="tools")
public class ColorRunesModule
extends ZetaModule {
    public static final String TAG_RUNE_COLOR = "quark:RuneColor";
    private static final ThreadLocal<RuneColor> targetColor = new ThreadLocal();
    @Hint
    public static Item rune;
    @Config
    public static int dungeonWeight;
    @Config
    public static int netherFortressWeight;
    @Config
    public static int jungleTempleWeight;
    @Config
    public static int desertTempleWeight;
    @Config
    public static int itemQuality;
    public static ManualTrigger fullRainbowTrigger;
    private static final Map<ThrownTrident, ItemStack> TRIDENT_STACK_REFERENCES;

    public static void setTargetStack(ItemStack stack) {
        ColorRunesModule.setTargetColor(ColorRunesModule.getStackColor(stack));
    }

    public static void setTargetColor(RuneColor color) {
        targetColor.set(color);
    }

    public static RuneColor changeColor() {
        return targetColor.get();
    }

    @Nullable
    public static RuneColor getStackColor(ItemStack target) {
        if (target == null) {
            return null;
        }
        RuneColor manualColor = ColorRunesModule.getAppliedStackColor(target);
        if (manualColor != null) {
            return manualColor;
        }
        @Nullable IRuneColorProvider cap = ColorRunesModule.get(target);
        return cap != null ? cap.getRuneColor(target) : null;
    }

    @Nullable
    public static RuneColor getAppliedStackColor(ItemStack target) {
        if (target == null) {
            return null;
        }
        return RuneColor.byName(ItemNBTHelper.getString((ItemStack)target, (String)TAG_RUNE_COLOR, null));
    }

    public static void syncTrident(Consumer<Packet<?>> packetConsumer, ThrownTrident trident, boolean force) {
        ItemStack stack = trident.m_7941_();
        ItemStack prev = TRIDENT_STACK_REFERENCES.get(trident);
        if (force || prev == null || ItemStack.m_150942_((ItemStack)stack, (ItemStack)prev)) {
            packetConsumer.accept(Quark.ZETA.network.wrapInVanilla((IZetaMessage)new UpdateTridentMessage(trident.m_19879_(), stack), ZetaNetworkDirection.PLAY_TO_CLIENT));
        } else {
            TRIDENT_STACK_REFERENCES.put(trident, stack);
        }
    }

    public static ItemStack withRune(ItemStack stack, RuneColor color) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_RUNE_COLOR, (String)color.m_7912_());
        return stack;
    }

    @LoadEvent
    public final void register(ZRegister event) {
        event.getRegistry().register((Object)SmithingRuneRecipe.SERIALIZER, "smithing_rune", Registries.f_256764_);
        rune = new RuneItem("smithing_template_rune", this);
        fullRainbowTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("full_rainbow");
    }

    @PlayEvent
    public void onLootTableLoad(ZLootTableLoad event) {
        int weight = 0;
        if (event.getName().equals((Object)BuiltInLootTables.f_78742_)) {
            weight = dungeonWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78760_)) {
            weight = netherFortressWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78686_)) {
            weight = jungleTempleWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78764_)) {
            weight = desertTempleWeight;
        }
        if (weight > 0) {
            LootPoolEntryContainer entry = LootItem.m_79579_((ItemLike)rune).m_79707_(weight).m_79711_(itemQuality).m_7512_();
            event.add(entry);
        }
    }

    @PlayEvent
    public void onPlayerTick(ZPlayerTick.Start event) {
        boolean rainbow;
        String tag = "quark:what_are_you_gay_or_something";
        Player player = event.getPlayer();
        boolean wasRainbow = player.getPersistentData().m_128471_("quark:what_are_you_gay_or_something");
        if (wasRainbow != (rainbow = this.isPlayerRainbow(player))) {
            player.getPersistentData().m_128379_("quark:what_are_you_gay_or_something", rainbow);
            if (rainbow && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                fullRainbowTrigger.trigger(sp);
            }
        }
    }

    private boolean isPlayerRainbow(Player player) {
        ImmutableSet checks = ImmutableSet.of((Object)EquipmentSlot.HEAD, (Object)EquipmentSlot.CHEST, (Object)EquipmentSlot.LEGS, (Object)EquipmentSlot.FEET);
        for (EquipmentSlot slot : checks) {
            ItemStack stack = player.m_6844_(slot);
            if (!stack.m_41619_() && ColorRunesModule.getStackColor(stack) == RuneColor.RAINBOW) continue;
            return false;
        }
        return true;
    }

    public static boolean canHaveRune(ItemStack stack) {
        return stack.m_41793_() || stack.m_41720_() == Items.f_42522_ && CompassItem.m_40736_((ItemStack)stack);
    }

    public static Component extremeRainbow(Component component) {
        String emphasis = component.getString();
        float time = Quark.proxy.getVisualTime();
        MutableComponent emphasized = Component.m_237119_();
        for (int i = 0; i < emphasis.length(); ++i) {
            emphasized.m_7220_((Component)ColorRunesModule.rainbow(Component.m_237113_((String)("" + emphasis.charAt(i))), i, time));
        }
        return emphasized;
    }

    private static MutableComponent rainbow(MutableComponent component, int shift, float time) {
        return component.m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)Mth.m_14169_((float)((time + (float)shift) * 2.0f % 360.0f / 360.0f), (float)1.0f, (float)1.0f))));
    }

    public static void appendRuneText(ItemStack stack, List<Component> components, Component upgradeTitle) {
        RuneColor color = ColorRunesModule.getAppliedStackColor(stack);
        if (color != null) {
            if (!components.contains(upgradeTitle)) {
                components.add(upgradeTitle);
            }
            MutableComponent baseComponent = Component.m_237115_((String)("rune.quark." + color.getName()));
            if (color == RuneColor.RAINBOW) {
                components.add((Component)CommonComponents.m_264333_().m_7220_(ColorRunesModule.extremeRainbow((Component)baseComponent)));
            } else {
                components.add((Component)CommonComponents.m_264333_().m_7220_((Component)baseComponent.m_130938_(style -> style.m_131148_(color.getTextColor()))));
            }
        }
    }

    @Nullable
    private static IRuneColorProvider get(ItemStack stack) {
        return (IRuneColorProvider)Quark.ZETA.capabilityManager.getCapability(QuarkCapabilities.RUNE_COLOR, stack);
    }

    static {
        dungeonWeight = 10;
        netherFortressWeight = 8;
        jungleTempleWeight = 8;
        desertTempleWeight = 8;
        itemQuality = 0;
        TRIDENT_STACK_REFERENCES = new WeakHashMap<ThrownTrident, ItemStack>();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ColorRunesModule {
        public static RenderType getGlint() {
            return Client.renderType(GlintRenderTypes.glint, RenderType::m_110490_);
        }

        public static RenderType getGlintTranslucent() {
            return Client.renderType(GlintRenderTypes.glintTranslucent, RenderType::m_110487_);
        }

        public static RenderType getEntityGlint() {
            return Client.renderType(GlintRenderTypes.entityGlint, RenderType::m_110496_);
        }

        public static RenderType getGlintDirect() {
            return Client.renderType(GlintRenderTypes.glintDirect, RenderType::m_110493_);
        }

        public static RenderType getEntityGlintDirect() {
            return Client.renderType(GlintRenderTypes.entityGlintDirect, RenderType::m_110499_);
        }

        public static RenderType getArmorGlint() {
            return Client.renderType(GlintRenderTypes.armorGlint, RenderType::m_110481_);
        }

        public static RenderType getArmorEntityGlint() {
            return Client.renderType(GlintRenderTypes.armorEntityGlint, RenderType::m_110484_);
        }

        private static RenderType renderType(Map<RuneColor, RenderType> map, Supplier<RenderType> vanilla) {
            RuneColor color = Client.changeColor();
            return color != null ? map.get((Object)color) : vanilla.get();
        }
    }
}

