/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.management.module;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.network.message.ShareItemC2SMessage;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.network.IZetaMessage;

@ZetaLoadModule(category="management")
public class ItemSharingModule
extends ZetaModule {
    @Config(description="In ticks.")
    @Config.Min(value=0.0)
    private static int cooldown = 100;
    @Config
    public static boolean renderItemsInChat = true;
    private static final Object2IntMap<UUID> lastSendTimes = new Object2IntOpenHashMap();

    public static boolean canShare(UUID sender, MinecraftServer server) {
        int lastSend;
        if (!((ItemSharingModule)Quark.ZETA.modules.get(ItemSharingModule.class)).enabled) {
            return false;
        }
        int now = server.m_129921_();
        if (now - (lastSend = lastSendTimes.getOrDefault((Object)sender, -cooldown)) >= cooldown) {
            lastSendTimes.put((Object)sender, now);
            return true;
        }
        return false;
    }

    public static MutableComponent createStackComponent(ItemStack stack) {
        return ItemSharingModule.createStackComponent(stack, (MutableComponent)stack.m_41611_());
    }

    public static MutableComponent createStackComponent(ItemStack stack, MutableComponent component) {
        if (!Quark.ZETA.modules.isEnabled(ItemSharingModule.class) || !renderItemsInChat) {
            return component;
        }
        Style style = component.m_7383_();
        if (stack.m_41613_() > 64) {
            ItemStack copyStack = stack.m_41777_();
            copyStack.m_41764_(64);
            style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(copyStack)));
            component.m_130948_(style);
        }
        MutableComponent out = Component.m_237113_((String)"   ");
        out.m_6270_(style);
        return out.m_7220_((Component)component);
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ItemSharingModule {
        public static float alphaValue = 1.0f;
        private static long lastClientShare = -1L;

        public static boolean requestShare() {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || !Screen.m_96638_()) {
                return false;
            }
            Screen screen = mc.f_91080_;
            if (!(screen instanceof AbstractContainerScreen)) {
                return false;
            }
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            for (GuiEventListener c : gui.m_6702_()) {
                EditBox tf;
                if (!(c instanceof EditBox) || !(tf = (EditBox)c).m_93696_()) continue;
                return false;
            }
            Slot slot = gui.getSlotUnderMouse();
            if (slot == null) {
                return false;
            }
            ItemStack stack = slot.m_7993_();
            if (stack.m_41619_()) {
                return false;
            }
            if (mc.f_91073_.m_46467_() - lastClientShare <= (long)cooldown) {
                return false;
            }
            lastClientShare = mc.f_91073_.m_46467_();
            QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new ShareItemC2SMessage(stack));
            return true;
        }

        @PlayEvent
        public void onKeyInput(ZScreen.KeyPressed.Pre event) {
            KeyMapping key = this.getChatKey();
            if (key.getKey().m_84868_() == InputConstants.Type.KEYSYM && event.getKeyCode() == key.getKey().m_84873_()) {
                event.setCanceled(Client.requestShare());
            }
        }

        @PlayEvent
        public void onMouseInput(ZScreen.MouseButtonPressed.Post event) {
            KeyMapping key = this.getChatKey();
            int btn = event.getButton();
            if (key.getKey().m_84868_() == InputConstants.Type.MOUSE && btn != 0 && btn == key.getKey().m_84873_()) {
                event.setCanceled(Client.requestShare());
            }
        }

        public static void renderItemForMessage(GuiGraphics guiGraphics, FormattedCharSequence sequence, float x, float y, int color) {
            if (!Quark.ZETA.modules.isEnabled(ItemSharingModule.class) || !renderItemsInChat) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            StringBuilder before = new StringBuilder();
            int halfSpace = mc.f_91062_.m_92895_(" ") / 2;
            sequence.m_13731_((counter_, style, character) -> {
                String sofar = before.toString();
                if (sofar.endsWith("  ")) {
                    Client.render(mc, guiGraphics, sofar.substring(0, sofar.length() - 2), character == 32 ? 0.0f : (float)(-halfSpace), x, y, style, color);
                    return false;
                }
                before.append((char)character);
                return true;
            });
        }

        private static void render(Minecraft mc, GuiGraphics guiGraphics, String before, float extraShift, float x, float y, Style style, int color) {
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            PoseStack pose = guiGraphics.m_280168_();
            HoverEvent hoverEvent = style.m_131186_();
            if (hoverEvent != null && hoverEvent.m_130820_() == HoverEvent.Action.f_130832_) {
                ItemStack stack;
                HoverEvent.ItemStackInfo contents = (HoverEvent.ItemStackInfo)hoverEvent.m_130823_(HoverEvent.Action.f_130832_);
                ItemStack itemStack = stack = contents != null ? contents.m_130898_() : ItemStack.f_41583_;
                if (stack.m_41619_()) {
                    stack = new ItemStack((ItemLike)Blocks.f_50375_);
                }
                float shift = (float)mc.f_91062_.m_92895_(before) + extraShift;
                if (a > 0.0f) {
                    alphaValue = a;
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_252931_(pose.m_85850_().m_252922_());
                    guiGraphics.m_280168_().m_252880_(shift + x, y, 0.0f);
                    guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
                    guiGraphics.m_280480_(stack, 0, 0);
                    guiGraphics.m_280168_().m_85849_();
                    RenderSystem.applyModelViewMatrix();
                    alphaValue = 1.0f;
                }
            }
        }

        private KeyMapping getChatKey() {
            return Minecraft.m_91087_().f_91066_.f_92098_;
        }
    }
}

