/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.module;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.network.message.experimental.PlaceVariantUpdateMessage;
import org.violetmoon.quark.content.experimental.client.screen.VariantSelectorScreen;
import org.violetmoon.quark.content.experimental.client.tooltip.VariantsComponent;
import org.violetmoon.quark.content.experimental.config.VariantsConfig;
import org.violetmoon.quark.content.experimental.item.HammerItem;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.load.ZTooltipComponents;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.client.event.play.ZRenderGuiOverlay;
import org.violetmoon.zeta.client.event.play.ZRenderTooltip;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.bus.ZPhase;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.network.IZetaMessage;

@ZetaLoadModule(category="experimental", enabledByDefault=false, description="Allows placing variant blocks automatically via a selector menu triggered from a keybind")
public class VariantSelectorModule
extends ZetaModule {
    private static final String TAG_CURRENT_VARIANT = "quark:CurrentSelectedVariant";
    private static String clientVariant = null;
    private static boolean staticEnabled;
    @Config(description="Set this to true to automatically convert any dropped variant items into their originals. Do this ONLY if you intend to take control of every recipe via a data pack or equivalent, as this will introduce dupes otherwise.")
    public static boolean convertVariantItems;
    @Config(flag="hammer", description="Enable the hammer, allowing variants to be swapped between eachother, including the original block. Do this ONLY under the same circumstances as Convert Variant Items.")
    public static boolean enableHammer;
    @Config
    public static boolean showTooltip;
    @Config
    public static boolean alignHudToHotbar;
    @Config
    public static boolean showSimpleHud;
    @Config
    public static boolean showHud;
    @Config
    public static boolean enableGreenTint;
    @Config
    public static boolean overrideHeldItemRender;
    @Config
    public static int hudOffsetX;
    @Config
    public static int hudOffsetY;
    @Config
    public static VariantsConfig variants;
    public static Item hammer;

    @LoadEvent
    public final void register(ZRegister event) {
        hammer = new HammerItem(this).setCondition(() -> enableHammer);
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    public static String getSavedVariant(Player player) {
        if (player.m_9236_().f_46443_) {
            return clientVariant;
        }
        return player.getPersistentData().m_128461_(TAG_CURRENT_VARIANT);
    }

    public static void setSavedVariant(ServerPlayer player, String variant) {
        if (variant == null) {
            variant = "";
        }
        if (variant.isEmpty() || variants.isKnownVariant(variant)) {
            player.getPersistentData().m_128359_(TAG_CURRENT_VARIANT, variant);
        }
    }

    private static Block getMainHandVariantBlock(Player player, String variant) {
        ItemStack mainHand = player.m_21205_();
        Item item = mainHand.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            return VariantSelectorModule.getVariantForBlock(block, variant);
        }
        return null;
    }

    public static Block getVariantForBlock(Block block, String variant) {
        return variants.getBlockForVariant(block, variant);
    }

    public static Block getVariantOrOriginal(Block block, String variant) {
        if (!variants.isVariant(block) && !variants.isOriginal(block)) {
            return null;
        }
        block = variants.getOriginalBlock(block);
        if (variant == null || variant.isEmpty()) {
            return variants.getOriginalBlock(block);
        }
        return VariantSelectorModule.getVariantForBlock(block, variant);
    }

    @PlayEvent
    public void addEntityToWorld(ZEntityJoinLevel event) {
        BlockItem bi;
        Block block;
        Block otherBlock;
        ItemEntity ie;
        ItemStack stack;
        Item item;
        Entity entity = event.getEntity();
        if (convertVariantItems && entity instanceof ItemEntity && (item = (stack = (ie = (ItemEntity)entity).m_32055_()).m_41720_()) instanceof BlockItem && (otherBlock = variants.getOriginalBlock(block = (bi = (BlockItem)item).m_40614_())) != block) {
            ItemStack clone = new ItemStack((ItemLike)otherBlock.m_5456_());
            clone.m_41751_(stack.m_41783_());
            ie.m_32045_(clone);
        }
    }

    public static BlockState modifyBlockPlacementState(BlockState state, BlockPlaceContext ctx) {
        String variant;
        if (!staticEnabled || state == null) {
            return state;
        }
        Player player = ctx.m_43723_();
        if (player != null && (variant = VariantSelectorModule.getSavedVariant(player)) != null && !variant.isEmpty()) {
            Block target = VariantSelectorModule.getVariantForBlock(state.m_60734_(), variant);
            return target.m_5573_(ctx);
        }
        return state;
    }

    static {
        convertVariantItems = false;
        enableHammer = false;
        showTooltip = true;
        alignHudToHotbar = false;
        showSimpleHud = false;
        showHud = true;
        enableGreenTint = true;
        overrideHeldItemRender = true;
        hudOffsetX = 0;
        hudOffsetY = 0;
        variants = new VariantsConfig();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends VariantSelectorModule {
        private static KeyMapping variantSelectorKey;

        public static ItemStack modifyHeldItemStack(AbstractClientPlayer player, ItemStack stack) {
            Item item;
            if (!staticEnabled || !overrideHeldItemRender) {
                return stack;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (player == mc.f_91074_ && (item = stack.m_41720_()) instanceof BlockItem) {
                Block variant;
                BlockItem bi = (BlockItem)item;
                Block block = bi.m_40614_();
                if (clientVariant != null && !clientVariant.isEmpty() && (variant = variants.getBlockForVariant(block, clientVariant)) != null && variant != block) {
                    return new ItemStack((ItemLike)variant);
                }
            }
            return stack;
        }

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            variantSelectorKey = event.init("quark.keybind.variant_selector", "r", "quark.gui.keygroup.misc");
        }

        public static void setClientVariant(String variant, boolean sync) {
            clientVariant = variant;
            if (sync) {
                if (variant == null) {
                    variant = "";
                }
                QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new PlaceVariantUpdateMessage(variant));
            }
        }

        @PlayEvent
        public void keystroke(ZInput.Key event) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && event.getAction() == 1 && variantSelectorKey.m_90857_()) {
                HitResult result;
                ItemStack stack = mc.f_91074_.m_21205_();
                if (stack.m_150930_(hammer) && (result = mc.f_91077_) instanceof BlockHitResult) {
                    BlockHitResult bhr = (BlockHitResult)result;
                    BlockPos pos = bhr.m_82425_();
                    Block block = mc.f_91074_.m_9236_().m_8055_(pos).m_60734_();
                    stack = new ItemStack((ItemLike)variants.getOriginalBlock(block));
                }
                if (!stack.m_41619_() && stack.m_41720_() instanceof BlockItem) {
                    mc.m_91152_((Screen)new VariantSelectorScreen(stack, variantSelectorKey, clientVariant, variants.getVisibleVariants()));
                }
                return;
            }
        }

        @LoadEvent
        public void registerClientTooltipComponentFactories(ZTooltipComponents event) {
            event.register(VariantsComponent.class);
        }

        @PlayEvent
        public void gatherComponents(ZRenderTooltip.GatherComponents event) {
            if (!showTooltip) {
                return;
            }
            ItemStack stack = event.getItemStack();
            if (this.hasTooltip(stack)) {
                List elements = event.getTooltipElements();
                int index = 1;
                if (Screen.m_96638_()) {
                    elements.add(index, Either.left((Object)Component.m_237115_((String)"quark.misc.variant_tooltip_header").m_130940_(ChatFormatting.GRAY)));
                    elements.add(index + 1, Either.right((Object)new VariantsComponent(stack)));
                } else {
                    elements.add(index, Either.left((Object)Component.m_237115_((String)"quark.misc.variant_tooltip_hold_shift").m_130940_(ChatFormatting.GRAY)));
                }
            }
        }

        private boolean hasTooltip(ItemStack stack) {
            BlockItem bi;
            Item item;
            return !stack.m_41619_() && (item = stack.m_41720_()) instanceof BlockItem && !variants.getAllVariants((bi = (BlockItem)item).m_40614_()).isEmpty();
        }

        @PlayEvent
        public void clientTick(ZClientTick event) {
            if (event.getPhase() != ZPhase.END) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level == null) {
                Client.setClientVariant(null, false);
            } else if (clientVariant == null) {
                Client.setClientVariant("", true);
            }
        }

        @PlayEvent
        public void onRender(ZRenderGuiOverlay.Crosshair.Pre event) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ instanceof VariantSelectorScreen || !showHud) {
                return;
            }
            LocalPlayer player = mc.f_91074_;
            String savedVariant = Client.getSavedVariant((Player)player);
            if (savedVariant != null) {
                ItemStack mainHand = player.m_21205_();
                ItemStack displayLeft = mainHand.m_41777_();
                Block variantBlock = null;
                if (displayLeft.m_150930_(hammer)) {
                    HitResult result = mc.f_91077_;
                    if (result instanceof BlockHitResult) {
                        BlockHitResult bhr = (BlockHitResult)result;
                        BlockPos pos = bhr.m_82425_();
                        Block testBlock = player.m_9236_().m_8055_(pos).m_60734_();
                        displayLeft = new ItemStack((ItemLike)testBlock);
                        variantBlock = Client.getVariantOrOriginal(testBlock, savedVariant);
                    }
                } else {
                    variantBlock = VariantSelectorModule.getMainHandVariantBlock((Player)player, savedVariant);
                }
                if (variantBlock != null) {
                    ItemStack displayRight = new ItemStack((ItemLike)variantBlock);
                    if (displayLeft.m_41720_() == displayRight.m_41720_()) {
                        return;
                    }
                    Window window = event.getWindow();
                    int x = window.m_85445_() / 2;
                    int y = window.m_85446_() / 2 + 12;
                    if (alignHudToHotbar) {
                        HumanoidArm arm = (HumanoidArm)mc.f_91066_.m_232107_().m_231551_();
                        x = arm == HumanoidArm.RIGHT ? (x += 125) : (x -= 93);
                        y = window.m_85446_() - 19;
                    }
                    int offset = 8;
                    int width = 16;
                    displayLeft.m_41764_(1);
                    int posX = x - offset - width + hudOffsetX;
                    int posY = y + hudOffsetY;
                    if (!showSimpleHud) {
                        guiGraphics.m_280203_(displayLeft, posX, posY);
                        RenderSystem.enableBlend();
                        RenderSystem.blendFunc((int)770, (int)771);
                        RenderSystem.setShader(GameRenderer::m_172817_);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                        guiGraphics.m_280163_(ClientUtil.GENERAL_ICONS, posX + 8, posY, 0.0f, 141.0f, 22, 15, 256, 256);
                        posX += width * 2;
                    } else {
                        ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widget.png");
                        if (alignHudToHotbar) {
                            RenderSystem.enableBlend();
                            RenderSystem.blendFunc((int)770, (int)771);
                            RenderSystem.setShader(GameRenderer::m_172817_);
                            if (enableGreenTint) {
                                RenderSystem.setShaderColor((float)0.5f, (float)1.0f, (float)0.5f, (float)1.0f);
                            } else {
                                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            }
                            guiGraphics.m_280163_(WIDGETS_LOCATION, posX - 3, posY - 3, 24.0f, 23.0f, 22, 22, 256, 256);
                        } else {
                            posX += width;
                        }
                    }
                    guiGraphics.m_280203_(displayRight, posX, posY);
                }
            }
        }
    }
}

